/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base;

import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.BaseComponentSection;
import com.bmc.ctmconvert.base.BaseField;
import com.bmc.ctmconvert.base.BaseFooterPanel;
import com.bmc.ctmconvert.base.BaseScrollPane;
import com.bmc.ctmconvert.base.BaseSection;
import com.bmc.ctmconvert.base.BaseTitlePanel;
import com.bmc.ctmconvert.base.ConversionEvent;
import com.bmc.ctmconvert.common.FlowGlobals;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseContentPanel
extends BaseComponent {
    private JPanel borderPanel;
    private JPanel fullContentPanel;
    private BaseTitlePanel baseTitlePanel;
    private JPanel contentPanel;
    private BaseScrollPane baseScrollPane;
    private BaseFooterPanel baseFooterPanel;
    private boolean hasMadatoryFields;
    private boolean hasPaddingMadatoryFields;
    private boolean scrollable = true;
    private boolean disableSpacer = false;
    private ArrayList<BaseSection> sections;

    public BaseContentPanel() {
        this.initialize();
    }

    public BaseContentPanel(BaseTitlePanel title) {
        this.baseTitlePanel = title;
        this.initialize();
    }

    public BaseContentPanel(BaseFooterPanel baseFooter) {
        this.baseFooterPanel = baseFooter;
        this.initialize();
    }

    public BaseContentPanel(BaseTitlePanel title, BaseFooterPanel baseFooter) {
        this.baseTitlePanel = title;
        this.baseFooterPanel = baseFooter;
        this.initialize();
    }

    protected void initialize() {
        this.borderPanel = new JPanel();
        this.borderPanel.setLayout(new BorderLayout());
        this.borderPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(9, 10, 0, 9), FlowGlobals.customLowerBorder));
        this.borderPanel.setBackground(FlowGlobals.wrapperBackgroundColor);
        this.fullContentPanel = new JPanel();
        this.fullContentPanel.setLayout(new BorderLayout());
        this.sections = new ArrayList();
        if (this.baseTitlePanel != null) {
            this.fullContentPanel.add(this.baseTitlePanel.getComponent(), "North");
        }
        if (this.baseFooterPanel != null) {
            this.fullContentPanel.add(this.baseFooterPanel.getComponent(), "South");
        }
        this.borderPanel.add((Component)this.fullContentPanel, "Center");
    }

    public void setScrollable(boolean aFlag) {
        this.scrollable = aFlag;
        if (aFlag) {
            this.baseScrollPane = new BaseScrollPane(this.contentPanel);
            this.fullContentPanel.add((Component)this.baseScrollPane.getComponent(), "Center");
        } else if (this.contentPanel != null) {
            this.fullContentPanel.add((Component)this.contentPanel, "Center");
        }
    }

    public void setDisableSpacer(boolean aFlag) {
        this.disableSpacer = aFlag;
    }

    public BaseTitlePanel getBaseTitlePanel() {
        return this.baseTitlePanel;
    }

    public BaseFooterPanel getBaseFooterPanel() {
        return this.baseFooterPanel;
    }

    public boolean buildContentPanel() {
        this.contentPanel = new JPanel();
        this.contentPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.contentPanel.setBackground(Color.WHITE);
        GridBagLayout grid = new GridBagLayout();
        int columnCount = 10;
        int[] columnWidths = new int[]{10, 10, 7, 10, 200, 25, 240, 5, 25, 0};
        grid.columnWidths = columnWidths;
        this.contentPanel.setLayout(grid);
        GridBagConstraints gridConstraints = new GridBagConstraints();
        gridConstraints.insets = new Insets(10, 0, 0, 0);
        if (this.scrollable) {
            this.baseScrollPane = new BaseScrollPane(this.contentPanel);
            this.fullContentPanel.add((Component)this.baseScrollPane.getComponent(), "Center");
        } else {
            this.fullContentPanel.add((Component)this.contentPanel, "Center");
        }
        if (!this.sections.isEmpty()) {
            int gridY = 0;
            boolean firstSections = true;
            boolean hasSectionTitle = false;
            for (BaseSection section : this.sections) {
                GridBagConstraints sectionConstraints = new GridBagConstraints();
                sectionConstraints.insets = new Insets(0, 0, 10, 0);
                if (!firstSections && section.getName() != null) {
                    sectionConstraints.gridwidth = columnCount;
                    sectionConstraints.gridx = 0;
                    sectionConstraints.gridy = gridY++;
                    sectionConstraints.weightx = 0.5;
                    sectionConstraints.ipady = 0;
                    sectionConstraints.insets = new Insets(10, 0, 20, 0);
                    JSeparator separator = new JSeparator();
                    separator.setBackground(new Color(12305609));
                    this.contentPanel.add((Component)separator, sectionConstraints);
                    sectionConstraints.insets = new Insets(0, 0, 15, 0);
                    sectionConstraints.ipady = 0;
                }
                if (section.getName() != null) {
                    hasSectionTitle = true;
                    JLabel sectionTitle = new JLabel(section.getName());
                    sectionTitle.setFont(FlowGlobals.FONT_STYLE_BOLD);
                    sectionTitle.setForeground(FlowGlobals.ConversionBlue);
                    sectionConstraints.fill = 2;
                    sectionConstraints.gridwidth = columnCount;
                    sectionConstraints.gridx = 0;
                    sectionConstraints.gridy = gridY++;
                    sectionConstraints.weightx = 0.0;
                    this.contentPanel.add((Component)sectionTitle, sectionConstraints);
                }
                if (section instanceof BaseComponentSection) {
                    GridBagConstraints sectionConstraints1 = this.createSectionConstraints();
                    sectionConstraints1.gridy = gridY++;
                    sectionConstraints1.gridx = 0;
                    sectionConstraints1.gridwidth = columnCount;
                    sectionConstraints1.anchor = 21;
                    sectionConstraints1.fill = 2;
                    sectionConstraints1.weightx = 0.0;
                    this.contentPanel.add(((BaseComponentSection)section).getComponent(), sectionConstraints1);
                } else {
                    for (BaseField field : section.getFields()) {
                        this.addFieldToSection(columnCount, sectionConstraints, gridY, hasSectionTitle, field);
                        ++gridY;
                    }
                }
                if (!firstSections) continue;
                firstSections = false;
            }
            if (!this.disableSpacer) {
                JPanel spacer = new JPanel();
                spacer.setBackground(FlowGlobals.ConversionWhite);
                spacer.setPreferredSize(new Dimension(1, 1));
                gridConstraints.fill = 2;
                gridConstraints.gridwidth = columnCount;
                gridConstraints.gridx = 0;
                gridConstraints.gridy = gridY;
                gridConstraints.weightx = 0.5;
                gridConstraints.weighty = 1.0;
                gridConstraints.anchor = 20;
                this.contentPanel.add((Component)spacer, gridConstraints);
            }
        }
        return false;
    }

    private GridBagConstraints createSectionConstraints() {
        GridBagConstraints gridConstraints = new GridBagConstraints();
        gridConstraints.insets = new Insets(10, 0, 0, 0);
        return gridConstraints;
    }

    private void addFieldToSection(int columnCount, GridBagConstraints gridConstraints, int gridY, boolean hasSectionTitle, BaseField field) {
        int gridX;
        gridConstraints.insets = new Insets(8, 0, 0, 0);
        gridConstraints.fill = 2;
        int titleWidth = 1;
        int n = gridX = hasSectionTitle ? 1 : 0;
        if (field.getPadding() > 0) {
            gridX += this.hasPaddingMadatoryFields ? 1 : 2;
        } else if (field.getPadding() < 0) {
            --gridX;
            titleWidth += 3;
        } else {
            titleWidth += 2;
        }
        JLabel mandatory = field.getMandatoryLabel();
        if (mandatory != null) {
            gridConstraints.fill = 2;
            gridConstraints.gridwidth = titleWidth;
            gridConstraints.gridx = gridX++;
            gridConstraints.gridy = gridY;
            gridConstraints.weightx = 0.0;
            gridConstraints.anchor = 19;
            this.contentPanel.add((Component)mandatory, gridConstraints);
        } else if (this.hasMadatoryFields || this.hasPaddingMadatoryFields && field.getPadding() > 0) {
            ++gridX;
        } else {
            ++titleWidth;
        }
        if (this.hasPaddingMadatoryFields) {
            titleWidth += 2;
        }
        Component title = null;
        BaseComponent titleComponent = field.getTitleComponent();
        if (titleComponent != null) {
            title = titleComponent.getComponent();
        } else {
            title = field.getTitleLabel();
            title = this.handleTitleForSubSectionType(field, title);
        }
        if (title != null) {
            if (titleComponent != null) {
                gridConstraints.fill = 0;
                gridConstraints.anchor = 17;
                gridConstraints.gridwidth = titleWidth + 2;
            } else {
                gridConstraints.fill = 2;
                gridConstraints.anchor = 19;
                gridConstraints.gridwidth = titleWidth;
            }
            gridConstraints.gridx = gridX;
            gridConstraints.gridy = gridY;
            gridConstraints.weightx = 0.0;
            this.contentPanel.add(title, gridConstraints);
            gridX += titleWidth;
        }
        if (field.getBaseComponent() != null) {
            Component validityComponent;
            if (this.baseFooterPanel != null) {
                field.getBaseComponent().addDescriptionListener(this.baseFooterPanel);
            }
            if ((validityComponent = field.getBaseComponent().getValidityComponent()) != null) {
                gridConstraints.fill = 2;
                gridConstraints.gridwidth = 1;
                gridConstraints.gridx = gridX++;
                gridConstraints.gridy = gridY;
                gridConstraints.weightx = 0.0;
                gridConstraints.anchor = 19;
                this.contentPanel.add(validityComponent, gridConstraints);
            } else if (title != null) {
                ++gridX;
            }
            int gridWidth = columnCount - gridX - 3;
            if (field.fillAllArea()) {
                gridWidth += 3;
            } else if (field.fillFieldSize()) {
                gridConstraints.fill = 0;
                gridConstraints.anchor = 21;
            }
            gridConstraints.gridwidth = gridWidth;
            gridConstraints.gridx = gridX;
            gridConstraints.gridy = gridY;
            gridConstraints.weightx = gridX < 4 ? 0.5 : 0.3;
            this.contentPanel.add(field.getBaseComponent().getComponent(), gridConstraints);
            Component extraComponent = field.getBaseComponent().getExtraComponent();
            if (extraComponent != null) {
                gridX = field.getBaseComponent().getExtraComponentGridX() != 0 ? field.getBaseComponent().getExtraComponentGridX() : (gridX += 2);
                gridConstraints.fill = 2;
                gridConstraints.gridwidth = 1;
                gridConstraints.gridx = gridX;
                gridConstraints.gridy = gridY;
                gridConstraints.weightx = 0.0;
                gridConstraints.anchor = 19;
                this.contentPanel.add(extraComponent, gridConstraints);
            }
        }
        if (!field.fillAllArea()) {
            gridConstraints.fill = 2;
            gridConstraints.gridwidth = 1;
            gridConstraints.gridx = columnCount - 1;
            gridConstraints.gridy = gridY;
            gridConstraints.weightx = 0.7;
            JPanel fillingArea = new JPanel();
            fillingArea.setBackground(FlowGlobals.ConversionWhite);
            this.contentPanel.add((Component)fillingArea, gridConstraints);
        }
    }

    private Component handleTitleForSubSectionType(BaseField field, Component title) {
        if (title == null) {
            title = field.getTitleFieldLabelForSubSectionTitle();
        }
        return title;
    }

    public void setBorder(Border border) {
        this.borderPanel.setBorder(border);
    }

    public void clearContentPanel() {
        this.fullContentPanel.remove(this.baseTitlePanel.getComponent());
        this.fullContentPanel.remove(this.baseFooterPanel.getComponent());
        this.contentPanel.removeAll();
        this.contentPanel.validate();
        this.sections.clear();
    }

    public boolean addSection(BaseSection section) {
        if (section != null) {
            section.addValidityListener(this);
            this.sections.add(section);
            if (!this.hasMadatoryFields) {
                for (BaseField field : section.getFields()) {
                    if (!field.isMandatory()) continue;
                    if (field.getPadding() > 0 && section.getName() == null) {
                        this.hasPaddingMadatoryFields = true;
                        continue;
                    }
                    this.hasMadatoryFields = true;
                }
            }
            return true;
        }
        return false;
    }

    public void setContentPanel(BaseComponent panel) {
        this.setContentPanel(panel.getComponent());
    }

    public void setContentPanel(Component panel) {
        if (this.contentPanel != null) {
            this.fullContentPanel.remove(this.contentPanel);
        }
        this.fullContentPanel.add(panel, "Center");
        this.fullContentPanel.validate();
        this.fullContentPanel.repaint();
    }

    @Override
    public Component getComponent() {
        return this.borderPanel;
    }

    @NotNull
    public int sectionsCount() {
        return this.sections.size();
    }

    @Override
    public void validityActionPerformed(ConversionEvent e) {
        this.verifyValidity();
    }

    public void verifyValidity() {
        for (BaseSection section : this.sections) {
            if (section.isValid()) continue;
            this.setValid(false);
            return;
        }
        this.setValid(true);
    }

    @Nullable
    public Optional<Integer> fieldsCountOfSection(int i) {
        return Optional.of(this.sections).filter(s -> s.size() > i).map(s -> ((BaseSection)s.get(i)).getFields().size());
    }
}

