/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base;

import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.BaseSection;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JPanel;

public class BaseComponentSection
extends BaseSection {
    JPanel sectionPanel = new JPanel();

    public BaseComponentSection() {
        this.sectionPanel.setLayout(new BorderLayout());
    }

    public Component getComponent() {
        return this.sectionPanel;
    }

    public Grid createGrid(int width, int height) {
        return new Grid(width, height);
    }

    public void setGrid(Grid grid) {
        this.sectionPanel.add(grid.gridPanel);
    }

    public Cell createCell(int x, int y, BaseComponent component) {
        return new Cell(this, component).setXY(x, y);
    }

    public Cell createCell(int x, int y, Component component) {
        return new Cell(this, component).setXY(x, y);
    }

    public static GridBagConstraints createGbc(int x, int y) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.anchor = x == 0 ? 17 : 13;
        gbc.fill = x == 0 ? 1 : 2;
        gbc.insets = x == 0 ? new Insets(0, 0, 0, 2) : new Insets(0, 0, 0, 0);
        gbc.weightx = x == 0 ? 0.1 : 1.0;
        gbc.weighty = 1.0;
        return gbc;
    }

    public class Grid {
        private JPanel gridPanel = new JPanel(new GridBagLayout());
        int maxX = 0;
        private GridBagConstraints gridConstraints = new GridBagConstraints();

        public Grid(int width, int height) {
            this.gridConstraints.anchor = 17;
            GridBagConstraints glueGridConstraints = new GridBagConstraints();
            glueGridConstraints.fill = 0;
            glueGridConstraints.weighty = 1.0;
            glueGridConstraints.weightx = 1.0;
            glueGridConstraints.anchor = 19;
            int[] columnWidths = new int[width];
            for (int i = 0; i < height; ++i) {
                int j = 0;
                while (j < width) {
                    columnWidths[j] = 0;
                    glueGridConstraints.gridx = i;
                    glueGridConstraints.gridy = j++;
                }
            }
            ((GridBagLayout)this.gridPanel.getLayout()).columnWidths = columnWidths;
        }

        public Grid addCell(Cell cell) {
            return this.addCell(cell, 0);
        }

        public Grid addCell(Cell cell, int cellWidth) {
            GridBagConstraints gridConstraints = cell.gridConstraints;
            ((GridBagLayout)this.gridPanel.getLayout()).columnWidths[cell.gridConstraints.gridx] = cellWidth;
            this.gridPanel.add(cell.component, gridConstraints);
            return this;
        }

        public Grid addGrid(int x, int y, Grid newGrid) {
            GridBagConstraints newGridConstraints = newGrid.gridConstraints;
            newGridConstraints.gridx = x;
            newGridConstraints.gridy = y;
            newGridConstraints.weightx = 0.0;
            this.gridPanel.add((Component)newGrid.gridPanel, newGridConstraints);
            return this;
        }

        public Grid addHorizontalGap(int x, int y, int width) {
            this.addCell(BaseComponentSection.this.createCell(x, y, Box.createHorizontalStrut(width)).weightX(1.0));
            return this;
        }

        public Grid addVerticalGap(int x, int y, int height) {
            this.addCell(BaseComponentSection.this.createCell(x, y, Box.createVerticalStrut(height)).setweightY(1.0));
            return this;
        }

        public Grid weightX(double weight) {
            this.gridConstraints.weightx = weight;
            return this;
        }
    }

    public class Cell {
        public Component component;
        public GridBagConstraints gridConstraints = new GridBagConstraints();

        public Cell(BaseComponentSection this$0, BaseComponent component) {
            this(this$0, component.getComponent());
        }

        public Cell weightX(double weight) {
            this.gridConstraints.weightx = weight;
            return this;
        }

        public Cell(BaseComponentSection this$0, Component component) {
            this.gridConstraints.gridx = 0;
            this.gridConstraints.gridy = 0;
            this.gridConstraints.insets = new Insets(0, 4, 0, 4);
            this.gridConstraints.fill = 0;
            this.gridConstraints.weightx = 0.0;
            this.gridConstraints.anchor = 21;
            this.component = component;
        }

        public Cell setXY(int x, int y) {
            this.gridConstraints.gridx = x;
            this.gridConstraints.gridy = y;
            return this;
        }

        public Cell setHeight(int height) {
            this.gridConstraints.gridheight = height;
            return this;
        }

        public Cell setWidth(int width) {
            this.gridConstraints.gridwidth = width;
            return this;
        }

        public Cell setweightY(double weight) {
            this.gridConstraints.weighty = weight;
            return this;
        }

        public Cell setAnchor(int anchor) {
            this.gridConstraints.anchor = anchor;
            return this;
        }

        public Cell setInsets(Insets insets) {
            this.gridConstraints.insets = insets;
            return this;
        }
    }
}

