/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.api;

import com.bmc.ctmconvert.scriptelement.CtmBaseEntity;

public class DatabasesParametersAPI {
    private final CtmBaseEntity entity;
    private DatabasesExecutionType executionType;
    private String connectionProfile;
    private String MSSQLAgentJobName;

    public DatabasesParametersAPI(CtmBaseEntity entity) {
        this.entity = entity;
        this.setMembersDefaultValues();
    }

    private void setMembersDefaultValues() {
        this.executionType = DatabasesExecutionType.StoredProcedure;
        this.connectionProfile = "";
        this.MSSQLAgentJobName = "";
    }

    public void setExecutionType(DatabasesExecutionType executionType) {
        this.executionType = executionType;
        this.entity.setVariable("%%DB-EXEC_TYPE", executionType.toString());
    }

    public DatabasesExecutionType getExecutionType() {
        return this.executionType;
    }

    public void setConnectionProfile(String connectionProfile) {
        this.connectionProfile = connectionProfile;
        this.entity.setVariable("%%DB-ACCOUNT", connectionProfile);
    }

    public String getConnectionProfile() {
        return this.connectionProfile;
    }

    public void setMSSQLAgentJobName(String jobName) {
        this.MSSQLAgentJobName = jobName;
        this.entity.setVariable("%%DB-SSA_NAME", jobName);
    }

    public String getMSSQLAgentJobName() {
        return this.MSSQLAgentJobName;
    }

    public static enum DatabasesExecutionType {
        MSSQLAgentJob("MSSQL Agent Job"),
        StoredProcedure("Stored Procedure"),
        SqlScript("SQL Script"),
        EmbeddedQuery("Open Query"),
        SSISPackage("SSIS Package");

        private final String value;

        private DatabasesExecutionType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

