/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.api;

import com.bmc.ctmconvert.scriptelement.CtmBaseEntity;

public class CtmTransfer {
    private final int transferNumber;
    private final CtmBaseEntity entity;

    public CtmTransfer(CtmBaseEntity entity, int transferNumber) {
        this.entity = entity;
        this.transferNumber = transferNumber;
        this.setVariable("%%%%FTP-TYPE%01d", "I");
    }

    public void setLeftPath(String leftPath) {
        this.setVariable("%%%%FTP-LPATH%01d", leftPath);
    }

    public void setRightPath(String rightPath) {
        this.setVariable("%%%%FTP-RPATH%01d", rightPath);
    }

    public void setTransferType(TransferType transferType) {
        this.setVariable("%%%%FTP-TYPE%01d", transferType.toString());
    }

    public void setTransferOption(TransferOption transferOption) {
        this.setVariable("%%%%FTP-UPLOAD%01d", transferOption.toString());
    }

    public void setVariable(String variableFormat, String variableValue) {
        this.entity.setVariable(String.format(variableFormat, this.transferNumber), variableValue);
    }

    public CtmTransfer setDefaultIntervalBetweenFileSearches(String interval) {
        this.setVariable("%%%%FTP-OVERRIDE_WATCH_INTERVAL%01d", interval);
        return this;
    }

    public CtmTransfer changeMinimumDetectedSize(String size) {
        this.setVariable("%%%%FTP-MINSIZE%01d", size);
        return this;
    }

    public CtmTransfer setMinimumFileAge(String minimumFileAge) {
        this.setVariable("%%%%FTP-FILE_MIN_AGE%01d", minimumFileAge);
        return this;
    }

    public static enum TransferType {
        Binary("I"),
        Ascii("A"),
        EBCDIC("E");

        private final String name;

        private TransferType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum TransferOption {
        Transfer_from_left_to_right("1"),
        Transfer_from_right_to_left("0"),
        Filewatch_And_Transfer_from_left_to_right("3"),
        Filewatch_And_Transfer_from_right_to_left("2"),
        Filewatch_Only("4");

        private final String name;

        private TransferOption(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

