/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.cnvvalidation;

import com.bmc.cnvvalidation.CommonJobFH;
import com.bmc.cnvvalidation.ExternalParameters;
import com.bmc.cnvvalidation.LegacyReportInputStreamSuplier;
import com.bmc.cnvvalidation.LoadReport;
import com.bmc.cnvvalidation.ReportingClient;
import com.bmc.ctmconvert.io.csv.CsvReader;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class LoadExecutionHistoryReport
extends LoadReport {
    private final String mOdate;
    private final SimpleDateFormat localeDateFormat;
    private CsvReader csvReader;

    public LoadExecutionHistoryReport(String sOdate, ExternalParameters externalParameters) throws IllegalArgumentException {
        super(externalParameters);
        this.mOdate = sOdate;
        LegacyReportInputStreamSuplier histExecReportStreamSupplier = this.getControlMHistoryExecutionReport(externalParameters);
        this.init(histExecReportStreamSupplier);
        Calendar compareDateCal = Calendar.getInstance();
        compareDateCal.set(Integer.parseInt(this.mOdate.substring(0, 4)), Integer.parseInt(this.mOdate.substring(4, 6)) - 1, Integer.parseInt(this.mOdate.substring(6)));
        this.reportIsFromLast30days(compareDateCal);
        this.localeDateFormat = this.initLocalDateFormat();
    }

    private LegacyReportInputStreamSuplier getControlMHistoryExecutionReport(ExternalParameters externalParameters) {
        LegacyReportInputStreamSuplier histExecReportStreamSupplier = externalParameters.getCtmHistExecReport();
        if (histExecReportStreamSupplier == null) {
            String mHistExecReport = "workarea\\cnvvhistexec_" + this.mOdate + ".csv";
            this.downloadHistoryReportFromAAPI(mHistExecReport);
            externalParameters.setCtmHistExecReport(mHistExecReport);
        }
        return externalParameters.getCtmHistExecReport();
    }

    private SimpleDateFormat initLocalDateFormat() {
        String dateFormat = Optional.ofNullable(System.getenv().get("EMREPORTINGFACILITYDATEFORMAT")).map(value -> {
            if (value.equals("EU")) {
                return "\"dd/MM/yy HH:mm:ssa\"";
            }
            return value;
        }).orElse("MMMM dd, yyyy hh:mm:ss a");
        return new SimpleDateFormat(dateFormat);
    }

    private void reportIsFromLast30days(Calendar compareDateCal) {
        Date compareDate = compareDateCal.getTime();
        Date todayDate = new Date();
        long compareTime = compareDate.getTime();
        long todayTime = todayDate.getTime();
        long diffTime = todayTime - compareTime;
        long diffDays = diffTime / 86400000L;
        if (diffDays > 30L) {
            throw new IllegalArgumentException("Legacy report date exceeds the 30 days limit. Unable to extract Control-M Execution History data");
        }
    }

    public void downloadHistoryReportFromAAPI(String downloadLocation) throws IllegalArgumentException {
        new ReportingClient(this.externalParameters).downloadReportTo(downloadLocation);
    }

    @Override
    protected CommonJobFH nextJobInternal() {
        try {
            while (this.csvReader.readRecord()) {
                String localStartTime;
                String utcStartTime;
                String jobDate;
                List<String> line = List.of(this.csvReader.getValues());
                ExecutionReportEntry entry = new ExecutionReportEntry(line);
                if (entry.isHeaders() || !this.isSameOrderDate(jobDate = this.getJobDate(utcStartTime = entry.get("START")), localStartTime = this.getLocalStartTime(utcStartTime))) continue;
                return this.createHistoryReportJob(entry, localStartTime);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private CommonJobFH createHistoryReportJob(ExecutionReportEntry entry, String localStartTime) {
        String utcEndTime = entry.get("END");
        String localEndTime = this.localEndTime(this.localeDateFormat, utcEndTime);
        return new CommonJobFH(entry.get("JOB_MEM_NAME"), "", entry.get("DATA_CENTER"), entry.get("PARENT_TABLE"), "", entry.get("RUN_COUNT"), localStartTime, localEndTime, this.mOdate, this.date.toString(), "", "Control-M", "", entry.get("orderDate"));
    }

    private boolean isSameOrderDate(String jobDate, String localStartTime) {
        try {
            String hhmmTime = localStartTime.substring(0, 2) + localStartTime.substring(3, 5);
            return this.mOdate.equals(this.adjustByNewdayTime(jobDate, hhmmTime));
        }
        catch (ParseException ignore) {
            return false;
        }
    }

    private String localEndTime(SimpleDateFormat inputFormat, String utcEndTime) {
        try {
            Date cnvDate = inputFormat.parse(utcEndTime);
            return this.dateFormatter.timeFormatWithSec.format(cnvDate);
        }
        catch (ParseException e) {
            return "";
        }
    }

    @Override
    protected void init(LegacyReportInputStreamSuplier legacyForecastReport) {
        super.init(legacyForecastReport);
        this.csvReader = new CsvReader((Reader)this.br);
    }

    @NotNull
    private String getLocalStartTime(String utcStartTime) {
        try {
            Date cnvDate = this.localeDateFormat.parse(utcStartTime);
            return this.dateFormatter.timeFormatWithSec.format(cnvDate);
        }
        catch (ParseException e) {
            return "";
        }
    }

    private String getJobDate(String utcStartTime) {
        try {
            Date dateFromRep = this.localeDateFormat.parse(utcStartTime);
            return this.dateFormatter.dateFormatyyyyMMdd.format(dateFromRep);
        }
        catch (ParseException e) {
            return "";
        }
    }

    private static class ExecutionReportEntry {
        private static final List<String> COLUMNS = List.of("orderId", "DATA_CENTER", "PARENT_TABLE", "DSN", "JOB_MEM_NAME", "RUN_COUNT", "Application", "SubApplication", "START", "END", "RUN_TIME", "orderDate");
        private final List<String> entry;

        public ExecutionReportEntry(List<String> entry) {
            this.entry = entry;
        }

        public boolean isHeaders() {
            return this.entry.get(0).equalsIgnoreCase("Order ID");
        }

        public String get(String name) {
            int idx = COLUMNS.indexOf(name);
            return this.entry.get(idx);
        }
    }
}

