/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.cnvvalidation;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;

public class ExternalCommand {
    private final ProcessBuilder processBuilder;
    private final String command;
    private final String redirectOutputFile;
    private int exitValue;
    private String exitErrors = null;

    public ExternalCommand(String command, String redirectOutputFile) {
        this.redirectOutputFile = redirectOutputFile;
        this.command = command + " 2>" + redirectOutputFile;
        this.processBuilder = new ProcessBuilder("cmd", "/C", this.command);
    }

    public void start() throws IOException, InterruptedException {
        Process process = this.processBuilder.start();
        this.exitValue = process.waitFor();
        if (this.exitValue != 0) {
            this.exitErrors = new String(Files.readAllBytes(Paths.get(this.redirectOutputFile, new String[0]))).trim();
        }
    }

    public int getExitValue() {
        return this.exitValue;
    }

    public String getExitErrors() {
        return this.exitErrors;
    }

    public String getCommand() {
        return this.command;
    }

    public String toString() {
        return "External Command: " + this.command + (String)(this.redirectOutputFile != null ? " STDERR > " + this.redirectOutputFile : "") + " Return value [" + this.exitValue + "]" + (String)(this.exitErrors != null ? " Return errors [" + this.exitErrors + "]" : "");
    }
}

