/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.cnvvalidation;

import com.bmc.cnvvalidation.CommonJobFH;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

class ExcludeFile {
    private final Set<String> excludeJobs;

    public ExcludeFile(String filePath) {
        this.excludeJobs = this.readFile(filePath);
    }

    private List<String> readLines(String filename) {
        try {
            return Files.readAllLines(Paths.get(filename, new String[0]));
        }
        catch (IOException ignore) {
            return Collections.emptyList();
        }
    }

    private Set<String> readFile(String filePath) {
        List lines = Optional.ofNullable(filePath).map(this::readLines).orElse(Collections.emptyList());
        return lines.stream().filter(line -> !line.startsWith("#")).collect(Collectors.toSet());
    }

    public boolean isExcluded(CommonJobFH job) {
        return Optional.ofNullable(job).map(CommonJobFH::getJobMemName).map(this.excludeJobs::contains).orElse(false);
    }
}

