/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.cnvvalidation;

import com.bmc.cnvvalidation.CommonJobFH;
import com.bmc.cnvvalidation.CommonRepositoryReader;
import com.bmc.cnvvalidation.ExternalParameters;
import com.bmc.cnvvalidation.Globals;
import com.bmc.cnvvalidation.report.ReportWriter;
import java.io.IOException;
import java.time.Duration;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CompareReports {
    private final String forecastCompareLevel;
    private final boolean includeOKJobs;
    private final CommonRepositoryReader legacySortedRepository;
    private final CommonRepositoryReader controlmSortedRepository;
    private final String[] filterByControlM;
    private final String[] filterByFolder;
    private final String[] filterByJobname;
    private Integer filteredCounter = 0;
    private final ReportWriter reportWriter;
    private final ZoneOffset legacyReportTimeZone;

    public CompareReports(CommonRepositoryReader legacySortedRepository, CommonRepositoryReader controlmSortedRepository, ExternalParameters externalParameters, ReportWriter reportWriter) {
        this.legacySortedRepository = legacySortedRepository;
        this.controlmSortedRepository = controlmSortedRepository;
        this.forecastCompareLevel = externalParameters.getForecastCompareLevel();
        this.includeOKJobs = "YES".equals(externalParameters.getIncludeOKJobs());
        this.legacyReportTimeZone = externalParameters.getLegacyTZ();
        this.filterByControlM = externalParameters.getFilterByControlM().split(",");
        this.filterByFolder = externalParameters.getFilterByFolder().split(",");
        this.filterByJobname = externalParameters.getFilterByJobname().split(",");
        this.reportWriter = reportWriter;
    }

    @NotNull
    public List<String> compareSortedCtmLeg() throws Exception {
        LinkedList<String> ll = new LinkedList<String>();
        int onSameTimeCounter = 0;
        int onDifferentTimeCounter = 0;
        int onlyCtmCounter = 0;
        HashMap<String, Integer> onlyLegCounterMap = new HashMap<String, Integer>();
        this.filteredCounter = 0;
        this.skipTitle();
        CommonJobFH legacyJob = this.legacySortedRepository.fetch();
        CommonJobFH ctmJob = this.ctmFetchFiltered(this.controlmSortedRepository);
        while (this.isValidJobs(legacyJob, ctmJob)) {
            if (this.isOnSameDayAndTime(legacyJob, ctmJob)) {
                if (this.includeOKJobs) {
                    this.reportWriter.reportJob(ctmJob, legacyJob, Globals.bothOnSameTime(this.forecastCompareLevel));
                }
                ++onSameTimeCounter;
                legacyJob = this.legacySortedRepository.fetch();
                ctmJob = this.ctmFetchFiltered(this.controlmSortedRepository);
                continue;
            }
            if (this.isOnSameDay(legacyJob, ctmJob)) {
                if (this.includeOKJobs) {
                    this.reportWriter.reportJob(ctmJob, legacyJob, Globals.bothOnSameDayAndDifferentTime(this.forecastCompareLevel));
                }
                ++onDifferentTimeCounter;
                legacyJob = this.legacySortedRepository.fetch();
                ctmJob = this.ctmFetchFiltered(this.controlmSortedRepository);
                continue;
            }
            if (ctmJob.getJobMemName().compareTo(legacyJob.getJobMemName()) < 0) {
                this.reportWriter.reportJob(ctmJob, legacyJob, "Only in Control-M");
                ++onlyCtmCounter;
                ctmJob = this.ctmFetchFiltered(this.controlmSortedRepository);
                continue;
            }
            this.reportWriter.reportJob(null, legacyJob, "Only in " + legacyJob.getOrigin());
            if (!onlyLegCounterMap.containsKey(legacyJob.getOrigin())) {
                onlyLegCounterMap.put(legacyJob.getOrigin(), 1);
            } else {
                onlyLegCounterMap.put(legacyJob.getOrigin(), (Integer)onlyLegCounterMap.get(legacyJob.getOrigin()) + 1);
            }
            legacyJob = this.legacySortedRepository.fetch();
        }
        while (ctmJob != null) {
            this.reportWriter.reportJob(ctmJob, legacyJob, "Only in Control-M");
            ++onlyCtmCounter;
            ctmJob = this.controlmSortedRepository.fetch();
        }
        while (legacyJob != null) {
            this.reportWriter.reportJob(null, legacyJob, "Only in " + legacyJob.getOrigin());
            if (!onlyLegCounterMap.containsKey(legacyJob.getOrigin())) {
                onlyLegCounterMap.put(legacyJob.getOrigin(), 1);
            } else {
                onlyLegCounterMap.put(legacyJob.getOrigin(), (Integer)onlyLegCounterMap.get(legacyJob.getOrigin()) + 1);
            }
            legacyJob = this.legacySortedRepository.fetch();
        }
        if (this.filteredCounter > 0) {
            ll.add("  Number of Control-M " + this.forecastCompareLevel + " filtered out: " + this.filteredCounter.toString());
        }
        ll.add("  Number of " + Globals.bothOnSameTime(this.forecastCompareLevel) + ": " + onSameTimeCounter);
        ll.add("  Number of " + Globals.bothOnSameDayAndDifferentTime(this.forecastCompareLevel) + ": " + onDifferentTimeCounter);
        ll.add("  Number of " + this.forecastCompareLevel + " only in Control-M: " + onlyCtmCounter);
        for (String legacyName : onlyLegCounterMap.keySet()) {
            ll.add("  Number of " + this.forecastCompareLevel + " only in " + legacyName + ": " + ((Integer)onlyLegCounterMap.get(legacyName)).toString());
        }
        this.reportWriter.close();
        return ll;
    }

    private void skipTitle() throws IOException {
        this.legacySortedRepository.fetch();
        this.controlmSortedRepository.fetch();
    }

    private boolean isValidJobs(CommonJobFH legacyJob, CommonJobFH ctmJob) {
        return ctmJob != null && legacyJob != null;
    }

    boolean isOnSameDayAndTime(CommonJobFH legacyJob, CommonJobFH ctmJob) {
        return this.isOnSameDay(legacyJob, ctmJob) && this.isOnSameTime(legacyJob, ctmJob);
    }

    private boolean isOnSameTime(CommonJobFH legacyJob, CommonJobFH ctmJob) {
        return Duration.between(legacyJob.getStartRunTime(this.legacyReportTimeZone), ctmJob.getStartRunTime()).toHours() == 0L;
    }

    private boolean isOnSameDay(CommonJobFH legacyJob, CommonJobFH ctmJob) {
        return ctmJob.getJobMemName().equals(legacyJob.getJobMemName()) && ctmJob.getJobMemNameOccurrence().equals(legacyJob.getJobMemNameOccurrence());
    }

    private CommonJobFH ctmFetchFiltered(CommonRepositoryReader crCtm) throws IOException {
        CommonJobFH cj;
        while ((cj = crCtm.fetch()) != null) {
            Integer n;
            int filterItem;
            boolean matched;
            if (this.filterByControlM.length > 0) {
                matched = false;
                for (filterItem = 0; filterItem < this.filterByControlM.length; ++filterItem) {
                    if (this.filterByControlM[filterItem].length() > 0) {
                        if (this.filterByControlM[filterItem].substring(this.filterByControlM[filterItem].length() - 1).equals("*")) {
                            if (!cj.getControlm().toUpperCase().startsWith(this.filterByControlM[filterItem].substring(0, this.filterByControlM[filterItem].length() - 1).toUpperCase())) continue;
                            matched = true;
                            continue;
                        }
                        if (!cj.getControlm().equalsIgnoreCase(this.filterByControlM[filterItem])) continue;
                        matched = true;
                        continue;
                    }
                    matched = true;
                }
                if (!matched) {
                    n = this.filteredCounter;
                    this.filteredCounter = this.filteredCounter + 1;
                    continue;
                }
            }
            if (this.filterByFolder.length > 0) {
                matched = false;
                for (filterItem = 0; filterItem < this.filterByFolder.length; ++filterItem) {
                    if (this.filterByFolder[filterItem].length() > 0) {
                        if (this.filterByFolder[filterItem].substring(this.filterByFolder[filterItem].length() - 1).equals("*")) {
                            if (!cj.getFolder().toUpperCase().startsWith(this.filterByFolder[filterItem].substring(0, this.filterByFolder[filterItem].length() - 1).toUpperCase())) continue;
                            matched = true;
                            continue;
                        }
                        if (!cj.getFolder().equalsIgnoreCase(this.filterByFolder[filterItem])) continue;
                        matched = true;
                        continue;
                    }
                    matched = true;
                }
                if (!matched) {
                    n = this.filteredCounter;
                    this.filteredCounter = this.filteredCounter + 1;
                    continue;
                }
            }
            if (this.filterByJobname.length > 0) {
                matched = false;
                for (filterItem = 0; filterItem < this.filterByJobname.length; ++filterItem) {
                    if (this.filterByJobname[filterItem].length() > 0) {
                        if (this.filterByJobname[filterItem].substring(this.filterByJobname[filterItem].length() - 1).equals("*")) {
                            if (!cj.getJobMemName().toUpperCase().startsWith(this.filterByJobname[filterItem].substring(0, this.filterByJobname[filterItem].length() - 1).toUpperCase())) continue;
                            matched = true;
                            continue;
                        }
                        if (!cj.getJobMemName().equalsIgnoreCase(this.filterByJobname[filterItem])) continue;
                        matched = true;
                        continue;
                    }
                    matched = true;
                }
                if (!matched) {
                    n = this.filteredCounter;
                    this.filteredCounter = this.filteredCounter + 1;
                    continue;
                }
            }
            return cj;
        }
        return null;
    }
}

