/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tws.tasks;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.tws.TwsBaseConvertor;
import com.bmc.ctmconvert.tws.TwsJob;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class TwsTaskSapBOConvertor
implements TwsBaseConvertor {
    private TwsJob job;
    private XmlElement taskDefinitionXml;

    @Override
    public void convert() {
        this.handleCommon();
        this.handleReportTypeAndOutputFormat();
        this.handleReportName();
        this.handleUser();
        this.handleSystem();
        this.handleConnectionProfile();
        this.handleCUID();
        this.handleReportOwner();
        this.handleInstanceTitle();
        this.handleOutputDestination();
    }

    private void handleOutputDestination() {
        List emailDestinationXml = this.taskDefinitionXml.getAllDecnedElementByName("jsdlsapbusinessobjects:emailDestinationRadioButton");
        emailDestinationXml.stream().findFirst().ifPresentOrElse(this::handleEmailOutputDestination, this::createDefaultOutputDestination);
    }

    private void createDefaultOutputDestination() {
        this.job.addAutoEdits("%%BO-SELECTED_DESTINATIONS", "Default");
    }

    private void handleEmailOutputDestination(XmlElement emailDestination) {
        this.job.addAutoEdits("%%BO-SELECTED_DESTINATIONS", "Email Recipients");
        this.job.addAutoEdits("%%BO-DEST-EMAIL-FROM", this.getValueOfOrEmpty("jsdlsapbusinessobjects:emailFrom"));
        this.job.addAutoEdits("%%BO-DEST-EMAIL-TO", this.getValueOfOrEmpty("jsdlsapbusinessobjects:emailTo"));
        this.job.addAutoEdits("%%BO-DEST-EMAIL-CC", this.getValueOfOrEmpty("jsdlsapbusinessobjects:emailCc"));
        this.job.addAutoEdits("%%BO-DEST-EMAIL-SUBJECT", this.getValueOfOrEmpty("jsdlsapbusinessobjects:emailSubject"));
        this.job.addAutoEdits("%%BO-DEST-EMAIL-MSG", this.getValueOfOrEmpty("jsdlsapbusinessobjects:emailMessage"));
        this.job.addAutoEdits("%%BO-DEST-EMAIL-OUTPUT_NAME", this.getValueOfOrEmpty("jsdlsapbusinessobjects:emailUseSpecificFileName"));
    }

    private void handleInstanceTitle() {
        String instanceTitle = this.getReportName();
        this.job.addAutoEdits("%%BO-INST_NAME", instanceTitle);
    }

    private void handleReportOwner() {
        String reportOwner = this.getUsername();
        this.job.addAutoEdits("%%BO-SUBMIT_USER", reportOwner);
    }

    private void handleCUID() {
        String cuId = this.getCuID();
        this.job.addAutoEdits("%%BO-CUID", cuId);
    }

    private String getCuID() {
        int idGroup = 2;
        return this.getGroupFromReportNameWithId(idGroup);
    }

    @NotNull
    private String getGroupFromReportNameWithId(int group) {
        String reportNameWithId = this.getValueOfOrEmpty("jsdlsapbusinessobjects:BOObject");
        String regex = "(.*?)\\(rid:(\\d+)\\)";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(reportNameWithId);
        if (matcher.matches()) {
            return matcher.group(group).trim();
        }
        return "";
    }

    private void handleConnectionProfile() {
        String username = this.getUsername();
        this.job.addAutoEdits("%%BO-ACCOUNT", username);
    }

    @NotNull
    private String getUsername() {
        return this.getValueOfOrEmpty("jsdlsapbusinessobjects:username");
    }

    private void handleSystem() {
        String system = this.getValueOfOrEmpty("jsdlsapbusinessobjects:server");
        this.job.addAutoEdits("%%BO-BO_SERVER", system);
    }

    private void handleCommon() {
        this.job.addAttribute("TASKTYPE", "Job");
        this.job.addAttribute("APPL_TYPE", "SAP_BO");
        this.job.addAttribute("APPL_FORM", "SAP Business Objects");
        this.job.addAutoEdits("%%BO-EXEC_TYPE", "Business Objects Report");
    }

    private void handleUser() {
        String username = this.getUsername();
        this.job.addAutoEdits("%%BO-BO_USER", username);
    }

    private void handleReportName() {
        String reportName = this.getReportName();
        this.job.addAutoEdits("%%BO-REPORT_NAME", reportName);
    }

    @NotNull
    private String getReportName() {
        int reportNameGroup = 1;
        return this.getGroupFromReportNameWithId(reportNameGroup);
    }

    @NotNull
    private String getValueOfOrEmpty(String tagName) {
        return this.taskDefinitionXml.getAllDecnedElementByName(tagName).stream().findFirst().map(XmlElement::getValue).orElse("");
    }

    private void handleReportTypeAndOutputFormat() {
        List taskSapBOTypeList = this.taskDefinitionXml.getAllDecnedElementByName("jsdlsapbusinessobjects:Webi");
        Optional webiXml = taskSapBOTypeList.stream().findFirst();
        if (webiXml.isPresent()) {
            this.job.addAutoEdits("%%BO-REPORT_TYPE", "Web Intelligence");
            this.handleFormatType((XmlElement)webiXml.get());
        }
    }

    private void handleFormatType(XmlElement execType) {
        String formatType;
        String selectedFormat = switch (formatType = execType.getValueOfFirstChildElementByName("jsdlsapbusinessobjects:formatType")) {
            case "xls" -> "Excel";
            case "pdf" -> "PDF";
            case "webi" -> "Webi";
            default -> "Default";
        };
        this.job.addAutoEdits("%%BO-SELECTED_FORMATS", selectedFormat);
    }

    @Override
    public void init(TwsJob twsJob, XmlElement taskDefinitionXml) {
        this.job = twsJob;
        this.taskDefinitionXml = taskDefinitionXml;
    }
}

