/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tws.tasks;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.tws.TwsBaseConvertor;
import com.bmc.ctmconvert.tws.TwsJob;
import com.bmc.ctmconvert.tws.VarTable;
import com.bmc.ctmconvert.tws.variables.VariablesHandler;
import java.util.List;

public class TwsTaskRestfulConvertor
implements TwsBaseConvertor {
    private TwsJob twsJob;
    private XmlElement taskDefintionXml;
    private VariablesHandler variablesHandler;

    @Override
    public void convert() {
        String method;
        this.twsJob.setOptionalAtrribute("TASKTYPE", "Job");
        this.twsJob.setOptionalAtrribute("APPL_FORM", "WS");
        this.twsJob.setOptionalAtrribute("APPL_TYPE", "WS");
        this.twsJob.setOptionalAtrribute("APPL_VER", "9.0.18.200");
        this.twsJob.setOptionalAtrribute("CM_VER", "N/A");
        this.twsJob.addAutoEdits("%%WS-TYPE", "REST");
        this.twsJob.addAutoEdits("%%WS-REQTYPE", "LOADINPUTPARAM");
        this.twsJob.addAutoEdits("%%WS-NOSYSOUTBANNER", "N");
        this.twsJob.addAutoEdits("%%WS-SYSOUTSKIP", "N");
        this.twsJob.addAutoEdits("%%WS-ACCOUNT", "WS_REST_DEFAULT_CONNECTION");
        List restActions = this.taskDefintionXml.getAllDecnedElementByName("jsdlrestful:RESTAction");
        if (!restActions.isEmpty() && (method = ((XmlElement)restActions.get(0)).getValueOfFirstChildElementByName("jsdlrestful:method")).equalsIgnoreCase("GET")) {
            String uri = ((XmlElement)restActions.get(0)).getValueOfFirstChildElementByName("jsdlrestful:URI");
            this.setPathAndUrl(uri);
            this.twsJob.addAutoEdits("%%WS-SERVICE", method);
            XmlElement parametersTable = ((XmlElement)restActions.get(0)).getFirstChildElementByName("jsdlrestful:QueryParametersValues");
            this.fillInputParameters(parametersTable);
            this.twsJob.addMessage("WRN6037", this.twsJob.getOriginalJobName(), this.twsJob.getJobName());
            return;
        }
        this.twsJob.addMessage("WRN6038", this.twsJob.getOriginalJobName(), this.twsJob.getJobName());
    }

    private void setPathAndUrl(String uri) {
        uri = this.variablesHandler.convert(uri);
        String[] subStrings = uri.split("[^\\/|:](\\/{1})[^\\/]");
        String path = "";
        String url = "";
        if (subStrings.length > 0) {
            int endIndex = subStrings[0].length() == uri.length() ? subStrings[0].length() : subStrings[0].length() + 1;
            url = uri.substring(0, endIndex);
            if (subStrings.length > 1) {
                path = uri.substring(subStrings[0].length() + 2, uri.length());
            }
        }
        this.twsJob.addAutoEdits("%%WS-WSDL", url);
        this.twsJob.addAutoEdits("%%WS-OPERATION", path);
    }

    private void fillInputParameters(XmlElement parametersTable) {
        List parameters2 = this.taskDefintionXml.getAllDecnedElementByName("jsdlrestful:QueryParametersValue");
        for (int i = 0; i < parameters2.size(); ++i) {
            String paramName = ((XmlElement)parameters2.get(i)).getAttribute("key");
            String paramValue = ((XmlElement)parameters2.get(i)).getValue();
            this.twsJob.addAutoEdits(String.format("%%%%WS-PARMS-P%03d-NAME", i + 1), paramName);
            this.twsJob.addAutoEdits(String.format("%%%%WS-PARMS-P%03d-VALUE", i + 1), this.variablesHandler.convert(paramValue));
        }
    }

    @Override
    public void init(TwsJob twsJob, XmlElement taskDefintionXml) {
        this.twsJob = twsJob;
        this.taskDefintionXml = taskDefintionXml;
        this.variablesHandler = new VariablesHandler(twsJob, VarTable.instance());
    }
}

