/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tws.tasks;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.tws.OS400Handler;
import com.bmc.ctmconvert.tws.TwsBaseConvertor;
import com.bmc.ctmconvert.tws.TwsJob;
import java.util.Optional;

public class TwsTaskOS400Convertor
implements TwsBaseConvertor {
    private TwsJob twsJob;
    private XmlElement taskDefintionXml;

    @Override
    public void convert() {
        if (this.twsJob.isConvertToOS400()) {
            String restOfCommand;
            StringBuffer jobname = new StringBuffer(OS400Handler.getOs400JobName(this.twsJob.getJobName(), this.twsJob.getOriginalJobName()));
            StringBuffer user = new StringBuffer(OS400Handler.getOS400Owner(this.twsJob.getAttr("OWNER"), this.twsJob.getSourceJobAttribute("streamlogon")));
            StringBuffer memname = new StringBuffer("NOTINUSE");
            StringBuffer memlib = new StringBuffer("NOTINUSE");
            StringBuffer objtyp = new StringBuffer("*CMDLINE");
            StringBuffer cmdline = new StringBuffer("");
            Optional commandElemnt = this.taskDefintionXml.getAllDecnedElementByName("jsdlibmi:command").stream().findFirst();
            String fullCmdline = commandElemnt.map(XmlElement::getValue).orElse("");
            String[] arr = fullCmdline.split(" ", 2);
            String actionCommand = arr[0];
            String string = restOfCommand = arr.length > 1 ? arr[1] : "";
            if (actionCommand.equals("SBMJOB")) {
                OS400Handler.parseCommandLineWithActionSubmit(restOfCommand, jobname, user, cmdline, this.twsJob.getAutoedits());
            } else {
                cmdline = new StringBuffer(fullCmdline);
            }
            if (this.twsJob.isConvertOS400Call2Pgm()) {
                OS400Handler.converstCallCommand(cmdline, objtyp, memlib, memname, this.twsJob.getAutoedits());
            }
            this.twsJob.addAttribute("TASKTYPE", "Job");
            this.twsJob.addAttribute("OWNER", user.toString());
            this.twsJob.addAttribute("JOBNAME", jobname.toString());
            this.twsJob.addAttribute("MEMLIB", memlib.toString());
            this.twsJob.addAttribute("MEMNAME", memname.toString());
            this.twsJob.addAttribute("PARENT_TABLE", this.twsJob.getParentName());
            OS400Handler.setOS400DefaultAttribute(this.twsJob);
            OS400Handler.setOS400AutoeditVariables(cmdline.toString(), objtyp.toString(), user.toString(), jobname.toString(), memname.toString(), memlib.toString(), this.twsJob.getAutoedits());
        }
    }

    @Override
    public void init(TwsJob twsJob, XmlElement taskDefintionXml) {
        this.twsJob = twsJob;
        this.taskDefintionXml = taskDefintionXml;
    }
}

