/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tws.tasks;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.tws.TwsJob;
import com.bmc.ctmconvert.tws.variables.VariablesHandler;
import java.util.List;

public abstract class TwsDBConvertorBase {
    protected TwsJob twsJob;
    protected XmlElement taskDefinitionXml;
    protected String connectionProfile;

    public void init(TwsJob twsJob, XmlElement taskDefinitionXml) {
        this.twsJob = twsJob;
        this.taskDefinitionXml = taskDefinitionXml;
        twsJob.setOptionalAtrribute("TASKTYPE", "Job");
        twsJob.setOptionalAtrribute("APPL_FORM", "Databases");
        twsJob.setOptionalAtrribute("APPL_TYPE", "DATABASE");
        twsJob.setOptionalAtrribute("CM_VER", "N/A");
        twsJob.setOptionalAtrribute("APPL_VER", "9.0.18.200");
        twsJob.addAutoEdits("%%DB-AUTOCOMMIT", "N");
        twsJob.addAutoEdits("%%DB-CSV_SEPERATOR", ",");
        twsJob.addAutoEdits("%%DB-SSIS_PACKAGE_SOURCE", "SQL Server");
        twsJob.addAutoEdits("%%DB-APPEND_LOG", "Y");
        twsJob.addAutoEdits("%%DB-APPEND_OUTPUT", "N");
        twsJob.addAutoEdits("%%DB-OUTPUT_FORMAT", "Text");
        twsJob.addAutoEdits("%%DB-STP_PACKAGE", "*");
        List taskApplctionXml = taskDefinitionXml.getAllDecnedElementByName("jsdldatabase:sqlActionInfo");
        if (!taskApplctionXml.isEmpty()) {
            this.connectionProfile = ((XmlElement)taskApplctionXml.get(0)).getValueOfFirstChildElementByName("jsdldatabase:dbms");
            String databaseElement = ((XmlElement)taskApplctionXml.get(0)).getValueOfFirstChildElementByName("jsdldatabase:database");
            this.connectionProfile = VariablesHandler.isTWSVariable(databaseElement) ? this.connectionProfile : this.connectionProfile + "_" + databaseElement;
            this.connectionProfile = this.connectionProfile.toUpperCase();
            twsJob.addAutoEdits("%%DB-ACCOUNT", this.connectionProfile);
        } else {
            twsJob.addAutoEdits("%%DB-ACCOUNT", "DEFAULT_CONNECTION");
        }
    }

    public abstract void convertJob();
}

