/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tws;

import com.bmc.ctmconvert.common.CsvFile;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.tws.TwsJobAttributes;
import com.bmc.ctmconvert.tws.TwsScheduleAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;

public class jobsTable
extends CsvFile {
    private HashMap<String, TwsScheduleAttributes> schedules;
    private HashMap<String, ArrayList<String>> jobToSchedMap = new HashMap();
    private HashMap<String, IAttrHolder> orphanedJobs = new HashMap();

    public jobsTable(HashMap<String, TwsScheduleAttributes> schedules) {
        this.schedules = schedules;
        this.mapJobToSchedule();
    }

    public HashMap<String, IAttrHolder> getOrphanJobs() {
        return this.orphanedJobs;
    }

    protected void handleRecord(IAttrHolder jobAttributes, int record_number) {
        String jobId = jobAttributes.getAttr("ID");
        if (jobId.isEmpty()) {
            return;
        }
        ArrayList<String> schedIds = this.jobToSchedMap.get(jobId);
        if (schedIds == null) {
            this.orphanedJobs.put(jobId, jobAttributes);
        } else {
            for (String schedId : schedIds) {
                TwsScheduleAttributes sched = this.schedules.get(schedId);
                if (sched == null) continue;
                TwsJobAttributes job = sched.getJobs().get(jobId);
                if (job != null) {
                    job.setJobAttributes(jobAttributes);
                }
                if (sched.getAliases(jobId) == null) continue;
                for (String alias : sched.getAliases(jobId)) {
                    sched.getJobs().get(alias).setJobAttributes(jobAttributes);
                }
            }
        }
    }

    private void mapJobToSchedule() {
        for (String sched : this.schedules.keySet()) {
            for (String jobName : this.schedules.get(sched).getJobs().keySet()) {
                this.addMappingForJobNameOrAliasToSched(sched, jobName);
            }
            if (this.schedules.get(sched).getAliasMap() == null) continue;
            for (String aliased : this.schedules.get(sched).getAliasMap().keySet()) {
                if (!this.jobToSchedMap.containsKey(aliased)) {
                    this.jobToSchedMap.put(aliased, new ArrayList());
                }
                this.jobToSchedMap.get(aliased).add(sched);
                for (String job : this.schedules.get(sched).getAliases(aliased)) {
                    if (!this.jobToSchedMap.containsKey(job)) {
                        this.jobToSchedMap.put(job, new ArrayList());
                    }
                    this.jobToSchedMap.get(job).add(sched);
                }
            }
        }
    }

    private void addMappingForJobNameOrAliasToSched(String sched, String jobName) {
        if (!this.jobToSchedMap.containsKey(jobName)) {
            this.jobToSchedMap.put(jobName, new ArrayList());
        }
        this.jobToSchedMap.get(jobName).add(sched);
    }

    public Optional<String> getJobNodeByNameWithoutNode(String jobNameWithoutNode) {
        for (String name : this.jobToSchedMap.keySet()) {
            String[] nodeAndName = name.split("#");
            if (nodeAndName.length <= 1 || !jobNameWithoutNode.equals(nodeAndName[1])) continue;
            return Optional.of(nodeAndName[0]);
        }
        return Optional.empty();
    }

    public IAttrHolder getJobAttributes(String jobId) {
        IAttrHolder toRet = null;
        if (this.jobToSchedMap.containsKey(jobId)) {
            for (String sched : this.jobToSchedMap.get(jobId)) {
                TwsJobAttributes tmpJob = this.schedules.get(sched).getJobs().get(jobId);
                if (tmpJob != null) {
                    toRet = tmpJob.getJobAttributes();
                }
                if (toRet == null) continue;
                break;
            }
        }
        if (toRet == null) {
            toRet = this.orphanedJobs.get(jobId);
        }
        return toRet;
    }
}

