/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tws;

import com.bmc.ctmconvert.common.CsvFile;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Params;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class VarTable
extends CsvFile {
    private static VarTable instance = null;
    private final HashMap<String, Map<String, String>> workstation2VarMap = new HashMap();
    private final HashMap<String, Map<String, String>> table2VarMap = new HashMap();
    static final String DEFAULT_TABLE = "@DEFAULT_TABLE@";

    VarTable() {
    }

    public static VarTable instance() {
        if (instance == null) {
            instance = new VarTable();
            String varCsvFile = Params.instance().getDatasourcePath() + Globs.DIRSEP + "variables.csv";
            try (FileInputStream inputStream = new FileInputStream(varCsvFile);){
                instance.load(inputStream);
            }
            catch (IOException e) {
                ExceptionHandler.writeToExceptionFile((Exception)e);
            }
        }
        return instance;
    }

    public static void setInstanceForTest(VarTable instance) {
        VarTable.instance = instance;
    }

    protected void handleRecord(IAttrHolder newRecord, int recordNumber) {
        String isDefault;
        String tableName;
        String varName = newRecord.getAttr("NAME").toLowerCase();
        String varValue = newRecord.getAttr("VALUE");
        String cpuName = newRecord.getAttr("WORKSTATION");
        if (cpuName != null && !cpuName.isEmpty()) {
            Map hm = this.workstation2VarMap.computeIfAbsent(cpuName, k -> new HashMap());
            hm.put(varName, varValue);
        }
        if ((tableName = newRecord.getAttr("TABLE")) != null && !tableName.isEmpty()) {
            Map hm = this.table2VarMap.computeIfAbsent(tableName, k -> new HashMap());
            hm.put(varName, varValue);
        }
        if ((isDefault = newRecord.getAttr("ISDEFAULT")).equalsIgnoreCase("Y")) {
            Map hm = this.table2VarMap.computeIfAbsent(DEFAULT_TABLE, k -> new HashMap());
            hm.put(varName, varValue);
        }
    }

    public String getVariable(String workStationName, List<String> tableNames, String varName) {
        LinkedHashMap<String, HashMap<String, Map<String, String>>> name2Table = new LinkedHashMap<String, HashMap<String, Map<String, String>>>();
        name2Table.put(workStationName, this.workstation2VarMap);
        for (String table : tableNames) {
            name2Table.put(table, this.table2VarMap);
        }
        name2Table.put(DEFAULT_TABLE, this.table2VarMap);
        return name2Table.entrySet().stream().map(entry -> ((Map)entry.getValue()).getOrDefault(entry.getKey(), Collections.emptyMap())).map(map -> map.getOrDefault(varName.toLowerCase(), "")).filter(s -> !s.isEmpty()).map(varValue -> varValue.trim().replaceAll("^\"(.*)\"$", "$1")).findFirst().orElse(null);
    }
}

