/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tws;

import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.tws.Dependecy;
import com.bmc.ctmconvert.utils.IUniqueConditionNameGenerator;
import com.bmc.ctmconvert.utils.Pair;
import java.util.HashMap;
import java.util.Map;

public class TwsUniqueConditionNameGenerator
implements IUniqueConditionNameGenerator {
    private Map<Dependecy, String> dependency2ConditionName;
    private Map<Pair<String, String>, Integer> condition2Counter;
    private RulesDataSet rules;
    private String conditionFormat;
    private String separator;

    public TwsUniqueConditionNameGenerator(String separator, RulesDataSet rules) {
        this.rules = rules;
        this.conditionFormat = "%s-TO-%s";
        this.separator = separator;
        this.dependency2ConditionName = new HashMap<Dependecy, String>();
        this.condition2Counter = new HashMap<Pair<String, String>, Integer>();
    }

    private boolean isDependencyAlreadyExists(Dependecy dependecy) {
        return this.dependency2ConditionName.containsKey(dependecy);
    }

    private String buildConditionName(Dependecy dependecy) {
        String senderName = dependecy.getConditionSender().getJobNameAccordingUserRules(this.rules);
        String getterName = dependecy.getConditionGetter().getJobNameAccordingUserRules(this.rules);
        return String.format(this.conditionFormat, senderName, getterName);
    }

    public String getUniqueConditionName(Dependecy dependency) {
        String toRet = "";
        if (!this.isDependencyAlreadyExists(dependency)) {
            String conditionName = this.buildConditionName(dependency);
            Pair conditionKey = new Pair((Object)conditionName, (Object)dependency.getConditionType());
            if (this.condition2Counter.containsKey(conditionKey)) {
                int uniqueCounter = this.condition2Counter.get(conditionKey) + 1;
                this.condition2Counter.put((Pair<String, String>)conditionKey, uniqueCounter);
                this.dependency2ConditionName.put(dependency, conditionName + this.separator + uniqueCounter);
                toRet = this.dependency2ConditionName.get(dependency);
            } else {
                this.condition2Counter.put((Pair<String, String>)conditionKey, 0);
                this.dependency2ConditionName.put(dependency, conditionName);
                toRet = conditionName;
            }
        } else {
            toRet = this.dependency2ConditionName.get(dependency);
        }
        return toRet;
    }

    public String getUniqueInConditionName(String inConditionName) {
        return inConditionName;
    }

    public String getUniqueOutConditionName(String outConditionName) {
        return outConditionName;
    }
}

