/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tws;

import com.bmc.ctmconvert.common.ExceptionHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TwsTimeZone {
    private HashMap<String, String> controlmTimeZones = new HashMap();
    private HashMap<String, String> twsTimeZones = new HashMap();
    private BufferedReader ctmTimeZoneReader;
    private BufferedReader tWSTimeZoneReader;
    private InputStream tWSTimeZoneInputStream;
    private InputStream ctmTimeZoneInputStream;

    private void init() {
        String line;
        try {
            this.ctmTimeZoneReader = new BufferedReader(new InputStreamReader(this.ctmTimeZoneInputStream));
            Pattern ctmTzPattern = Pattern.compile("^([^# \t]+)[ \t]*\\(((GMT[+-])([0-9]{1,2}):([0-9]{2}))\\)");
            while ((line = this.ctmTimeZoneReader.readLine()) != null) {
                Matcher tzMatcher;
                if ((line = line.trim()).isEmpty() || !(tzMatcher = ctmTzPattern.matcher(line)).matches()) continue;
                String tzName = tzMatcher.group(1);
                Integer hoursOffset = Integer.valueOf(tzMatcher.group(4));
                Integer minutesOffset = Integer.valueOf(tzMatcher.group(5));
                Object tzGmtOffset = "";
                if (hoursOffset != 0 || minutesOffset != 0) {
                    tzGmtOffset = (String)tzGmtOffset + tzMatcher.group(3);
                    tzGmtOffset = (String)tzGmtOffset + Integer.toString(hoursOffset);
                    if (minutesOffset != 0) {
                        tzGmtOffset = (String)tzGmtOffset + ":";
                        tzGmtOffset = (String)tzGmtOffset + (minutesOffset < 10 ? "0" : "");
                        tzGmtOffset = (String)tzGmtOffset + minutesOffset;
                    }
                } else {
                    tzGmtOffset = "GMT";
                }
                this.controlmTimeZones.put((String)tzGmtOffset, tzName);
            }
            this.ctmTimeZoneReader.close();
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        if (this.controlmTimeZones.keySet().size() == 0) {
            this.controlmTimeZones.put("GMT-10", "HAW");
            this.controlmTimeZones.put("GMT-9", "ANC");
            this.controlmTimeZones.put("GMT-8", "PST");
            this.controlmTimeZones.put("GMT-7", "MST");
            this.controlmTimeZones.put("GMT-6", "CST");
            this.controlmTimeZones.put("GMT-5", "EST");
            this.controlmTimeZones.put("GMT-4", "ATL");
            this.controlmTimeZones.put("GMT-3", "RIO");
            this.controlmTimeZones.put("GMT", "GMT");
            this.controlmTimeZones.put("GMT+1", "WET");
            this.controlmTimeZones.put("GMT+2", "CET");
            this.controlmTimeZones.put("GMT+3", "EET");
            this.controlmTimeZones.put("GMT+4", "DXB");
            this.controlmTimeZones.put("GMT+5", "KHI");
            this.controlmTimeZones.put("GMT+6", "DAC");
            this.controlmTimeZones.put("GMT+7", "BKK");
            this.controlmTimeZones.put("GMT+8", "HKG");
            this.controlmTimeZones.put("GMT+9", "TOK");
            this.controlmTimeZones.put("GMT+10", "SYD");
            this.controlmTimeZones.put("GMT+11", "NOU");
        }
        try {
            this.tWSTimeZoneReader = new BufferedReader(new InputStreamReader(this.tWSTimeZoneInputStream));
            while ((line = this.tWSTimeZoneReader.readLine()) != null) {
                String[] params;
                if ((line = line.trim()).isEmpty() || (params = line.split("[ ]")).length != 2) continue;
                this.twsTimeZones.put(params[0], params[1]);
            }
            this.tWSTimeZoneReader.close();
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
    }

    public TwsTimeZone(InputStream tWSTimeZoneInputStream2, InputStream ctmTimeZoneInputStream2) {
        this.tWSTimeZoneInputStream = tWSTimeZoneInputStream2;
        this.ctmTimeZoneInputStream = ctmTimeZoneInputStream2;
        this.init();
    }

    public String convertTimezone(String twsTimeZone) {
        String twsGMT = this.twsTimeZones.get(twsTimeZone);
        if (twsGMT != null) {
            return this.controlmTimeZones.get(twsGMT);
        }
        return null;
    }

    public boolean isCtmTz(String tz) {
        return this.controlmTimeZones.values().contains(tz);
    }
}

