/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tws;

import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.tws.TwsJobAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;

public class TwsScheduleAttributes {
    private String name;
    private HashMap<String, TwsJobAttributes> jobs;
    private IAttrHolder attributes;
    private AttrHolderList scheduleParams;
    private HashMap<String, HashSet<String>> aliases;

    public TwsScheduleAttributes(IAttrHolder schedule) {
        this.name = schedule.getAttr("ID");
        this.attributes = schedule;
        this.jobs = new HashMap();
    }

    public IAttrHolder getAttributes() {
        return this.attributes;
    }

    public AttrHolderList getParams() {
        return this.scheduleParams;
    }

    public void addToParams(IAttrHolder newParam) {
        if (this.scheduleParams == null) {
            this.scheduleParams = new AttrHolderList();
        }
        this.scheduleParams.add((Object)newParam);
    }

    public HashMap<String, TwsJobAttributes> getJobs() {
        return this.jobs;
    }

    public String getName() {
        return this.name;
    }

    public void mapAlias(String real, String alias) {
        if (this.aliases == null) {
            this.aliases = new HashMap();
        }
        if (this.aliases.get(real) == null) {
            this.aliases.put(real, new HashSet());
        }
        this.aliases.get(real).add(alias);
    }

    public HashSet<String> getAliases(String name) {
        return this.aliases == null ? null : this.aliases.get(name);
    }

    public HashMap<String, HashSet<String>> getAliasMap() {
        return this.aliases;
    }

    public List<TwsJobAttributes> getJobs(Predicate<TwsJobAttributes> jobPredicate) {
        ArrayList<TwsJobAttributes> jobList = new ArrayList<TwsJobAttributes>();
        for (TwsJobAttributes job : this.jobs.values()) {
            if (!jobPredicate.test(job)) continue;
            jobList.add(job);
        }
        return jobList;
    }

    public void addJob(String jobName, TwsJobAttributes job) {
        this.jobs.put(jobName, job);
    }
}

