/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tws;

import com.bmc.ctmconvert.CsvFileInputStreamFolder;
import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.SourceDefinitions;
import com.bmc.ctmconvert.common.exceptions.ConvertorCancelClickException;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.tws.CpuTable;
import com.bmc.ctmconvert.tws.DependencyCreator;
import com.bmc.ctmconvert.tws.DependencySide;
import com.bmc.ctmconvert.tws.RuncycleConvertor;
import com.bmc.ctmconvert.tws.ScheduleJobsParamsTable;
import com.bmc.ctmconvert.tws.ScheduleJobsTable;
import com.bmc.ctmconvert.tws.ScheduleTable;
import com.bmc.ctmconvert.tws.TwsGlobals;
import com.bmc.ctmconvert.tws.TwsJob;
import com.bmc.ctmconvert.tws.TwsJobAttributes;
import com.bmc.ctmconvert.tws.TwsScheduleAttributes;
import com.bmc.ctmconvert.tws.TwsTimeZone;
import com.bmc.ctmconvert.tws.TwsUniqueConditionNameGenerator;
import com.bmc.ctmconvert.tws.jobsTable;
import com.bmc.ctmconvert.tws.scheduleParamsTable;
import com.bmc.ctmconvert.tws.tasks.TaskFactory;
import com.bmc.ctmconvert.utils.UniqueValueGenerator;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;

public class TwsDefs
implements SourceDefinitions {
    private RulesDataSet rules;
    private HashMap<String, TwsScheduleAttributes> schedules = new HashMap();
    private ArrayList<String> messages = new ArrayList();
    private AttrHolderList top_level_parents = null;
    private Boolean m_isIncludeType = null;
    private Boolean m_isOrCond = null;
    private CpuTable cpus;
    private jobsTable allJobs;
    private final TwsUniqueConditionNameGenerator uniqueConditionNameGenerator;
    private final DependencyCreator dependencyCreator;
    private final RuncycleConvertor runcycleConvertor;
    private ScheduleTable scheduleTable;
    private TwsTimeZone timeZone;
    private final UniqueValueGenerator uniqueValueGenerator;
    private final TaskFactory taskFactory;

    public TwsDefs(RulesDataSet rules) {
        this.rules = rules;
        this.uniqueConditionNameGenerator = new TwsUniqueConditionNameGenerator("_", rules);
        this.dependencyCreator = new DependencyCreator(rules);
        this.runcycleConvertor = new RuncycleConvertor(this.rules);
        this.uniqueValueGenerator = new UniqueValueGenerator();
        this.taskFactory = new TaskFactory();
    }

    public void loadFiles(CsvFileInputStreamFolder csvFolder) {
        this.scheduleTable = new ScheduleTable(this);
        this.scheduleTable.load(csvFolder.getFileInputStreamByKey("schedule"));
        new scheduleParamsTable(this).load(csvFolder.getFileInputStreamByKey("scheduleParams"));
        new ScheduleJobsTable(this).load(csvFolder.getFileInputStreamByKey("scheduleJobs"));
        new ScheduleJobsParamsTable(this).load(csvFolder.getFileInputStreamByKey("scheduleJobsParams"));
        this.allJobs = new jobsTable(this.getSchedules());
        this.allJobs.load(csvFolder.getFileInputStreamByKey("jobs"));
        InputStream tWSTimeZoneInputStream = csvFolder.getFileInputStreamByKey("TimeZones.dat");
        InputStream ctmTimeZoneInputStream = csvFolder.getFileInputStreamByKey("ctmTimeZones.dat");
        this.timeZone = new TwsTimeZone(tWSTimeZoneInputStream, ctmTimeZoneInputStream);
    }

    public void addGeneralMessage(String msgId) {
        Reporter.addMessage(this.messages, (String)msgId, (String)"General", (String[])new String[0]);
    }

    public void applyFilter(String root) {
        AttrHolderList filteredList = new AttrHolderList();
        if (this.top_level_parents == null) {
            return;
        }
        for (IAttrHolder parent : this.top_level_parents) {
            if (!this.isFilter(parent)) continue;
            filteredList.add((Object)parent);
        }
        this.top_level_parents = null;
        this.top_level_parents = filteredList;
    }

    private boolean isFilter(IAttrHolder record) {
        boolean rc = true;
        boolean isInclude = this.getIncludeType();
        boolean isOrCondition = this.getOrCondition();
        ArrayList filters = this.rules.getFilterHandler().getConditions();
        for (Map.Entry entry : filters) {
            String field = (String)entry.getKey();
            String regVal = (String)entry.getValue();
            String schedule = record.getAttr("ID");
            String[] schedArr = schedule.split("#", 2);
            String recordVal = "";
            if (field.equalsIgnoreCase("CPU Name")) {
                recordVal = schedArr[0];
            } else if (field.equalsIgnoreCase("Schedule Name")) {
                recordVal = schedArr[1];
            }
            boolean funcRC = this.matchWildcard(recordVal, regVal);
            if (funcRC) {
                if (isOrCondition) {
                    rc = true;
                    break;
                }
                rc = true;
                continue;
            }
            if (isOrCondition) {
                rc = false;
                continue;
            }
            rc = false;
            break;
        }
        if (isInclude) {
            return rc;
        }
        return !rc;
    }

    private boolean getIncludeType() {
        if (this.m_isIncludeType == null) {
            this.m_isIncludeType = this.rules.getFilterHandler().isInclude();
        }
        return this.m_isIncludeType;
    }

    private boolean getOrCondition() {
        if (this.m_isOrCond == null) {
            this.m_isOrCond = this.rules.getFilterHandler().isOr();
        }
        return this.m_isOrCond;
    }

    private boolean matchWildcard(String value, String expr) {
        String regExp = expr.replace("\\*", ".*");
        regExp = regExp.replace("\\?", ".");
        return value.matches(regExp);
    }

    public void createDependencies(String root) {
    }

    public Set<Properties> createTags(String root) {
        return Collections.emptySet();
    }

    public void finalize_() {
    }

    public AttrHolderList getChildren(String parentEntityId) {
        return null;
    }

    public String getEntNameFieldName() {
        return null;
    }

    public ArrayList<String> getGeneralMessages() {
        return this.messages;
    }

    public String getIdFieldName() {
        return "ID";
    }

    public List<Properties> getJobControlRes(SchedEntity job) {
        return null;
    }

    public List<Properties> getJobInconds(SchedEntity job) {
        return null;
    }

    public List<Properties> getJobOnstmts(SchedEntity job) {
        return null;
    }

    public List<Properties> getJobOutconds(SchedEntity job) {
        return null;
    }

    public String getParentEntFieldName() {
        return null;
    }

    public AttrHolderList getTopLevelEntities() {
        if (this.top_level_parents != null) {
            return this.top_level_parents;
        }
        this.top_level_parents = new AttrHolderList();
        for (TwsScheduleAttributes sched : this.schedules.values()) {
            this.top_level_parents.add((Object)sched.getAttributes());
        }
        return this.top_level_parents;
    }

    private void filter() {
        String topLevel = "0";
        this.applyFilter(topLevel);
    }

    public boolean hasChildren(String entId) {
        return this.schedules.containsKey(entId) && !this.schedules.get(entId).getJobs().isEmpty();
    }

    public void init() throws ConvertorCancelClickException {
        this.getTopLevelEntities();
        HashMap<String, IAttrHolder> orphan = this.allJobs.getOrphanJobs();
        this.top_level_parents.addAll(orphan.values());
        this.filter();
    }

    public boolean isContainerEntity(IAttrHolder entAttr) {
        return this.schedules.containsKey(entAttr.getAttr("ID"));
    }

    public boolean isStandAloneGrouped() {
        return this.rules.getStringRule("TWS rules", new String[]{"GROUP_STANDALONE_JOBS_IN_ONE_TABLE"}).equals("OneTable");
    }

    public SchedEntity spawnJob(String table, IAttrHolder attributes) {
        return TwsJob.createTwsJob(attributes.getAttr("ID"), null, this);
    }

    public SchedEntity spawnJob(SchedEntity parent, IAttrHolder attributes) {
        String jobId = TwsGlobals.createAliasFromFullId(attributes.getAttr("ID"));
        return TwsJob.createTwsJob(jobId, (TwsJob)parent, this);
    }

    public HashMap<String, TwsScheduleAttributes> getSchedules() {
        return this.schedules;
    }

    public TwsJobAttributes getJobAttributes(String jobId, String schedId) {
        return this.schedules.get(schedId).getJobs().get(jobId);
    }

    public void createDeps(String predecessors, String receivingID) {
        this.dependencyCreator.createdeps(predecessors, receivingID);
    }

    public ArrayList<DependencySide> getConditionGettersBySender(String outJob) {
        return this.dependencyCreator.containsKey(outJob) ? this.dependencyCreator.get(outJob) : null;
    }

    public boolean isConditionSent(String conditionSender) {
        return this.dependencyCreator.containsKey(conditionSender);
    }

    public CpuTable getCpus() {
        if (this.cpus == null) {
            this.cpus = new CpuTable();
            this.cpus.load(Params.instance().getDatasourcePath() + "cpus.csv");
        }
        return this.cpus;
    }

    public String getDefaultTz() {
        String toRet = this.timeZone.convertTimezone(this.getCpus().getMasterTz());
        return toRet == null ? "" : toRet;
    }

    public TwsTimeZone getTimeZone() {
        return this.timeZone;
    }

    public RuncycleConvertor getRunCycleConvertor() {
        return this.runcycleConvertor;
    }

    public IAttrHolder getJobAttributes(String id) {
        return this.allJobs.getJobAttributes(id);
    }

    public Optional<String> getJobOriginalNode(String idwithoutNode) {
        return this.allJobs.getJobNodeByNameWithoutNode(idwithoutNode);
    }

    public TwsUniqueConditionNameGenerator getuniqueConditionNameGenerator() {
        return this.uniqueConditionNameGenerator;
    }

    public String getConditionFormatRule() {
        return this.rules.getStringRule("TWS rules", new String[]{"CONVERT_TO_FORMAT"});
    }

    public ScheduleTable getScheduleTable() {
        return this.scheduleTable;
    }

    public RulesDataSet getRules() {
        return this.rules;
    }

    public UniqueValueGenerator getUniqueValueGenerator() {
        return this.uniqueValueGenerator;
    }

    public TaskFactory getTaskFactory() {
        return this.taskFactory;
    }
}

