/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tws;

import com.bmc.ctmconvert.common.AssessmentXMLDescriptionReader;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.tws.JobTypeDistributionStringBuilder;
import com.bmc.ctmconvert.tws.TWSAssessmentReport;
import com.bmc.ctmconvert.tws.TwsAssessmentDataCalculator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class TwsAssessmentSummaryBuilder {
    private static final String JOBS_TYPE_DISTRIBUTION_NODE = "Jobs type distribution:";
    private static final String NUMBER_OF_ENTITIES = "#NUM_ENTITIES#";
    private static final String NUM_TABLES = "#NUM_TABLES#";
    private final TWSAssessmentReport assessmentReport;
    private final TwsAssessmentDataCalculator dataCalculator;

    public TwsAssessmentSummaryBuilder(TWSAssessmentReport assessmentReport) {
        this.assessmentReport = assessmentReport;
        this.dataCalculator = new TwsAssessmentDataCalculator();
    }

    public HashMap<String, String> getDescriptionNodes() {
        String sMainSummary;
        this.dataCalculator.calculateEntityTypes(this.assessmentReport.getSchedules());
        AssessmentXMLDescriptionReader descriptionXMLReader = this.assessmentReport.getM_DescriptionXMLReader();
        LinkedHashMap descriptions = descriptionXMLReader.getNodeNameNodeDescriptionMap();
        StringBuilder mainSummary = new StringBuilder();
        mainSummary.append("TWS input data analysis:").append(Globs.LINESEP).append(Globs.LINESEP);
        String extraSummary = null;
        for (Map.Entry entry : descriptions.entrySet()) {
            String nodeName = (String)entry.getKey();
            if (descriptionXMLReader.isAutoBuildMainSummary() && nodeName.compareToIgnoreCase("MainSummary") != 0) {
                if (nodeName.compareToIgnoreCase("ExtraSummary") == 0) {
                    extraSummary = (String)entry.getValue();
                } else {
                    mainSummary.append(nodeName);
                    mainSummary.append(Globs.LINESEP);
                    mainSummary.append(this.evaluateDescriptionParameters(nodeName, (String)descriptions.get(nodeName)));
                    mainSummary.append(Globs.LINESEP);
                    mainSummary.append(Globs.LINESEP);
                }
            }
            descriptions.put(nodeName, this.evaluateDescriptionParameters(nodeName, (String)descriptions.get(nodeName)));
        }
        if (null != extraSummary) {
            mainSummary.append("ExtraSummary");
            mainSummary.append(Globs.LINESEP);
            mainSummary.append(this.evaluateDescriptionParameters("ExtraSummary", extraSummary));
            mainSummary.append(Globs.LINESEP);
            mainSummary.append(Globs.LINESEP);
        }
        if (!descriptionXMLReader.isAutoBuildMainSummary() && null != (sMainSummary = (String)descriptions.get("MainSummary"))) {
            mainSummary.append(sMainSummary);
            String sExtraSummary = (String)descriptions.get("ExtraSummary");
            if (null != sExtraSummary) {
                mainSummary.append(Globs.LINESEP);
                mainSummary.append(Globs.LINESEP);
                mainSummary.append("ExtraSummary");
                mainSummary.append(Globs.LINESEP);
                mainSummary.append(this.evaluateDescriptionParameters("ExtraSummary", sExtraSummary));
                mainSummary.append(Globs.LINESEP);
            }
        }
        descriptions.put(Params.instance().getDatasourceName(), mainSummary.toString());
        return descriptions;
    }

    private String evaluateDescriptionParameters(String sNodeName, String sDescription) {
        if (!sDescription.contains("#")) {
            return sDescription;
        }
        if (sNodeName.equalsIgnoreCase(JOBS_TYPE_DISTRIBUTION_NODE)) {
            JobTypeDistributionStringBuilder builder = new JobTypeDistributionStringBuilder(sDescription);
            return builder.buildJobTypeDistribution(this.dataCalculator.getJobsTypesData());
        }
        sDescription = sDescription.replace("#ENV_NAME#", Params.instance().getDatasourceName());
        sDescription = sDescription.replace(NUM_TABLES, Integer.toString(this.dataCalculator.getTableCount()));
        String sNum = this.getEntitiesCountFor(sNodeName);
        sDescription = sDescription.replace(NUMBER_OF_ENTITIES, sNum);
        int lowMachinesUseCount = this.assessmentReport.getLowMachinesUseCount();
        if ((sDescription = sDescription.replace("#NUM_LOW_USED_MACHINES#", Integer.toString(lowMachinesUseCount))).contains("#NUM_LOW_USED_MACHINES_LIST#")) {
            StringBuilder machinesList = new StringBuilder();
            ArrayList listNamesOflowMachinesUse = this.assessmentReport.getListNamesOflowMachinesUse();
            Collections.sort(listNamesOflowMachinesUse);
            for (String machine : listNamesOflowMachinesUse) {
                machinesList.append(machine);
                machinesList.append(Globs.LINESEP);
            }
            sDescription = sDescription.replace("#NUM_LOW_USED_MACHINES_LIST#", machinesList.toString());
        }
        return sDescription;
    }

    private String getEntitiesCountFor(String sNodeName) {
        String withoutEndingColon = sNodeName.replaceAll(":$", "");
        return this.assessmentReport.getNodeNameToEntityCount().getOrDefault(withoutEndingColon, "0");
    }
}

