/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tws;

import com.bmc.ctmconvert.base.AbstractAssessmentReport;
import com.bmc.ctmconvert.common.AssessmentXMLDescriptionReader;
import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.io.csv.CsvReader;
import com.bmc.ctmconvert.tws.PeopleSoftHandler;
import com.bmc.ctmconvert.tws.SapHandler;
import com.bmc.ctmconvert.tws.ScheduleJobsParamsTable;
import com.bmc.ctmconvert.tws.ScheduleJobsTable;
import com.bmc.ctmconvert.tws.ScheduleTable;
import com.bmc.ctmconvert.tws.TWSAssessmentCalendarTXTReader;
import com.bmc.ctmconvert.tws.TwsAssessmentSummaryBuilder;
import com.bmc.ctmconvert.tws.TwsGlobals;
import com.bmc.ctmconvert.tws.TwsJobAttributes;
import com.bmc.ctmconvert.tws.TwsScheduleAttributes;
import com.bmc.ctmconvert.tws.jobsTable;
import com.bmc.ctmconvert.tws.scheduleParamsTable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import javax.swing.tree.DefaultMutableTreeNode;

public class TWSAssessmentReport
extends AbstractAssessmentReport {
    private HashMap<String, TwsScheduleAttributes> schedules = null;
    static final String TABLES = "Tables";
    static final String JOBS = "Jobs";
    static final String DEFINED_CPUS = "CPUs - Defined";
    static final String IN_USE_CPUS = "CPUs - In use";
    static final String RESOURCES = "Resources";
    static final String DEFINED_CALENDARS = "Calendars - Defined";
    static final String IN_USE_CALENDARS = "Calendars - In use";
    static final String MAESTRO_JOBS = "Maestro jobs";
    static final String PEOPLESOFT_JOBS = "PeopleSoft jobs";
    static final String SAP_JOBS = "SAP jobs";
    static final String AGENTS = "Agents";
    private TWSAssessmentCalendarTXTReader m_CalendarTXTReader;
    private boolean handleCalendars;
    private AssessmentXMLDescriptionReader m_DescriptionXMLReader = null;
    private HashMap<String, String> m_NodeName_EntityCount = null;
    private HashMap<String, String> entityDescription;
    private HashMap<String, ArrayList<String>> calName2JobList;
    private HashMap<String, String> cpuName2cpuDescription;
    private HashMap<String, ArrayList<String>> cpuName2EntityList;
    private ArrayList<String> maestroJobsList;
    private HashMap<String, String> resourceName2resourceDescription;
    private HashMap<String, ArrayList<String>> resourceName2EntityList;
    private ArrayList<String> peopleSoftJobsList;
    private ArrayList<String> sapJobsList;

    public TWSAssessmentReport(String pathName, String descriptionXMLFileName, String textCalendarFileName) {
        super(pathName, descriptionXMLFileName, textCalendarFileName);
    }

    protected void initSourceData(String pathName, String descriptionXMLFileName, String textCalendarFileName) {
        this.m_DescriptionXMLReader = new AssessmentXMLDescriptionReader(descriptionXMLFileName, Params.instance().getVendorName());
        this.m_NodeName_EntityCount = new HashMap();
        this.entityDescription = new HashMap();
        this.calName2JobList = new HashMap();
        this.cpuName2cpuDescription = new HashMap();
        this.cpuName2EntityList = new HashMap();
        this.maestroJobsList = new ArrayList();
        this.resourceName2EntityList = new HashMap();
        this.resourceName2resourceDescription = new HashMap();
        this.peopleSoftJobsList = new ArrayList();
        this.sapJobsList = new ArrayList();
        this.schedules = new HashMap();
        this.populateAttributes();
        File calFile = this.getCalFile(pathName);
        String calFileName = "";
        if (calFile != null && calFile.exists()) {
            calFileName = calFile.getAbsolutePath();
        }
        if (!calFileName.isEmpty()) {
            this.handleCalendars = true;
            this.m_CalendarTXTReader = new TWSAssessmentCalendarTXTReader(calFileName);
        } else {
            this.handleCalendars = false;
        }
    }

    private File getCalFile(String pathName) {
        File calFile = null;
        File mainDir = new File(pathName);
        for (File file : mainDir.listFiles()) {
            if (!file.isFile()) continue;
            try (Scanner scanner = new Scanner(file);){
                String firstLine;
                if (!scanner.hasNext() || (firstLine = scanner.next()) == null || !firstLine.startsWith("$CALENDAR")) continue;
                calFile = file;
                break;
            }
            catch (FileNotFoundException e) {
                ExceptionHandler.writeToExceptionFile((Exception)e);
            }
        }
        return calFile;
    }

    private void populateAttributes() {
        new ScheduleTable(this.schedules).load(Params.instance().getDatasourcePath() + "schedule.csv");
        new scheduleParamsTable(this.schedules).load(Params.instance().getDatasourcePath() + "scheduleParams.csv");
        new ScheduleJobsTable(this.schedules).load(Params.instance().getDatasourcePath() + "scheduleJobs.csv");
        new ScheduleJobsParamsTable(this.schedules).load(Params.instance().getDatasourcePath() + "scheduleJobsParams.csv");
        new jobsTable(this.schedules).load(Params.instance().getDatasourcePath() + "jobs.csv");
    }

    protected DefaultMutableTreeNode getDefaultTreeModel() {
        String param;
        int i;
        ArrayList<String> allCalendars;
        int tableCount = 0;
        int jobCount = 0;
        for (TwsScheduleAttributes twsSchedule : this.schedules.values()) {
            if (twsSchedule == null) continue;
            ++tableCount;
            HashMap<String, TwsJobAttributes> jobs = twsSchedule.getJobs();
            if (jobs == null) continue;
            jobCount += jobs.size();
        }
        this.m_NodeName_EntityCount.put(JOBS, Integer.toString(jobCount));
        this.m_NodeName_EntityCount.put(TABLES, Integer.toString(tableCount));
        DefaultMutableTreeNode mainTreeNodes = new DefaultMutableTreeNode(Params.instance().getDatasourceName());
        DefaultMutableTreeNode mainJobsNode = new DefaultMutableTreeNode("Jobs(" + jobCount + ")");
        DefaultMutableTreeNode mainCalendarsDefinedNode = null;
        DefaultMutableTreeNode definedCPUsNode = null;
        DefaultMutableTreeNode resourcesNode = null;
        DefaultMutableTreeNode maestroNode = null;
        DefaultMutableTreeNode peopleSoftNode = null;
        DefaultMutableTreeNode sapNode = null;
        if (this.handleCalendars && null != this.m_CalendarTXTReader && null != (allCalendars = this.m_CalendarTXTReader.getAllCalendarsNames())) {
            Collections.sort(allCalendars);
            if (!allCalendars.isEmpty()) {
                for (String calName : allCalendars) {
                    this.calName2JobList.put(calName, new ArrayList());
                }
            }
        }
        try (CsvReader cpuCsvReader = new CsvReader(Params.instance().getDatasourcePath() + "cpus.csv");){
            cpuCsvReader.setHeaders(TwsGlobals.CPUS_ATTRIBUTES);
            cpuCsvReader.readRecord();
            while (cpuCsvReader.readRecord()) {
                String cpuName = cpuCsvReader.get("NAME");
                if (cpuName == null || cpuName.isEmpty()) continue;
                StringBuilder cpuDesc = new StringBuilder();
                for (i = 0; i < TwsGlobals.CPUS_ATTRIBUTES.length; ++i) {
                    param = cpuCsvReader.get(i);
                    if (param == null || param.isEmpty()) continue;
                    cpuDesc.append(TwsGlobals.CPUS_ATTRIBUTES[i]).append(" : ").append(param).append("\n");
                }
                this.cpuName2cpuDescription.put(cpuName, cpuDesc.toString());
            }
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        try (CsvReader resourceCsvReader = new CsvReader(Params.instance().getDatasourcePath() + "resources.csv");){
            resourceCsvReader.setHeaders(TwsGlobals.RESOURCES_ATTRIBUTES);
            resourceCsvReader.readRecord();
            while (resourceCsvReader.readRecord()) {
                String resourceName = resourceCsvReader.get("ResourceName");
                if (resourceName == null || resourceName.isEmpty()) continue;
                StringBuilder resourceDesc = new StringBuilder();
                for (i = 0; i < TwsGlobals.RESOURCES_ATTRIBUTES.length; ++i) {
                    param = resourceCsvReader.get(i);
                    if (param == null || param.isEmpty()) continue;
                    resourceDesc.append(TwsGlobals.RESOURCES_ATTRIBUTES[i]).append(" : ").append(param).append("\n");
                }
                this.resourceName2resourceDescription.put(resourceName, resourceDesc.toString());
            }
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        for (String cpuName : this.cpuName2cpuDescription.keySet()) {
            this.cpuName2EntityList.put(cpuName, new ArrayList());
        }
        for (String resourceName : this.resourceName2resourceDescription.keySet()) {
            this.resourceName2EntityList.put(resourceName, new ArrayList());
        }
        for (TwsScheduleAttributes twsSchedule : this.schedules.values()) {
            AttrHolderList params;
            if (twsSchedule == null) continue;
            Object tableName = twsSchedule.getName();
            String cpuName = ((String)tableName).substring(0, ((String)tableName).indexOf("#"));
            if (this.cpuName2EntityList.containsKey(cpuName)) {
                if (!this.cpuName2EntityList.get(cpuName).contains(tableName)) {
                    this.cpuName2EntityList.get(cpuName).add((String)tableName);
                }
            } else {
                ArrayList<String> list = new ArrayList<String>();
                list.add((String)tableName);
                this.cpuName2EntityList.put(cpuName, list);
            }
            StringBuilder tableDescSB = new StringBuilder();
            IAttrHolder attributes = twsSchedule.getAttributes();
            if (attributes != null) {
                String[] attrHeaders = attributes.getCsvHeader().split(",");
                for (String attrHeader : attrHeaders) {
                    String value;
                    if (attrHeader.equalsIgnoreCase("ID") || (value = attributes.getAttr(attrHeader)) == null || value.isEmpty()) continue;
                    tableDescSB.append(attrHeader).append(" : ").append(value).append("\n");
                    for (String calName : this.calName2JobList.keySet()) {
                        if (!value.contains(calName) || this.calName2JobList.get(calName).contains(twsSchedule.getName())) continue;
                        this.calName2JobList.get(calName).add(twsSchedule.getName());
                    }
                }
            }
            if ((params = twsSchedule.getParams()) != null) {
                for (IAttrHolder attr : params) {
                    String param2 = null;
                    String value = null;
                    String[] paramHeaders = attr.getCsvHeader().split(",");
                    for (String paramHeader : paramHeaders) {
                        if (paramHeader.equalsIgnoreCase("ID")) continue;
                        if (paramHeader.equalsIgnoreCase("PARAMETER")) {
                            param2 = attr.getAttr(paramHeader);
                        } else if (paramHeader.equalsIgnoreCase("VALUE")) {
                            value = attr.getAttr(paramHeader);
                        }
                        if (param2 == null || value == null || param2.isEmpty() || value.isEmpty()) continue;
                        tableDescSB.append(param2).append(" : ").append(value).append("\n");
                        for (String calName : this.calName2JobList.keySet()) {
                            if (!value.contains(calName) || this.calName2JobList.get(calName).contains(twsSchedule.getName())) continue;
                            this.calName2JobList.get(calName).add(twsSchedule.getName());
                        }
                        if (!param2.equalsIgnoreCase("NEEDS")) continue;
                        String resourceName = value.substring(value.indexOf(" ") + 1);
                        tableName = twsSchedule.getName();
                        if (this.resourceName2EntityList.containsKey(resourceName)) {
                            if (this.resourceName2EntityList.get(resourceName).contains(tableName)) continue;
                            this.resourceName2EntityList.get(resourceName).add((String)tableName);
                            continue;
                        }
                        ArrayList<Object> list = new ArrayList<Object>();
                        list.add(tableName);
                        this.resourceName2EntityList.put(resourceName, list);
                    }
                }
            }
            this.entityDescription.put(twsSchedule.getName(), tableDescSB.toString());
            HashMap<String, TwsJobAttributes> jobs = twsSchedule.getJobs();
            DefaultMutableTreeNode tableNode = new DefaultMutableTreeNode(tableName + "(" + jobs.size() + ")");
            for (TwsJobAttributes job : jobs.values()) {
                AttrHolderList scheduleJobParmsAttrHolderList;
                int n;
                Object jobAttrHeaders;
                StringBuilder jobDescSB = new StringBuilder();
                String jobName = job.getName();
                String cpuNameforJob = "";
                if (jobName.contains("#")) {
                    cpuNameforJob = jobName.substring(0, jobName.indexOf("#"));
                } else {
                    String schedule = twsSchedule.getName();
                    if (schedule.contains("#")) {
                        cpuNameforJob = schedule.substring(0, schedule.indexOf("#"));
                    }
                }
                if (this.cpuName2EntityList.containsKey(cpuNameforJob)) {
                    if (!this.cpuName2EntityList.get(cpuNameforJob).contains(jobName)) {
                        this.cpuName2EntityList.get(cpuNameforJob).add(jobName);
                    }
                } else {
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(jobName);
                    this.cpuName2EntityList.put(cpuNameforJob, list);
                }
                DefaultMutableTreeNode jobNode = new DefaultMutableTreeNode(jobName);
                IAttrHolder jobAttr = job.getJobAttributes();
                if (jobAttr != null) {
                    String taskType;
                    String docommand;
                    String streamLogon = jobAttr.getAttr("streamlogon");
                    if (streamLogon.equalsIgnoreCase("MAESTRO")) {
                        this.maestroJobsList.add(jobName);
                    }
                    if (PeopleSoftHandler.isPeopleSoftJob(docommand = jobAttr.getAttr("scriptname/docommand"))) {
                        this.peopleSoftJobsList.add(jobName);
                    }
                    if (SapHandler.isSap(taskType = jobAttr.getAttr("tasktype"))) {
                        this.sapJobsList.add(jobName);
                    }
                    Object object = jobAttrHeaders = jobAttr.getCsvHeader().split(",");
                    n = ((Object)object).length;
                    for (int j = 0; j < n; ++j) {
                        String value;
                        Object jobAttrHeader = object[j];
                        if (((String)jobAttrHeader).equalsIgnoreCase("ID") || (value = jobAttr.getAttr((String)jobAttrHeader)) == null || value.isEmpty()) continue;
                        jobDescSB.append((String)jobAttrHeader).append(" : ").append(value).append("\n");
                    }
                }
                IAttrHolder scheduleJobAttrHolder = job.getscheduleJob();
                Object jobNameLine = "";
                if (scheduleJobAttrHolder != null) {
                    String[] scheduleJobAttrHeaders = scheduleJobAttrHolder.getCsvHeader().split(",");
                    jobAttrHeaders = scheduleJobAttrHeaders;
                    int n2 = ((String[])jobAttrHeaders).length;
                    for (n = 0; n < n2; ++n) {
                        String value;
                        Object scheduleJobAttrHeader = jobAttrHeaders[n];
                        if (((String)scheduleJobAttrHeader).equalsIgnoreCase("ID") || (value = scheduleJobAttrHolder.getAttr((String)scheduleJobAttrHeader)) == null || value.isEmpty()) continue;
                        String line = (String)scheduleJobAttrHeader + " : " + value + "\n";
                        if (((String)scheduleJobAttrHeader).equalsIgnoreCase("job")) {
                            jobNameLine = line;
                            continue;
                        }
                        jobDescSB.append(line);
                    }
                }
                if ((scheduleJobParmsAttrHolderList = job.getscheduleJobParms()) != null) {
                    jobAttrHeaders = scheduleJobParmsAttrHolderList.iterator();
                    while (jobAttrHeaders.hasNext()) {
                        String[] paramHeaders;
                        IAttrHolder attr = (IAttrHolder)jobAttrHeaders.next();
                        String param3 = null;
                        String value = null;
                        for (String paramHeader : paramHeaders = attr.getCsvHeader().split(",")) {
                            if (paramHeader.equalsIgnoreCase("ID")) continue;
                            if (paramHeader.equalsIgnoreCase("PARAMETER")) {
                                param3 = attr.getAttr(paramHeader);
                            } else if (paramHeader.equalsIgnoreCase("VALUE")) {
                                value = attr.getAttr(paramHeader);
                            }
                            if (param3 == null || value == null || param3.isEmpty() || value.isEmpty()) continue;
                            jobDescSB.append(param3).append(" : ").append(value).append("\n");
                            if (!param3.equalsIgnoreCase("NEEDS")) continue;
                            String resourceName = value.substring(value.indexOf(" ") + 1);
                            if (this.resourceName2EntityList.containsKey(resourceName)) {
                                if (this.resourceName2EntityList.get(resourceName).contains(jobName)) continue;
                                this.resourceName2EntityList.get(resourceName).add(jobName);
                                continue;
                            }
                            ArrayList<String> list = new ArrayList<String>();
                            list.add(jobName);
                            this.resourceName2EntityList.put(resourceName, list);
                        }
                    }
                }
                String desc = jobDescSB.toString();
                jobDescSB = new StringBuilder((String)jobNameLine);
                jobDescSB.append(desc);
                this.entityDescription.put(job.getName(), jobDescSB.toString());
                tableNode.add(jobNode);
            }
            mainJobsNode.add(tableNode);
        }
        mainTreeNodes.add(mainJobsNode);
        if (this.handleCalendars) {
            allCalendars = this.m_CalendarTXTReader.getAllCalendarsNames();
            ArrayList<DefaultMutableTreeNode> inUseCalendarNodeList = new ArrayList<DefaultMutableTreeNode>();
            if (null != allCalendars) {
                Collections.sort(allCalendars);
                if (!allCalendars.isEmpty()) {
                    mainCalendarsDefinedNode = new DefaultMutableTreeNode("Calendars - Defined(" + allCalendars.size() + ")");
                    for (String calName : allCalendars) {
                        int calSize = this.calName2JobList.get(calName).size();
                        if (calSize > 0) {
                            inUseCalendarNodeList.add(new DefaultMutableTreeNode(calName + "(" + calSize + ")"));
                        }
                        mainCalendarsDefinedNode.add(new DefaultMutableTreeNode(calName + "(" + calSize + ")"));
                    }
                }
            }
            this.m_NodeName_EntityCount.put(DEFINED_CALENDARS, Integer.toString(allCalendars.size()));
            if (mainCalendarsDefinedNode != null) {
                mainTreeNodes.add(mainCalendarsDefinedNode);
            }
            if (!inUseCalendarNodeList.isEmpty()) {
                DefaultMutableTreeNode mainCalendarsInUseNode = new DefaultMutableTreeNode("Calendars - In use(" + inUseCalendarNodeList.size() + ")");
                for (DefaultMutableTreeNode inUseNode : inUseCalendarNodeList) {
                    mainCalendarsInUseNode.add(inUseNode);
                }
                this.m_NodeName_EntityCount.put(IN_USE_CALENDARS, Integer.toString(inUseCalendarNodeList.size()));
                mainTreeNodes.add(mainCalendarsInUseNode);
            }
        }
        ArrayList<DefaultMutableTreeNode> inUseCPUNodes = new ArrayList<DefaultMutableTreeNode>();
        if (!this.cpuName2cpuDescription.isEmpty()) {
            definedCPUsNode = new DefaultMutableTreeNode("CPUs - Defined(" + this.cpuName2cpuDescription.size() + ")");
            for (String cpuName : this.cpuName2cpuDescription.keySet()) {
                int count = 0;
                if (this.cpuName2EntityList.get(cpuName) != null) {
                    count = this.cpuName2EntityList.get(cpuName).size();
                }
                if (count > 0) {
                    inUseCPUNodes.add(new DefaultMutableTreeNode(cpuName + "(" + count + ")"));
                    if (count <= 25) {
                        this.listNamesOflowMachinesUse.add(cpuName);
                        ++this.lowMachinesUseCount;
                    }
                }
                definedCPUsNode.add(new DefaultMutableTreeNode(cpuName + "(" + count + ")"));
            }
        }
        this.m_NodeName_EntityCount.put(DEFINED_CPUS, Integer.toString(this.cpuName2cpuDescription.size()));
        if (definedCPUsNode != null) {
            mainTreeNodes.add(definedCPUsNode);
        }
        if (!inUseCPUNodes.isEmpty()) {
            DefaultMutableTreeNode inUseCPUsNode = new DefaultMutableTreeNode("CPUs - In use(" + inUseCPUNodes.size() + ")");
            for (DefaultMutableTreeNode inUseCPU : inUseCPUNodes) {
                inUseCPUsNode.add(inUseCPU);
            }
            mainTreeNodes.add(inUseCPUsNode);
            this.m_NodeName_EntityCount.put(IN_USE_CPUS, Integer.toString(inUseCPUNodes.size()));
            this.m_NodeName_EntityCount.put(AGENTS, Integer.toString(inUseCPUNodes.size()));
        }
        if (!this.resourceName2resourceDescription.isEmpty()) {
            resourcesNode = new DefaultMutableTreeNode("Resources(" + this.resourceName2resourceDescription.size() + ")");
            for (String resourceName : this.resourceName2resourceDescription.keySet()) {
                int count = 0;
                if (this.resourceName2EntityList.get(resourceName) != null) {
                    count = this.resourceName2EntityList.get(resourceName).size();
                }
                resourcesNode.add(new DefaultMutableTreeNode(resourceName + "(" + count + ")"));
            }
        }
        this.m_NodeName_EntityCount.put(RESOURCES, Integer.toString(this.resourceName2resourceDescription.size()));
        if (resourcesNode != null) {
            mainTreeNodes.add(resourcesNode);
        }
        if (!this.maestroJobsList.isEmpty()) {
            maestroNode = new DefaultMutableTreeNode("Maestro jobs(" + this.maestroJobsList.size() + ")");
            for (String maestroJob : this.maestroJobsList) {
                maestroNode.add(new DefaultMutableTreeNode(maestroJob));
            }
        }
        this.m_NodeName_EntityCount.put(MAESTRO_JOBS, Integer.toString(this.maestroJobsList.size()));
        if (maestroNode != null) {
            mainTreeNodes.add(maestroNode);
        }
        if (!this.peopleSoftJobsList.isEmpty()) {
            peopleSoftNode = new DefaultMutableTreeNode("PeopleSoft jobs(" + this.peopleSoftJobsList.size() + ")");
            for (String peopleSoftJob : this.peopleSoftJobsList) {
                peopleSoftNode.add(new DefaultMutableTreeNode(peopleSoftJob));
            }
        }
        this.m_NodeName_EntityCount.put(PEOPLESOFT_JOBS, Integer.toString(this.peopleSoftJobsList.size()));
        if (peopleSoftNode != null) {
            mainTreeNodes.add(peopleSoftNode);
        }
        if (!this.sapJobsList.isEmpty()) {
            sapNode = new DefaultMutableTreeNode("SAP jobs(" + this.sapJobsList.size() + ")");
            for (String sapJob : this.sapJobsList) {
                sapNode.add(new DefaultMutableTreeNode(sapJob));
            }
        }
        this.m_NodeName_EntityCount.put(SAP_JOBS, Integer.toString(this.sapJobsList.size()));
        if (sapNode != null) {
            mainTreeNodes.add(sapNode);
        }
        return mainTreeNodes;
    }

    protected HashMap<String, String> getDescriptionNodes() {
        TwsAssessmentSummaryBuilder summaryBuilder = new TwsAssessmentSummaryBuilder(this);
        return summaryBuilder.getDescriptionNodes();
    }

    protected ArrayList<String> getDescriptionTypeLookNodes() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(Params.instance().getDatasourceName());
        result.add(JOBS);
        result.add(MAESTRO_JOBS);
        result.add(PEOPLESOFT_JOBS);
        result.add(SAP_JOBS);
        return result;
    }

    protected ArrayList<String> getDescriptionTypeSplitLookNodes() {
        return null;
    }

    protected String getJobInfo(String messageID) {
        if (messageID == null || messageID.isEmpty()) {
            return "";
        }
        String[] messagePartArray = messageID.split(";");
        if (messagePartArray[1].contains(DEFINED_CALENDARS)) {
            String calName = messagePartArray[2];
            calName = calName.substring(0, calName.indexOf("("));
            return this.m_CalendarTXTReader.getCalendarDescription(calName);
        }
        if (messagePartArray[1].contains(IN_USE_CALENDARS)) {
            String calName = messagePartArray[2];
            calName = calName.substring(0, calName.indexOf("("));
            return this.m_CalendarTXTReader.getCalendarDescription(calName);
        }
        if (messagePartArray[1].contains(DEFINED_CPUS) || messagePartArray[1].contains(IN_USE_CPUS)) {
            String cpuName = messagePartArray[2];
            cpuName = cpuName.substring(0, cpuName.indexOf("("));
            return this.cpuName2cpuDescription.get(cpuName);
        }
        if (messagePartArray[1].contains(RESOURCES)) {
            String resourceName = messagePartArray[2];
            resourceName = resourceName.substring(0, resourceName.indexOf("("));
            return this.resourceName2resourceDescription.get(resourceName);
        }
        String entityName = messagePartArray[messagePartArray.length - 1];
        if (messagePartArray.length == 3 && messagePartArray[messagePartArray.length - 1].endsWith(")")) {
            entityName = entityName.substring(0, entityName.lastIndexOf("("));
        }
        String message = this.entityDescription.get(entityName);
        return message;
    }

    protected String getJobInfoFromSelectionList(String messageID) {
        return this.entityDescription.get(messageID);
    }

    protected ArrayList<String> getSelectionList(String parentNodeID) {
        String calName;
        ArrayList<Object> retList = new ArrayList();
        String[] messagePartArray = parentNodeID.split(";");
        if (messagePartArray[1].contains(DEFINED_CALENDARS)) {
            calName = messagePartArray[messagePartArray.length - 1];
            calName = calName.substring(0, calName.indexOf("("));
            retList = this.calName2JobList.get(calName);
        }
        if (messagePartArray[1].contains(IN_USE_CALENDARS)) {
            calName = messagePartArray[messagePartArray.length - 1];
            calName = calName.substring(0, calName.indexOf("("));
            retList = this.calName2JobList.get(calName);
        } else if (messagePartArray[1].contains(DEFINED_CPUS) || messagePartArray[1].contains(IN_USE_CPUS)) {
            String cpuName = messagePartArray[messagePartArray.length - 1];
            cpuName = cpuName.substring(0, cpuName.indexOf("("));
            retList = this.cpuName2EntityList.get(cpuName);
        } else if (messagePartArray[1].contains(RESOURCES)) {
            String resourceName = messagePartArray[messagePartArray.length - 1];
            resourceName = resourceName.substring(0, resourceName.indexOf("("));
            retList = this.resourceName2EntityList.get(resourceName);
        }
        return retList;
    }

    public AssessmentXMLDescriptionReader getM_DescriptionXMLReader() {
        return this.m_DescriptionXMLReader;
    }

    public HashMap<String, TwsScheduleAttributes> getSchedules() {
        return this.schedules;
    }

    public Map<String, String> getNodeNameToEntityCount() {
        return this.m_NodeName_EntityCount;
    }
}

