/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tws;

import com.bmc.ctmconvert.common.CsvFile;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.tws.TwsDefs;
import com.bmc.ctmconvert.tws.TwsGlobals;
import com.bmc.ctmconvert.tws.TwsJobAttributes;
import com.bmc.ctmconvert.tws.TwsScheduleAttributes;
import java.util.HashMap;

public class ScheduleJobsTable
extends CsvFile {
    private HashMap<String, TwsScheduleAttributes> schedules;

    public ScheduleJobsTable(TwsDefs father) {
        this.schedules = father.getSchedules();
    }

    public ScheduleJobsTable(HashMap<String, TwsScheduleAttributes> schedules) {
        this.schedules = schedules;
    }

    protected void handleRecord(IAttrHolder scheduleJob, int record_number) {
        String fullId = scheduleJob.getAttr("ID");
        if (fullId.isEmpty()) {
            return;
        }
        String[] ids = fullId.split(" ", 2);
        TwsScheduleAttributes sched = this.schedules.get(ids[0]);
        if (sched != null) {
            String id = ids[1];
            String alias = TwsGlobals.createAliasFromFullId(fullId);
            if (!id.equals(alias)) {
                sched.mapAlias(id.split(" ")[0], alias);
                id = alias;
            }
            sched.getJobs().put(id, new TwsJobAttributes(scheduleJob));
        }
    }
}

