/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tws;

import com.bmc.ctmconvert.common.CsvFile;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.tws.TwsDefs;
import com.bmc.ctmconvert.tws.TwsGlobals;
import com.bmc.ctmconvert.tws.TwsJobAttributes;
import com.bmc.ctmconvert.tws.TwsScheduleAttributes;
import java.util.HashMap;

public class ScheduleJobsParamsTable
extends CsvFile {
    private TwsDefs father;
    private HashMap<String, TwsScheduleAttributes> schedules;
    private boolean createDeps;

    public ScheduleJobsParamsTable(TwsDefs father) {
        this.father = father;
        this.schedules = father.getSchedules();
        this.createDeps = true;
    }

    public ScheduleJobsParamsTable(HashMap<String, TwsScheduleAttributes> schedules) {
        this.schedules = schedules;
        this.createDeps = false;
    }

    protected void handleRecord(IAttrHolder scheduleJobParams, int record_number) {
        String fullId = scheduleJobParams.getAttr("ID");
        if (fullId.isEmpty()) {
            return;
        }
        String[] ids = fullId.split(" ", 2);
        TwsScheduleAttributes sched = this.schedules.get(ids[0]);
        if (sched != null) {
            String id = TwsGlobals.createAliasFromFullId(fullId);
            TwsJobAttributes job = sched.getJobs().get(id);
            job.addtoscheduleJobParms(scheduleJobParams);
        }
        if (this.createDeps && scheduleJobParams.getAttr("PARAMETER").equalsIgnoreCase("FOLLOWS")) {
            this.father.createDeps(scheduleJobParams.getAttr("VALUE"), scheduleJobParams.getAttr("ID"));
        }
    }
}

