/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tws;

import com.bmc.ctmconvert.tws.TwsAssessmentJobTypeData;
import java.util.List;

public class JobTypeDistributionStringBuilder {
    static final String ORIGINAL_JOB_TYPE = "#ORIGINAL_JOB_TYPE#";
    static final String JOBS_AMOUNT = "#JOBS_AMOUNT#";
    static final String TARGET_JOB_TYPE = "#TARGET_JOB_TYPE#";
    private String template;

    public JobTypeDistributionStringBuilder(String template) {
        this.template = template;
    }

    public String buildJobTypeDistribution(List<TwsAssessmentJobTypeData> jobTypesDataList) {
        StringBuilder toRet = new StringBuilder();
        toRet.append("------------------------------");
        toRet.append("\n");
        for (TwsAssessmentJobTypeData jobTypeData : jobTypesDataList) {
            if (!jobTypeData.shouldDisplay()) continue;
            String line = this.template;
            line = line.replace(ORIGINAL_JOB_TYPE, jobTypeData.originalType);
            line = line.replace(JOBS_AMOUNT, Integer.toString(jobTypeData.amount));
            line = line.replace(TARGET_JOB_TYPE, jobTypeData.targetType);
            toRet.append(line);
            toRet.append("\n");
        }
        toRet.append("\n");
        toRet.append("Note:\nThe number of Control-M jobs that will be created after conversion can be larger than the number of TWS Jobs found in the input data,\nas in Control-M we create a job for each TWS job instance.");
        return toRet.toString();
    }
}

