/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tws;

import com.bmc.ctmconvert.tws.InavlidJobFileException;
import com.bmc.ctmconvert.tws.JobText;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JobReader {
    private BufferedReader input;
    private String prevLine = null;
    private String endXml = "</jsdl:jobDefinition>";
    private String startXml = "<jsdl:jobDefinition";

    public JobReader(InputStream jobsInputStream) throws InavlidJobFileException, IOException {
        this.input = new BufferedReader(new InputStreamReader(jobsInputStream));
        String line = this.input.readLine();
        if (line != null && line.trim().compareToIgnoreCase("$JOBS") != 0 && !line.contains("IBM Workload Scheduler")) {
            this.input.close();
            throw new InavlidJobFileException("the file does not start with \"$JOBS\" or \"IBM Workload Scheduler\"");
        }
        while ((line = this.input.readLine()) != null && !this.isJobName(line)) {
        }
        this.prevLine = line;
    }

    public JobText readNextJob() throws IOException {
        String line = this.prevLine;
        boolean taskKeywordFound = false;
        boolean emptyLineFound = false;
        JobText job = new JobText();
        this.prevLine = null;
        if (this.isJobName(line)) {
            job.addContent(line.trim());
            while ((line = this.input.readLine()) != null) {
                if (this.checkTaskKeywordFound(line)) {
                    taskKeywordFound = true;
                }
                if (taskKeywordFound && line.contains(this.startXml)) {
                    this.handleXmlContent(line, job, this.endXml);
                    continue;
                }
                if (line.trim().isEmpty()) {
                    emptyLineFound = true;
                    continue;
                }
                if (this.isJobName(line) && emptyLineFound) {
                    this.prevLine = line;
                    return job;
                }
                if (line.startsWith("Workstation")) {
                    while ((line = this.input.readLine()) != null && !this.isJobName(line)) {
                    }
                    this.prevLine = line;
                    return job;
                }
                job.addContent(line.trim());
                emptyLineFound = false;
            }
            return job;
        }
        this.input.close();
        return null;
    }

    private boolean checkTaskKeywordFound(String line) {
        return line.trim().toUpperCase().startsWith("TASK");
    }

    private void handleXmlContent(String line, JobText job, String endXml) throws IOException {
        String tmpLine;
        job.addContent(line);
        job.setxmlStartLine(job.getSize() - 1);
        while (!line.contains(endXml) && (tmpLine = this.input.readLine()) != null) {
            job.addContent(tmpLine);
            if (!tmpLine.contains(endXml)) continue;
            job.setxmlEndLine(job.getSize() - 1);
            break;
        }
    }

    private boolean isJobName(String line) {
        if (line == null) {
            return false;
        }
        Pattern pattern = Pattern.compile("^[A-Za-z0-9_-]*#[A-Za-z0-9_-]*");
        Matcher matcher = pattern.matcher(line.trim());
        return matcher.find();
    }
}

