/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.caespToCtmBridgeBuilder;

import com.bmc.caespToCtmBridgeBuilder.BridgeJobParameters;
import com.bmc.ctmconvert.common.log.Logger;
import java.util.ArrayList;

public class JCLReader {
    private static final int LINE_LENGTH_FORMAT = 4;

    public String update(String jclContent, BridgeJobParameters bridgeJobParameters) {
        int index;
        String originalJclContent = jclContent;
        if (!this.isValidJCL(jclContent).booleanValue()) {
            return originalJclContent;
        }
        ArrayList<String> lines = new ArrayList<String>();
        jclContent = jclContent.replaceAll("&lt;", "<");
        jclContent = jclContent.replaceAll("&gt;", ">");
        try {
            int lineLengthInt;
            for (index = 0; index < jclContent.length(); index += lineLengthInt + 4) {
                String lineLength = jclContent.substring(index, index + 4);
                lineLengthInt = Integer.parseInt(lineLength);
                lines.add(jclContent.substring(index, index + lineLengthInt + 4));
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            Logger.getLogger().writeToLog("Failed to read the CTM Embedded JCL invalid line in : \n" + originalJclContent.substring(index));
            return originalJclContent;
        }
        StringBuilder newJclContent = new StringBuilder();
        lines.stream().forEach(line -> {
            if (line.contains("@CTMJOB@")) {
                String newline = this.getUpdatedLine(bridgeJobParameters, (String)line);
                newJclContent.append(newline);
            } else {
                newJclContent.append((String)line);
            }
        });
        return newJclContent.toString();
    }

    private String getUpdatedLine(BridgeJobParameters bridgeJobParameters, String line) {
        line = line.replace("@CTMJOB@", bridgeJobParameters.getCtmJobName());
        line = line.replace("@FOLDER@", bridgeJobParameters.getCtmFolder());
        String content = line.substring(4);
        String newline = String.format("%04d%s", content.length(), content);
        return newline;
    }

    private Boolean isValidJCL(String jclContent) {
        if (jclContent.length() < 4) {
            return false;
        }
        return true;
    }
}

