/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.caespToCtmBridgeBuilder;

import com.bmc.caespToCtmBridgeBuilder.Constants;
import com.bmc.ctmconvert.common.KeyValueFileReader;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class ConditionPrefixesHandler {
    private Map<Constants.BridgeType, String> bridgeType2PrefixMap;
    private String globalConditionPrefix;

    public ConditionPrefixesHandler() {
        this.setUpDefault();
    }

    public void loadCustomPrefixes(InputStream inputStream) {
        if (inputStream == null) {
            return;
        }
        KeyValueFileReader keyValueReader = new KeyValueFileReader();
        Map ConditionPrefixesMap = keyValueReader.convertFileToMap(inputStream);
        ConditionPrefixesMap.keySet().stream().forEach(bridgeTypeValue -> {
            block2: {
                try {
                    Constants.BridgeType bridgeType = Constants.BridgeType.valueOf(bridgeTypeValue);
                    String prefix = (String)ConditionPrefixesMap.get(bridgeTypeValue);
                    this.bridgeType2PrefixMap.put(bridgeType, prefix);
                }
                catch (IllegalArgumentException e) {
                    if (!bridgeTypeValue.equals("GLOBAL_CONIDITION_PREFIX")) break block2;
                    this.globalConditionPrefix = (String)ConditionPrefixesMap.get(bridgeTypeValue);
                }
            }
        });
    }

    private void setUpDefault() {
        this.bridgeType2PrefixMap = new HashMap<Constants.BridgeType, String>();
        for (Constants.BridgeType bridgeType : Constants.BridgeType.values()) {
            this.bridgeType2PrefixMap.put(bridgeType, "EP-");
        }
        this.globalConditionPrefix = "GC-";
    }

    public String getGlobalConditionPrefix() {
        return this.globalConditionPrefix;
    }

    public Map<Constants.BridgeType, String> getBridgeType2PrefixMap() {
        return this.bridgeType2PrefixMap;
    }
}

