/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.caespToCtmBridgeBuilder;

import com.bmc.caespToCtmBridgeBuilder.ActionItemsHandler;
import com.bmc.caespToCtmBridgeBuilder.BridgeDefinitionsReader;
import com.bmc.caespToCtmBridgeBuilder.BridgeException;
import com.bmc.caespToCtmBridgeBuilder.BridgeJobParameters;
import com.bmc.caespToCtmBridgeBuilder.BridgeRecord;
import com.bmc.caespToCtmBridgeBuilder.BridgeStreamRepository;
import com.bmc.caespToCtmBridgeBuilder.ConditionPrefixesHandler;
import com.bmc.caespToCtmBridgeBuilder.CtmToEspBridge;
import com.bmc.caespToCtmBridgeBuilder.CtoRulesHandler;
import com.bmc.caespToCtmBridgeBuilder.ESPToCtmBridge;
import com.bmc.caespToCtmBridgeBuilder.IBridgeHandler;
import com.bmc.ctmconvert.excel.ActionItem;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.function.Predicate;

public class BridgesBuilder {
    private static final String ESP_BRIDGE_PREFIX = "ESP";
    private static final String CTM_BRIDGE_PREFIX = "CTM";
    private BridgeStreamRepository bridgeStreamRepository;
    private CtoRulesHandler ctoRulesHandler;
    private ActionItemsHandler actionItemsHandler;
    private CtmToEspBridge ctmToEsp;

    public BridgesBuilder(BridgeStreamRepository bridgeStreamRepository) {
        this.bridgeStreamRepository = bridgeStreamRepository;
    }

    public void build() throws IOException, BridgeException {
        this.ctoRulesHandler = new CtoRulesHandler(this.bridgeStreamRepository.getCtoRuleTemplateStream());
        this.actionItemsHandler = new ActionItemsHandler();
        ConditionPrefixesHandler conditionPrefixesHandler = new ConditionPrefixesHandler();
        conditionPrefixesHandler.loadCustomPrefixes(this.bridgeStreamRepository.getConditionPrefixesStream());
        ESPToCtmBridge espToCtm = new ESPToCtmBridge(this.ctoRulesHandler, this.actionItemsHandler, conditionPrefixesHandler);
        this.ctmToEsp = new CtmToEspBridge(this.actionItemsHandler, conditionPrefixesHandler);
        BridgeDefinitionsReader bridgeDefinitionsReader = new BridgeDefinitionsReader();
        InputStream bridgeData = this.bridgeStreamRepository.getBridgeData();
        List<BridgeRecord> records = bridgeDefinitionsReader.read(bridgeData);
        this.handleRecordsByPrefix(records, ESP_BRIDGE_PREFIX, espToCtm);
        this.handleRecordsByPrefix(records, CTM_BRIDGE_PREFIX, this.ctmToEsp);
    }

    private void handleRecordsByPrefix(List<BridgeRecord> records, String bridgePrefix, IBridgeHandler handler) {
        Predicate<BridgeRecord> isMatchBridge = record -> record.getType().toString().toUpperCase().startsWith(bridgePrefix);
        records.stream().filter(isMatchBridge).forEach(ctmToEspRecord -> handler.handleRecord((BridgeRecord)ctmToEspRecord));
    }

    public List<String> getCtoRules() {
        return this.ctoRulesHandler.getCtoRulesList();
    }

    public List<ActionItem> getActionItems() {
        return this.actionItemsHandler.getActionItems();
    }

    public List<BridgeJobParameters> getJobsParametersList() {
        return this.ctmToEsp.getJobsParametersList();
    }
}

