/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.caespToCtmBridgeBuilder;

import com.bmc.caespToCtmBridgeBuilder.BridgeException;
import com.bmc.caespToCtmBridgeBuilder.Constants;
import java.util.Arrays;
import java.util.List;

public class BridgeRecord {
    private static final int VENDOR_JOB_INDEX = 0;
    private static final int CTM_JOB_INDEX = 1;
    private static final int TYPE_INDEX = 2;
    private static final int BRIDGE_RECORD_SIZE = 3;
    private String vendorPath;
    private String ctmPath;
    private String vendorJob;
    private String ctmJob;
    private String vendorFolder;
    private String ctmFolder;
    private Constants.BridgeType type;

    public BridgeRecord(String[] values) throws BridgeException {
        this.validateRecord(Arrays.asList(values));
        this.vendorPath = values[0];
        String[] sourcejobPath = this.vendorPath.split("\\\\");
        this.vendorFolder = sourcejobPath[0];
        this.vendorJob = sourcejobPath[1];
        this.ctmPath = values[1];
        String[] ctmJobPath = this.ctmPath.split("\\\\");
        this.ctmFolder = ctmJobPath[0];
        this.ctmJob = ctmJobPath[1];
        String typeString = values[2].toUpperCase().trim();
        try {
            this.type = Constants.BridgeType.valueOf(typeString);
        }
        catch (IllegalArgumentException e) {
            throw new BridgeException(String.format("Invalid Bridge Definition: %s", Arrays.asList(values)));
        }
    }

    private void validateRecord(List<String> list) throws BridgeException {
        if (list.size() < 3) {
            throw new BridgeException(String.format("Invalid Bridge Definition: %s", list));
        }
        String[] sourcejobPath = list.get(0).split("\\\\");
        String[] targetJobPath = list.get(1).split("\\\\");
        if (sourcejobPath.length < 2 || targetJobPath.length < 2) {
            throw new BridgeException(String.format("Invalid Bridge Definition: %s", list));
        }
    }

    public String getVendorPath() {
        return this.vendorPath;
    }

    public String getCtmPath() {
        return this.ctmPath;
    }

    public Constants.BridgeType getType() {
        return this.type;
    }

    public String getVendorFolder() {
        return this.vendorFolder;
    }

    public String getCtmFolder() {
        return this.ctmFolder;
    }

    public String getVendorJob() {
        return this.vendorJob;
    }

    public String getCtmJob() {
        return this.ctmJob;
    }
}

