/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.caespToCtmBridgeBuilder;

import com.bmc.caespToCtmBridgeBuilder.BridgeException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class ArgumentsParser {
    private String inputPath = "";
    private String outputPath = "";
    private String xmlSkeletonPath = null;
    private String templateCtoPath = null;

    public void parse(String[] args) throws IOException, BridgeException {
        List<String> argList = Arrays.asList(args);
        int inputIndex = argList.indexOf("-bridgesData");
        int outputIndex = argList.indexOf("-outputDirectory");
        int xmlSkeletonIndex = argList.indexOf("-ctmTemplate");
        int templateCtoIndex = argList.indexOf("-ctoTemplate");
        if (inputIndex == -1) {
            throw new BridgeException("Missing parameters.\r\n\r\nThe Bridge builder utility gets CA ESP <-> Control-M bridges definition information as input data and builds the following:\r\n-\tControl-O rules, which implements CA ESP to Control-M Bridges \r\n-\tControl-M MF Jobs, which implements Control-M to CA ESP bridges  \r\n\r\nUsage: BridgeBuilder\r\n        -bridgesData < Mandatory. Path to csv file with the required bridges information>\r\n        [ -ctmTemplate <Optional. Path to Control-M MF data template that will be used to create Control-M MF Bridges Jobs> ]\r\n        [ -ctoTemplate <Optional. Path to the Control-O template that will be used to create Control-O Bridges rules> ]\r\n        [ -outputDirectory <Optional. Path to the directory where BridgeBuilder outputs will be created > ]\r\n");
        }
        try {
            this.inputPath = argList.get(inputIndex + 1);
            if (xmlSkeletonIndex != -1) {
                this.xmlSkeletonPath = argList.get(xmlSkeletonIndex + 1);
            }
            if (outputIndex != -1) {
                this.outputPath = argList.get(outputIndex + 1);
            }
            if (templateCtoIndex != -1) {
                this.templateCtoPath = argList.get(templateCtoIndex + 1);
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new BridgeException("Missing parameters.\r\n\r\nThe Bridge builder utility gets CA ESP <-> Control-M bridges definition information as input data and builds the following:\r\n-\tControl-O rules, which implements CA ESP to Control-M Bridges \r\n-\tControl-M MF Jobs, which implements Control-M to CA ESP bridges  \r\n\r\nUsage: BridgeBuilder\r\n        -bridgesData < Mandatory. Path to csv file with the required bridges information>\r\n        [ -ctmTemplate <Optional. Path to Control-M MF data template that will be used to create Control-M MF Bridges Jobs> ]\r\n        [ -ctoTemplate <Optional. Path to the Control-O template that will be used to create Control-O Bridges rules> ]\r\n        [ -outputDirectory <Optional. Path to the directory where BridgeBuilder outputs will be created > ]\r\n");
        }
    }

    public String getInputPath() {
        return this.inputPath;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public String getXmlSkeletonPath() {
        return this.xmlSkeletonPath;
    }

    public String getTemplateCtoPath() {
        return this.templateCtoPath;
    }
}

