/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dSeries.sap.r3;

import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.dSeries.DSeriesJob;
import com.bmc.ctmconvert.dSeries.sap.ISapConvertor;
import com.bmc.ctmconvert.dSeries.sap.SapNodeParser;
import java.util.Optional;
import org.w3c.dom.Node;

public class SapBWConvertor
implements ISapConvertor {
    @Override
    public void convert(Node sapJobNode, DSeriesJob dSeriesJob) {
        this.setSapBWAttributes(dSeriesJob);
        this.setSapBWAutoedits(dSeriesJob);
        SapNodeParser parser = new SapNodeParser(sapJobNode);
        Optional<String> chainid = parser.getAttrValue("chainid");
        chainid.ifPresent(id -> dSeriesJob.addAutoEdits("%%SAPR3-ProcessChain_ID", (String)id));
    }

    private void setSapBWAttributes(DSeriesJob dSeriesJob) {
        Globs.SAP_TYPE_VERSION.forEach(dSeriesJob::setAttribute);
        dSeriesJob.setAttribute("TASKTYPE", "Job");
        dSeriesJob.setAttribute("APPL_FORM", "SAP Business Warehouse");
    }

    private void setSapBWAutoedits(DSeriesJob dSeriesJob) {
        dSeriesJob.addAutoEdits("%%SAPR3-JOB_MODE", "PC_RUN_ORG");
        dSeriesJob.addAutoEdits("%%SAPR3-PROCESS_TYPE", "ProcessChain");
        dSeriesJob.addAutoEdits("%%SAPR3-ACCOUNT", "DEFAULT_CONNECTION");
        dSeriesJob.addAutoEdits("%%SAPR3-PROCESSCHAIN_RERUN_INSTANCE", "PC_RUN_CURR_INSTANCE");
        dSeriesJob.addAutoEdits("%%SAPR3-PC_periodic", "X");
        dSeriesJob.addAutoEdits("%%SAPR3-PC_DONT_POLL", "N");
        dSeriesJob.addAutoEdits("%%SAPR3-JOBLOG", "*SYSOUT");
        dSeriesJob.addAutoEdits("%%SAPR3-OVERRIDE_JOBLOG_DEFAULT", "X");
        dSeriesJob.addAutoEdits("%%SAPR3-RUNCOUNT", "%%RUNCOUNT");
    }
}

