/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dSeries.sap;

import com.bmc.ctmconvert.sap.StepArgs;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SapNodeParser {
    private LinkedHashMap<String, Optional<String>> nodeAttributesMap = new LinkedHashMap();
    private StepArgs stepArgs = new StepArgs();
    private int i = 1;

    public SapNodeParser(Node sapJobNode) {
        this.setNodevaluesToMap(sapJobNode, this.nodeAttributesMap);
    }

    private void setNodevaluesToMap(Node sapJob, Map<String, Optional<String>> nodeAttributesMap) {
        this.handleNodeAttributeMap(sapJob);
        this.handleElementNode(sapJob, nodeAttributesMap);
        this.setNodeChildAttributesMap(sapJob, nodeAttributesMap);
    }

    private void handleNodeAttributeMap(Node sapJob) {
        NamedNodeMap namedNodeMap = sapJob.getAttributes();
        if (namedNodeMap != null) {
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node item = namedNodeMap.item(i);
                String attributeName = item.getNodeName();
                String attribteValue = item.getNodeValue().trim();
                this.nodeAttributesMap.put(attributeName, Optional.of(attribteValue));
            }
        }
    }

    private void handleElementNode(Node sapJob, Map<String, Optional<String>> currentMap) {
        if (this.isNodeWithoutChilds(sapJob)) {
            String[] splittedName = sapJob.getNodeName().split(":");
            String key = splittedName.length == 1 ? splittedName[0] : splittedName[1];
            String value = sapJob.getTextContent().trim();
            currentMap.put(key, Optional.of(value));
        }
    }

    private boolean isNodeWithoutChilds(Node sapJob) {
        return sapJob.getNodeType() == 1 && sapJob.getChildNodes().getLength() == 1;
    }

    private void setNodeChildAttributesMap(Node sapJobNode, Map<String, Optional<String>> nodeAttributesMap) {
        if (sapJobNode.getNodeName().contains("stepmsg")) {
            this.handleSteps(sapJobNode);
        }
        NodeList childNodes = sapJobNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node item = childNodes.item(i);
            this.setNodevaluesToMap(item, nodeAttributesMap);
        }
    }

    public Optional<String> getAttrValue(String attrName) {
        Optional<String> retVal = Optional.empty();
        if (this.nodeAttributesMap.containsKey(attrName)) {
            retVal = this.nodeAttributesMap.get(attrName);
        }
        return retVal;
    }

    private void handleSteps(Node sapJobNode) {
        HashMap<String, Optional<String>> currentStep = new HashMap<String, Optional<String>>();
        this.handleStepNode(sapJobNode, currentStep);
        for (String key : currentStep.keySet()) {
            this.stepArgs.put(this.i, key, (Optional)currentStep.get(key));
        }
        ++this.i;
    }

    private void handleStepNode(Node sapJobNode, Map<String, Optional<String>> currentStep) {
        NodeList childNodes = sapJobNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node item = childNodes.item(i);
            this.setNodevaluesToMap(item, currentStep);
        }
    }

    public StepArgs getStepArgs() {
        return this.stepArgs;
    }
}

