/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dSeries;

import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.dSeries.DSeriesJob;
import com.bmc.ctmconvert.utils.UniqueValueGenerator;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.util.List;
import java.util.Optional;

public class ZOSHandler {
    public static final String DE_AGENT = "%%DE_AGENT";
    private final DSeriesJob job;
    private final SchedEntity parent;
    private final UniqueValueGenerator uniqueNameGenerator;

    public ZOSHandler(DSeriesJob dSeriesJob, SchedEntity parent, UniqueValueGenerator uniqueNameGenerator) {
        this.job = dSeriesJob;
        this.parent = parent;
        this.uniqueNameGenerator = uniqueNameGenerator;
    }

    public void convert() {
        this.job.setMfJob();
        this.job.addAttribute("TASKTYPE", "Job");
        String member = this.getMember();
        this.job.addAttribute("MEMNAME", member);
        this.job.addAttribute("JOBNAME", member);
        this.job.addAttribute("MEMLIB", this.getMemLib());
        this.job.addAttribute("OVERLIB", this.getOverLib());
        this.job.addAttribute("TABLE_DSN", "CTM.SCHEDULE");
        this.addAffinityVariable();
        this.overrideFiledEditorValues();
        this.addMFAttributes();
    }

    private void overrideFiledEditorValues() {
        String application = this.getApplicationName();
        String subApplication = this.getSubApplication();
        this.job.addAttribute("APPLICATION", application);
        this.job.addAttribute("GROUP", subApplication);
    }

    private String getSubApplication() {
        return this.getAttributeFromJobData("app:subappl");
    }

    private void addAffinityVariable() {
        Optional<String> agent = Optional.ofNullable(this.getAttributeFromJobData("app:agent")).filter(s -> !s.isBlank());
        agent.ifPresent(affinity -> this.job.addAutoEdits(DE_AGENT, (String)affinity));
    }

    private String getOverLib() {
        Optional<XmlElement> copyJcl = Optional.ofNullable(this.job.getRootElement().getFirstChildElementByName("app:copyjcl"));
        return copyJcl.map(jcl -> jcl.getValueOfFirstChildElementByName("app:dsn")).orElse("");
    }

    private String getMemLib() {
        return this.getAttributeFromJobData("app:library");
    }

    private String getMember() {
        String member = this.getAttributeFromJobData("app:member");
        if (member.isBlank()) {
            return this.getApplicationName();
        }
        return member;
    }

    private String getApplicationName() {
        return this.job.getRootElement().getAttribute("name");
    }

    private String getAttributeFromJobData(String attributeName) {
        return this.job.getRootElement().getValueOfFirstChildElementByName(attributeName);
    }

    private void addMFAttributes() {
        String parentMfName = this.getParentMfName();
        this.job.addAttribute("FOLDER_MF_NAME", parentMfName);
        if (this.parent.getAttr("FOLDER_MF_NAME") == null) {
            this.parent.addAttribute("FOLDER_MF_NAME", parentMfName);
            this.parent.addAttribute("TABLE_DSN", "CTM.SCHEDULE");
        }
    }

    private String getParentMfName() {
        String folderName = this.parent.getJobName();
        String uniqueFolderName = this.uniqueNameGenerator.getUniqueValue("TABLE_NAME", folderName, 8);
        String validatedFolderName = FieldValidation.instance().validateAndReturnFixedValue("TABLE_NAME", uniqueFolderName, false, "Application Name", this.parent.getOriginalJobName(), (List)this.parent.getMessages());
        if (!validatedFolderName.equals(folderName)) {
            Reporter.addMessage((List)this.parent.getMessages(), (String)"WRN16017", (String)folderName, (String[])new String[]{folderName, uniqueFolderName});
        }
        return validatedFolderName;
    }
}

