/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dSeries;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DseriesGlobals {
    public static final String APP_PREFIX = "app:";
    public static final String APPL_HEADER = "appl";
    public static final String SCRIPT_LIB_TAG = "script_lib";
    public static final String SCRIPT_DEFINITION_TAG = "script_definition";
    public static final String SCRIPT_TREE_NODE_NAME = "scripts";
    public static final String SCRIPT_GENERAL_MESSAGES = "Application scripts will be stored as CTM Jobs of type Job in the Embedded script field.\nGenerated jobs will be marked as Dummy jobs (CTM Run as Dummy).";
    public static final String DEFAULT_MEMNAME = "DEFAULT_MEMNAME";
    public static final String RUN_AS_DUMMY_AUTOEDIT = "%%$BMCWAIORIGTYPE";
    public static final String APPL_CONTEXT_VAR = "%%APPL_CONTEXT";
    public static final String OTHER_VARIABLE_PREFIX = "%%OS400-";
    public static final String CON_PROFILE_DEFAULT_VALUE = "DEF_CON_PROFILE";
    public static final String[] DSERIES_JOB_TYPES = new String[]{"unix_job", "nt_job", "openvms_job", "tandem_job", "as400_job", JOB_TYPES_ENUM.SAP_JOB.toString(), JOB_TYPES_ENUM.SAPBW_JOB.toString(), "peoplesoft_job", "filemon_job", "filemon", "link", "task", JOB_TYPES_ENUM.EXT_JOB.toString(), "sppm_job", "sapeventmon_job", "om_cpu_job", "om_database_job", "om_eventlog_job", "ftp_job", "sftp_job", "om_ip_job", "om_process_job", "om_service_job", "om_textlog_job", "ejb_job", "jmss_job", "jmsp_job", "dbproc_job", "sql_job", "mssqlserver_job", "ws_job", "pojo_job", "extmon_job", "zos_job", "micro_focus_job"};
    public static final String DESREIS_FILEWATCHER_FOLDER = "FW_FOLDER";
    private static final String UNSUPPORTED_JOB_TYPE = "pojo_job|jmsp_job|ws_job|extmon_job|sapeventmon_job|ejb_job|peoplesoft_job|om_cpu_job|om_eventlog_job|mssqlserver_job|om_database_job|jmss_job|tandem_job|om_ip_job|om_service_job|om_textlog_job|sppm_job|om_process_job|openvms_job";
    public static final String[] CALENDAR_SECTIONS = new String[]{"description", "holiday", "specday"};
    public static final String ATTR_HEADER_TYPE = "Type";
    public static final String ATTR_HEADER_XML_PATH = "FilePath";
    public static final String ATTR_HEADER_XML_NAME = "Name";
    public static final String VAR_EXPR = "(?<!%)%((\\((.+?)\\)|[a-zA-Z0-9._]+))";
    public static final String DSERIES_AGENT = "agent";
    public static final String DSERIES_CLPNAME = "clpname";
    public static final String DSERIES_PARAM = "param";
    public static final String DSERIES_OTHERS = "others";
    public static final String DSERIES_JOB_NAME = "jobname";
    public static final String DSERIES_USER = "user";
    public static final String DSERIES_JOBQ = "jobq";
    public static final String DSERIES_JOBD = "jobd";
    public static final String DSERIES_LIBL = "libl";
    public static final String DSERIES_CMDNAME = "cmdname";
    public static final String DIRECTORY_APP = "Applications";
    public static final String DIRECTORY_CAL = "Calendars";
    public static final String DIRECTORY_EVT = "Events";
    public static final String DIRECTORY_VAR = "Variables";
    public static final String DIRECTORY_AGENTS = "Agents";
    public static final String DIRECTORY_RESOURCES = "Resources";
    public static final String RULE_GROUP_DSERIES_RULES = "dSeries rules";
    public static final String RULE_NAME_COND_NAMING = "CONDITION_NAME";
    public static final String RULE_VALUE_COND_NAMING_VALUE_JOBA_OK = "JOBA_OK";
    public static final String RULE_NAME_CLEAN_UP_CONDITIONS = "CLEAN_UP_CONDITIONS";
    public static final String RULE_NAME_FIRST_DAY_OF_WEEK = "FIRST_DAY_OF_WEEK";
    public static final String RULE_FILTER_KEY_APPLICATION_NAME = "Application Name";
    public static final String INF_SCHED_STMT_TO_RBC = "INF16002";
    public static final String INF_APP_SCRIPT_CONVERTED = "INF16003";
    public static final String INF_UNSUPPORTED_MON_STATE_CONVERTED = "INF16004";
    public static final String INF_UNSUPPORTED_MON_STATE = "INF16006";
    public static final String WRN_UNEXPECTED_ELEMENT = "WRN16001";
    public static final String WRN_MODIFIER_IGNORED = "WRN16002";
    public static final String WRN_TIME_FORMAT = "WRN16003";
    public static final String WRN_FW_NOT_CONVERTED = "WRN16004";
    public static final String WRN_UNRESOLVED_VAR = "WRN16005";
    public static final String WRN_IF_STATEMENT_VALUE = "WRN16009";
    public static final String WRN_SDATE_CAL_NOT_COVERTED = "WRN16012";
    public static final String WRN_UNSUPPORTED_EXEC_MONITOR_STATE = "WRN16013";
    public static final String WRN_IGNORED_SCHED_PHRASE = "WRN16014";
    public static final String WRN_MIN_OR_MAX_TIME_GREATER_THAN_999 = "WRN16015";
    public static final String WRN_MIN_OR_MAX_TIME_FROM_VARIABLE = "WRN16016";
    public static final String WRN_MF_FOLDER_NAME_SHORTENED = "WRN16017";
    public static final String WRN_RESOURCE_IS_GREATER_THEN_SUPPORTTED = "WRN16018";
    public static final String WRN_JOB_ANCESTOR_WAIT_NOT_CONVERTED = "WRN16019";
    public static final String WRN_FOLDER_ANCESTOR_WAIT_NOT_CONVERTED = "WRN16020";
    public static final String WRN_JOB_ADD_ANCESTOR_WAIT_CONDITION_IN_FIRST_RUN = "WRN16021";
    public static final String WRN_FOLDER_ADD_ANCESTOR_WAIT_CONDITION_IN_FIRST_RUN = "WRN16022";
    public static final String WRN_UNCONVERTABLE_SCHEDULING_STATMENT = "WRN16023";
    public static final String WRN_RETRY_COUNT_GREATER_THEN_99 = "WRN16024";
    public static final String WRN_IGNORED_ELEMENT = "WRN16025";
    public static final String WRN_ADD_IN_ACTIVE_CONDITIONS = "WRN16026";
    public static final String WRN_JAVASCRIPT_ONLOAD_AT_EVENT_TRIGGER_TIME = "WRN16027";
    public static final String WRN_JAVASCRIPT_ONENTER_AT_JOB_TRIGGER_TIME = "WRN16028";
    public static final String ERR_UNSUPPORTED_JOB_TYPE = "ERR16001";
    public static final String ERR_EVENT_WITHOUT_APPL = "ERR16002";
    public static final String SAP_ABAPNAME = "abapname";
    public static final String SAP_VARIANT = "variant";
    public static final String SAP_USER = "stepuser";
    public static final String SAP_LANGUAGE = "abaplanguage";
    public static final String SAP_PRINTDEST = "printdest";
    public static final String SAP_PRINTPW = "printpw";
    public static final String SAP_PRINTCOPIES = "printcopies";
    public static final String SAP_PRINTSPOOLNAME = "printspoolname";
    public static final String SAP_PRINTTEXT = "printtext";

    public static JOB_TYPES_ENUM getJobTypeFromString(String jobTypeString) {
        String fixJobType = DseriesGlobals.fixJobType(jobTypeString);
        return JOB_TYPES_ENUM.stream().filter(jobType -> fixJobType.matches(jobType.getRegex())).findFirst().orElse(JOB_TYPES_ENUM.UNKNOWN);
    }

    public static boolean isItJobType(String origJobType) {
        origJobType = DseriesGlobals.fixJobType(origJobType);
        return Arrays.asList(DSERIES_JOB_TYPES).contains(origJobType);
    }

    public static boolean isJobTypeSupported(String origJobType) {
        JOB_TYPES_ENUM jobTypeEnum = DseriesGlobals.getJobTypeFromString(origJobType = DseriesGlobals.fixJobType(origJobType));
        return !jobTypeEnum.equals((Object)JOB_TYPES_ENUM.UNKNOWN) && !jobTypeEnum.equals((Object)JOB_TYPES_ENUM.UNSUPPORTED);
    }

    private static String fixJobType(String origJobType) {
        if (origJobType.startsWith(APP_PREFIX)) {
            return origJobType.substring(4);
        }
        return origJobType;
    }

    public static boolean isItUnSupportedJob(String element) {
        return DseriesGlobals.isItJobType(element) && !DseriesGlobals.isJobTypeSupported(element);
    }

    public static boolean elemntNameMatch(Node node, String elementName) {
        return node != null && node.getNodeType() == 1 && node.getNodeName().toLowerCase().matches("\\s*([a-z]{3,4}:\\s*)?" + elementName.toLowerCase() + "\\s*");
    }

    public static Node findChildNodeDFS(Node node, String elemName, String attrName, String attrValue) {
        boolean isMatch = false;
        if (DseriesGlobals.elemntNameMatch(node, elemName)) {
            if (attrName != null && node.hasAttributes()) {
                NamedNodeMap nodeAttrs = node.getAttributes();
                Node attr = nodeAttrs.getNamedItem(attrName);
                if (attr != null) {
                    isMatch = attrValue == null || attrValue.equalsIgnoreCase(attr.getNodeValue());
                }
            } else {
                isMatch = attrName == null;
            }
        }
        Node toRet = null;
        if (isMatch) {
            toRet = node;
        }
        for (Node childNode = node.getFirstChild(); childNode != null && toRet == null && (toRet = DseriesGlobals.findChildNodeDFS(childNode, elemName, attrName, attrValue)) == null; childNode = childNode.getNextSibling()) {
        }
        return toRet;
    }

    public static Optional<Node> findChildNodeDFS(Node node, String elemName) {
        return Optional.ofNullable(DseriesGlobals.findChildNodeDFS(node, elemName, null, null));
    }

    public static List<String> getChildValues(Node parent, String childName) {
        ArrayList<String> toRet = new ArrayList<String>();
        if (parent != null) {
            for (Node suspect = parent.getFirstChild(); suspect != null; suspect = suspect.getNextSibling()) {
                String value;
                if (suspect.getNodeType() != 1 || !DseriesGlobals.elemntNameMatch(suspect, childName) || (value = suspect.getTextContent()) == null || value.isEmpty()) continue;
                toRet.add(value);
            }
        }
        return toRet;
    }

    public static enum JOB_TYPES_ENUM {
        OS("unix_job|nt_job"),
        FILE("filemon_job|filemon"),
        LINK("link"),
        TASK("task"),
        EXT_JOB("ext_job"),
        EXTMON_JOB("extmon_job"),
        SAP_JOB("sap_job"),
        SAPBW_JOB("bwpc_job"),
        AS400("as400_job"),
        FTP("ftp_job|sftp_job"),
        SQL_JOB("sql_job"),
        DBPROC_JOB("dbproc_job"),
        ZOS("zos_job"),
        PEOPLE_SOFT("peoplesoft_job"),
        MICRO_FOCUS_JOB("micro_focus_job"),
        UNSUPPORTED("pojo_job|jmsp_job|ws_job|extmon_job|sapeventmon_job|ejb_job|peoplesoft_job|om_cpu_job|om_eventlog_job|mssqlserver_job|om_database_job|jmss_job|tandem_job|om_ip_job|om_service_job|om_textlog_job|sppm_job|om_process_job|openvms_job"),
        UNKNOWN("UNKNOWN TYPE");

        private final String regex;

        private JOB_TYPES_ENUM(String regex) {
            this.regex = regex;
        }

        public String getRegex() {
            return this.regex;
        }

        public String toString() {
            if (this.equals((Object)UNSUPPORTED)) {
                return "unsupported";
            }
            return this.regex.split("\\|")[0];
        }

        public static Stream<JOB_TYPES_ENUM> stream() {
            return Stream.of(JOB_TYPES_ENUM.values());
        }
    }

    public static enum XML_TYPE {
        APP,
        CAL,
        EVT,
        VAR,
        RESOURCE;

    }
}

