/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dSeries;

import com.bmc.ctmconvert.base.BaseBrowseTextField;
import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.BaseContentPanel;
import com.bmc.ctmconvert.base.BaseField;
import com.bmc.ctmconvert.base.BaseFieldValidator;
import com.bmc.ctmconvert.base.BaseFooterPanel;
import com.bmc.ctmconvert.base.BaseProgressBar;
import com.bmc.ctmconvert.base.BaseSection;
import com.bmc.ctmconvert.base.BaseTitlePanel;
import com.bmc.ctmconvert.base.DataImportVendor;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import java.awt.Component;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DataImportDSeries
extends DataImportVendor {
    private final BaseBrowseTextField applicationDirectory;
    private final BaseBrowseTextField calendarDirectory;
    private final BaseBrowseTextField eventDirectory;
    private final BaseBrowseTextField resourceDirectory;
    private BaseBrowseTextField globalVarDirectory;

    public DataImportDSeries() {
        this.importPanel = new BaseContentPanel(new BaseTitlePanel(TextManager.instance().get("DATA_IMPORT_TITLE_DSERIES")), new BaseFooterPanel(""));
        BaseSection section = new BaseSection(TextManager.instance().get("SECTION_IMPORT_DATA"));
        this.eventDirectory = new BaseBrowseTextField(new String[]{TextManager.instance().get("FILE_CHOOSER_TITLE_DIRECTORY")}, new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.DIRECTORY_PATH));
        section.addField(new BaseField((BaseComponent)this.eventDirectory, TextManager.instance().get("DATA_IMPORT_FIELD_DSERIES_EVT_DIR"), true, TextManager.instance().get("DSERIES_EVENT_DESCRIPTION")));
        this.applicationDirectory = new BaseBrowseTextField(new String[]{TextManager.instance().get("FILE_CHOOSER_TITLE_DIRECTORY")}, new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.DIRECTORY_PATH));
        section.addField(new BaseField((BaseComponent)this.applicationDirectory, TextManager.instance().get("DATA_IMPORT_FIELD_DSERIES_APP_DIR"), true, TextManager.instance().get("DSERIES_APPLICATION_DESCRIPTION")));
        this.calendarDirectory = new BaseBrowseTextField(new String[]{TextManager.instance().get("FILE_CHOOSER_TITLE_DIRECTORY")}, new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.DIRECTORY_PATH_OR_EMPTY));
        section.addField(new BaseField((BaseComponent)this.calendarDirectory, TextManager.instance().get("DATA_IMPORT_FIELD_DSERIES_CAL_DIR"), false, TextManager.instance().get("DSERIES_CALENDAR_DESCRIPTION")));
        this.globalVarDirectory = new BaseBrowseTextField(new String[]{TextManager.instance().get("FILE_CHOOSER_TITLE_DIRECTORY")}, new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.DIRECTORY_PATH_OR_EMPTY));
        section.addField(new BaseField((BaseComponent)this.globalVarDirectory, TextManager.instance().get("DATA_IMPORT_FIELD_DSERIES_GLOB_VAR_DIR"), false, TextManager.instance().get("DSERIES_GLOBAL_VARIABLE_DESCRIPTION")));
        this.resourceDirectory = new BaseBrowseTextField(new String[]{TextManager.instance().get("FILE_CHOOSER_TITLE_DIRECTORY")}, new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.DIRECTORY_PATH_OR_EMPTY));
        section.addField(new BaseField((BaseComponent)this.resourceDirectory, TextManager.instance().get("DATA_IMPORT_FIELD_DSERIES_GLOB_RESOURCE_DIR"), false, TextManager.instance().get("DSERIES_RESOURCE_DESCRIPTION")));
        this.importPanel.addSection(section);
        this.importPanel.buildContentPanel();
    }

    public FlowGlobals.COMPLETION_MODE performDataImport(String destinationFolderPath, BaseProgressBar progressBar) {
        String applicationDir = this.applicationDirectory.getText();
        String calendarDir = this.calendarDirectory.getText();
        String eventDir = this.eventDirectory.getText();
        String varsDir = this.globalVarDirectory.getText();
        String resourceDir = this.resourceDirectory.getText();
        Long totalFiles = Stream.of(applicationDir, calendarDir, eventDir, varsDir, resourceDir).filter(s -> !s.isEmpty()).map(x$0 -> Path.of(x$0, new String[0])).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).map(p -> p.toFile().length()).reduce(0L, Long::sum);
        Double pctIncrement = 100.0 / (double)totalFiles.longValue();
        return DataImportDSeries.staticDataImport(destinationFolderPath, applicationDir, calendarDir, eventDir, varsDir, resourceDir, pctIncrement, progressBar);
    }

    static FlowGlobals.COMPLETION_MODE staticDataImport(String destinationFolderPath, String applicationDir, String calendarDir, String eventDir, String varsDir, String resourceDir, Double pctIncrement, BaseProgressBar progressBar) {
        try {
            DataImportDSeries.copyInputXMLs("APP", destinationFolderPath, applicationDir, pctIncrement, progressBar);
            if (!calendarDir.isEmpty()) {
                DataImportDSeries.copyInputXMLs("CAL", destinationFolderPath, calendarDir, pctIncrement, progressBar);
            }
            if (!eventDir.isEmpty()) {
                DataImportDSeries.copyInputXMLs("EVT", destinationFolderPath, eventDir, pctIncrement, progressBar);
            }
            if (!varsDir.isEmpty()) {
                DataImportDSeries.copyInputXMLs("VAR", destinationFolderPath, varsDir, pctIncrement, progressBar);
            }
            if (!resourceDir.isEmpty()) {
                DataImportDSeries.copyInputXMLs("RES", destinationFolderPath, resourceDir, pctIncrement, progressBar);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return FlowGlobals.COMPLETION_MODE.FAILURE;
        }
        return FlowGlobals.COMPLETION_MODE.SUCCESS;
    }

    private static void copyInputXMLs(String inputType, String destinationFolderPath, String sourceDir, Double pctIncrement, BaseProgressBar progressBar) throws IOException {
        File targetDir;
        File source = new File(sourceDir);
        Double currProg = null;
        if (progressBar != null) {
            currProg = progressBar.getProgressValue();
        }
        if (!(targetDir = inputType.equals("APP") ? new File(destinationFolderPath + Globs.DIRSEP + "Applications") : (inputType.equals("CAL") ? new File(destinationFolderPath + Globs.DIRSEP + "Calendars") : (inputType.equals("EVT") ? new File(destinationFolderPath + Globs.DIRSEP + "Events") : (inputType.equals("RES") ? new File(destinationFolderPath + Globs.DIRSEP + "Resources") : new File(destinationFolderPath + Globs.DIRSEP + "Variables"))))).exists()) {
            targetDir.mkdirs();
        }
        File[] inputXMLs = source.listFiles();
        for (int i = 0; i < inputXMLs.length; ++i) {
            String targetPath = targetDir.getAbsolutePath() + "/" + inputXMLs[i].getName();
            if (!targetPath.toLowerCase().endsWith(".xml")) {
                targetPath = targetPath + ".xml";
            }
            if (!inputXMLs[i].isFile() || !DataImportDSeries.isValidInXML(inputXMLs[i], inputType)) continue;
            GlobalFunctions.copy((File)inputXMLs[i], (File)new File(targetPath));
            if (progressBar == null) continue;
            progressBar.setLabel("Copying file: " + inputXMLs[i].getName());
            currProg = currProg + pctIncrement;
            progressBar.setProgressValue(currProg.intValue());
        }
    }

    private static boolean isValidInXML(File inputXML, String inputType) {
        boolean toRet = false;
        try {
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            FileReader fr = new FileReader(inputXML);
            Document doc = db.parse(new InputSource(fr));
            NodeList children = doc.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                String currChildName = children.item(i).getNodeName();
                if (!(inputType.equals("APP") && currChildName.toLowerCase().matches("(app\\s*:\\s*)?appl") || inputType.equals("CAL") && currChildName.toLowerCase().matches("(cal\\s*:\\s*)?calendar") || inputType.equals("EVT") && currChildName.toLowerCase().matches("(even\\s*:\\s*)?eventenum") || inputType.equals("VAR") && currChildName.toLowerCase().matches("context")) && (!inputType.equals("RES") || !currChildName.toLowerCase(Locale.ROOT).matches("(res\\s*:\\s*)?resourcedefinition"))) continue;
                toRet = true;
                break;
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            ConversionLogger.getLogger().info("Failed to load file: " + inputXML.getAbsolutePath() + "\n" + e.getMessage());
            toRet = false;
        }
        return toRet;
    }

    public String getHelpTitle() {
        return "LOAD_DATA_DSERIES";
    }

    public String getFieldsData() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.applicationDirectory.getComponent().getName()).append('=').append(this.applicationDirectory.getText()).append('\n');
        stringBuilder.append(this.calendarDirectory.getComponent().getName()).append('=').append(this.calendarDirectory.getText()).append('\n');
        return stringBuilder.toString();
    }

    public BaseContentPanel getNextPanel() {
        return this.importPanel;
    }

    public Component getDefaultFocusedComponent() {
        return this.eventDirectory.getComponent();
    }
}

