/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dSeries;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.calendars.CtmCalendar;
import com.bmc.ctmconvert.common.calendars.DefCalFile;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.dSeries.DseriesGlobals;
import com.bmc.ctmconvert.dSeries.RbcGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class CalendarConvertor {
    private static HashSet<String> calendarNames = new HashSet();
    private LinkedHashMap<String, Set<String>> unconverted = null;
    private final DefCalFile defCalFile;
    private DocumentBuilder db;

    public CalendarConvertor(DefCalFile defCalFile) {
        try {
            this.defCalFile = defCalFile;
            this.unconverted = new LinkedHashMap();
            this.db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
            ConversionLogger.getLogger().info(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public void convertCalendars(String calXmlFileName, InputStream calInputStream) {
        try {
            Document calDoc = this.db.parse(calInputStream);
            List<CtmCalendar> tmpCalendarList = this.xmltoRegularCalendar(calDoc);
            for (CtmCalendar tmpCalendar : tmpCalendarList) {
                calendarNames.add(tmpCalendar.getName());
                this.defCalFile.write(tmpCalendar, false);
                this.defCalFile.write(tmpCalendar, true);
            }
        }
        catch (IOException | SAXException e) {
            ConversionLogger.getLogger().info("Failed to load file: " + calXmlFileName + "\n" + e.getMessage());
        }
    }

    private void testCalendar(Document calDoc, String baseCalendarName) {
        Node specDayNode = DseriesGlobals.findChildNodeDFS(calDoc, "specday", null, null);
        baseCalendarName = baseCalendarName.toUpperCase();
        if (specDayNode != null) {
            if (!this.unconverted.containsKey(baseCalendarName)) {
                this.unconverted.put(baseCalendarName, new HashSet());
            }
            for (Node dateNode = specDayNode.getFirstChild(); dateNode != null; dateNode = dateNode.getNextSibling()) {
                Node nameNode;
                if (dateNode.getNodeType() != 1 || (nameNode = DseriesGlobals.findChildNodeDFS(dateNode, "name", null, null)) == null) continue;
                this.unconverted.get(baseCalendarName).add(nameNode.getTextContent().toUpperCase());
            }
        }
    }

    public static boolean isCalendarConverted(String calendarName) {
        return calendarNames.contains(calendarName);
    }

    private List<CtmCalendar> xmltoRegularCalendar(Document calDoc) {
        ArrayList<CtmCalendar> returnCals = new ArrayList<CtmCalendar>();
        CtmCalendar workDays = null;
        CtmCalendar weekDays = null;
        String[] weekDayStrings = GlobalFunctions.getWeekDaysArray((String)"SUN");
        boolean[] weekDayFlags = new boolean[7];
        Arrays.fill(weekDayFlags, false);
        String baseCalendarName = DseriesGlobals.findChildNodeDFS(calDoc, "name", null, null).getTextContent();
        workDays = new CtmCalendar((baseCalendarName + ".WORKDAYS").toUpperCase(), Params.instance().getDatacenterName());
        returnCals.add(workDays);
        weekDays = new CtmCalendar((baseCalendarName + ".WEEKDAYS").toUpperCase(), Params.instance().getDatacenterName());
        returnCals.add(weekDays);
        this.testCalendar(calDoc, baseCalendarName);
        block0: for (Node weekdayNode = DseriesGlobals.findChildNodeDFS(calDoc, "workday", null, null); weekdayNode != null; weekdayNode = weekdayNode.getNextSibling()) {
            String wDay = weekdayNode.getTextContent();
            for (int i = 0; i < weekDayStrings.length; ++i) {
                if (!wDay.equalsIgnoreCase(weekDayStrings[i])) continue;
                weekDayFlags[i] = true;
                continue block0;
            }
        }
        Calendar current = Calendar.getInstance();
        current.set(5, 1);
        current.set(2, 0);
        current.add(1, -2);
        int stopYear = current.get(1) + 5;
        while (current.get(1) < stopYear) {
            if (weekDayFlags[current.get(7) - 1]) {
                workDays.addDay(current.get(1), current.get(2) + 1, current.get(5));
                weekDays.addDay(current.get(1), current.get(2) + 1, current.get(5));
            }
            current.add(5, 1);
        }
        Node holDateNode = DseriesGlobals.findChildNodeDFS(calDoc, "holiday", null, null);
        holDateNode = DseriesGlobals.findChildNodeDFS(holDateNode, "date", null, null);
        CtmCalendar holidayCalendar = null;
        while (holDateNode != null) {
            if (holidayCalendar == null) {
                holidayCalendar = new CtmCalendar((baseCalendarName + ".HOLIDAYS").toUpperCase(), Params.instance().getDatacenterName());
                returnCals.add(holidayCalendar);
            }
            String holidayName = DseriesGlobals.findChildNodeDFS(holDateNode, "name", null, null).getTextContent();
            CtmCalendar specificHolidayCalendar = new CtmCalendar((baseCalendarName + "." + holidayName).toUpperCase(), Params.instance().getDatacenterName());
            returnCals.add(specificHolidayCalendar);
            Node pernode = DseriesGlobals.findChildNodeDFS(holDateNode, "period", null, null);
            while (pernode != null) {
                String startDateStr = DseriesGlobals.findChildNodeDFS(pernode, "starttime", null, null).getTextContent();
                Calendar currDateCal = Calendar.getInstance();
                currDateCal.clear();
                currDateCal.set(Integer.valueOf(startDateStr.substring(0, 4)), Integer.valueOf(startDateStr.substring(4, 6)) - 1, Integer.valueOf(startDateStr.substring(6, 8)));
                String endDateStr = DseriesGlobals.findChildNodeDFS(pernode, "endtime", null, null).getTextContent();
                Calendar endDateCal = Calendar.getInstance();
                endDateCal.clear();
                endDateCal.set(Integer.valueOf(endDateStr.substring(0, 4)), Integer.valueOf(endDateStr.substring(4, 6)) - 1, Integer.valueOf(endDateStr.substring(6, 8)));
                endDateCal.add(5, 1);
                while (currDateCal.before(endDateCal)) {
                    workDays.removeDay(currDateCal.get(1), currDateCal.get(2) + 1, currDateCal.get(5));
                    holidayCalendar.addDay(currDateCal.get(1), currDateCal.get(2) + 1, currDateCal.get(5));
                    specificHolidayCalendar.addDay(currDateCal.get(1), currDateCal.get(2) + 1, currDateCal.get(5));
                    currDateCal.add(5, 1);
                }
                while ((pernode = pernode.getNextSibling()) != null && pernode.getNodeType() != 1) {
                }
            }
            while ((holDateNode = holDateNode.getNextSibling()) != null && holDateNode.getNodeType() != 1) {
            }
        }
        return returnCals;
    }

    public LinkedHashMap<String, Set<String>> getUnconverted() {
        return this.unconverted;
    }

    public static CtmCalendar getAllDaysCalendar() {
        CtmCalendar toRet = new CtmCalendar("ALLDAYS".toUpperCase(), Params.instance().getDatacenterName());
        Calendar current = Calendar.getInstance();
        current.set(5, 1);
        current.set(2, 0);
        current.add(1, -2);
        int stopYear = current.get(1) + 5;
        while (current.get(1) < stopYear) {
            toRet.addDay(current.get(1), current.get(2) + 1, current.get(5));
            current.add(5, 1);
        }
        return toRet;
    }

    public static Properties getEveryDayCalendar() {
        return RbcGenerator.getEveryDayRBC();
    }

    public DefCalFile getCalendarWriter() {
        return this.defCalFile;
    }

    public static enum TARGET_CAL_TYPE {
        REGULAR,
        PERIODIC,
        S_DATE,
        MIXED;

    }
}

