/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dSeries;

import com.bmc.ctmconvert.dSeries.GlobalVariables;
import com.bmc.ctmconvert.dSeries.ResolvedString;
import java.util.HashMap;
import java.util.Map;

public class ApplResolver {
    private String varName;
    private Map<String, String> systemVariablesToControlM;
    private String resolvedVal;
    private ResolvedString toResolve;
    private GlobalVariables globalVariables;

    public ApplResolver(ResolvedString toResolve, String varName, GlobalVariables globalVariables) {
        this.toResolve = toResolve;
        this.varName = varName;
        this.globalVariables = globalVariables;
        String context = this.extractContext();
        toResolve.addAutoedit("%%APPL_CONTEXT".substring(2), context);
        this.initSystemVariablesMap();
    }

    public String getResolvedVariableValue() {
        this.resolvedVal = this.resolveSystemVariables(this.varName);
        if (this.resolvedVal != null) {
            return this.resolvedVal;
        }
        Object retVal = null;
        String context = this.extractContext();
        String varNameforValue = this.varName;
        boolean hasApplInName = this.varName.startsWith("APPL_");
        if (hasApplInName) {
            varNameforValue = this.varName.substring("APPL_".length());
        }
        if ((retVal = this.globalVariables.getVarValue(context, varNameforValue)) == null) {
            retVal = this.globalVariables.getVarValue(varNameforValue);
        }
        if (retVal == null) {
            retVal = "%%" + varNameforValue;
        }
        return retVal;
    }

    public String getVariableValueUsingContext() {
        this.resolvedVal = this.resolveSystemVariables(this.varName);
        if (this.resolvedVal == null) {
            boolean hasApplInName = this.varName.startsWith("APPL_");
            if (hasApplInName) {
                this.varName = this.varName.substring("APPL_".length());
            }
            this.resolvedVal = "%%\\\\%%APPL_CONTEXT\\" + this.varName;
        }
        return this.resolvedVal;
    }

    private String extractContext() {
        String applName;
        String context = applName = this.toResolve.getApplicationName();
        int indexOfUnder = applName.indexOf("_");
        if (indexOfUnder > -1) {
            context = applName.substring(0, indexOfUnder);
        }
        return context;
    }

    private void initSystemVariablesMap() {
        this.systemVariablesToControlM = new HashMap<String, String>();
        this.systemVariablesToControlM.put("APPL__name", "%%APPLIC");
        this.systemVariablesToControlM.put("APPL_group", "%%APPL_CONTEXT");
        this.systemVariablesToControlM.put("APPL__gen", "%%ORDERID");
        this.systemVariablesToControlM.put("WOB__name", "%%JOBNAME");
    }

    private String resolveSystemVariables(String varName) {
        return this.systemVariablesToControlM.get(varName);
    }
}

