/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.base.BasePanel;
import com.bmc.ctmconvert.base.BaseProgressBar;
import com.bmc.ctmconvert.base.CliImporter;
import com.bmc.ctmconvert.base.DataImportVendor;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.SourceDefinitions;
import com.bmc.ctmconvert.common.calendars.DefCalFile;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.common.rbc.RBC;
import com.bmc.ctmconvert.dSeries.CalendarConvertor;
import com.bmc.ctmconvert.dSeries.CliImporterdSeries;
import com.bmc.ctmconvert.dSeries.DataImportDSeries;
import com.bmc.ctmconvert.dSeries.DataReader;
import com.bmc.ctmconvert.dSeries.DseriesData;
import com.bmc.ctmconvert.dSeries.DseriesDefs;
import com.bmc.ctmconvert.dSeries.GlobalVariables;
import com.bmc.ctmconvert.dSeries.assessment.DSeriesAssessmentReport;
import com.bmc.ctmconvert.dSeries.assessment.resources.ResourceDataExtractor;
import com.bmc.ctmconvert.interfaces.VendorData;
import com.bmc.ctmconvert.rules.FirstDayOfTheWeekRule;
import com.bmc.ctmconvert.rules.RuleManager;
import com.bmc.ctmconvert.rules.RulesDataSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;

public class AppData
implements VendorData {
    private static final String D_SERIES = "dSeries";

    public String getName() {
        return D_SERIES;
    }

    public String getDisplayName() {
        return "Broadcom Workload Automation DE\u00ae";
    }

    public VendorData.VendorType getVendorType() {
        return VendorData.VendorType.Schedulers;
    }

    public DataImportVendor getDataImport() {
        return new DataImportDSeries();
    }

    public BasePanel getAssessmentReport(String path) {
        return new DSeriesAssessmentReport(path, Globs.ASSESSMENT_REPORT_DESCRIPTION_XML, null);
    }

    public CliImporter getCLIImporter() {
        return new CliImporterdSeries();
    }

    public SourceDefinitions getSourceDefinition(BaseProgressBar progressBar) {
        CalendarConvertor calendarConvertor;
        Path dataDir = Paths.get(Params.instance().getDatasourcePath(), new String[0]);
        DseriesData data = new DseriesData();
        DataReader reader = new DataReader(dataDir, data);
        reader.readAppFiles();
        reader.readVarFiles();
        reader.readEvtFiles();
        reader.readCalFiles();
        reader.readResourceFiles();
        try {
            calendarConvertor = new CalendarConvertor(DefCalFile.createDefCalFile());
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
            ConversionLogger.getLogger().info(e.getMessage());
            throw new RuntimeException(e);
        }
        GlobalVariables globalVariables = new GlobalVariables(data);
        ResourceDataExtractor resources = new ResourceDataExtractor(data.getResourceXml());
        RulesDataSet rules = RuleManager.instance().getCurrentRules();
        return new DseriesDefs(data, calendarConvertor, globalVariables, rules, resources.getResources());
    }

    public InputStream getRulesResourceFile() {
        return AppData.class.getResourceAsStream("/rules.xml");
    }

    public boolean isZOS() {
        return false;
    }

    public static RulesDataSet getRules() {
        return new RuleManager(D_SERIES, "9", (VendorData)new AppData()).getCurrentRules();
    }

    public RBC.WEEKDAYS getFirstDayOfTheWeek() {
        return FirstDayOfTheWeekRule.getFirstDayOfTheWeek((String)"dSeries rules", (String)"FIRST_DAY_OF_WEEK");
    }
}

