/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.GenerateScripts;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.services.ConversionEntitiesService;
import com.bmc.ctmconvert.services.settings.SettingsBooleanKeys;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

class GlobalVariableScriptGenerator {
    public static final int SKIP_POOL_PREFIX = 2;
    private Map<Object, Object> globalVariables;
    private FileSystem fileSystem;

    public GlobalVariableScriptGenerator(Map<Object, Object> globalVariables) {
        this(FileSystems.getDefault(), globalVariables);
    }

    public GlobalVariableScriptGenerator(FileSystem fileSystem, Map<Object, Object> globalVariables) {
        this.fileSystem = fileSystem;
        this.globalVariables = globalVariables;
    }

    public boolean generateScripts() {
        if (this.globalVariables == null || this.globalVariables.isEmpty()) {
            return false;
        }
        Path path = this.getPostConversionScriptsPath();
        GenerateScripts.createFolder(path);
        try {
            if (SettingsBooleanKeys.isSaas()) {
                this.generateSaaSScripts(path);
            } else {
                this.generateOnPremScripts(path);
            }
        }
        catch (IOException e) {
            ConversionLogger.getLogger().info(e.getMessage());
            ExceptionHandler.writeToExceptionFile(e);
        }
        return true;
    }

    private void generateSaaSScripts(Path path) throws IOException {
        Path variablesJSONFile = this.fileSystem.getPath(String.valueOf(path) + Globs.DIRSEP + "Variables_Definition_File.json", new String[0]);
        Path fileWindows = this.fileSystem.getPath(String.valueOf(path) + Globs.DIRSEP + "Pool_Variables_Script_Windows.bat", new String[0]);
        Path fileUnix = this.fileSystem.getPath(String.valueOf(path) + Globs.DIRSEP + "Pool_Variables_Script_Unix.sh", new String[0]);
        try (BufferedWriter outputWindows = Files.newBufferedWriter(fileWindows, new OpenOption[0]);
             BufferedWriter outputUnix = Files.newBufferedWriter(fileUnix, new OpenOption[0]);){
            JSONObject mainJsonObject = new JSONObject();
            JSONArray variablesJsonArray = new JSONArray();
            for (Map.Entry<Object, Object> entry : this.globalVariables.entrySet()) {
                JSONObject variableJson = new JSONObject();
                String variableName = this.UpdateVariableNameFormat(entry.getKey().toString());
                String value = entry.getValue().toString();
                variableJson.put(variableName, (Object)value);
                variablesJsonArray.put((Object)variableJson);
            }
            mainJsonObject.put("variables", (Object)variablesJsonArray);
            Files.write(variablesJSONFile, mainJsonObject.toString().getBytes("utf-8"), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            this.writeUnixHeader(outputUnix);
            this.writeWindowsHeader(outputWindows);
            outputWindows.write("ctm run variables::set \"<server>\" -f \"" + String.valueOf(variablesJSONFile) + "\"");
            outputUnix.write("ctm run variables::set '<server>' -f '" + String.valueOf(variablesJSONFile) + "'");
        }
    }

    private String UpdateVariableNameFormat(String key) {
        return key.startsWith("%%") ? key : "%%" + key;
    }

    private void generateOnPremScripts(Path path) throws IOException {
        Path filePerl = this.fileSystem.getPath(String.valueOf(path) + Globs.DIRSEP + "Autoedit_Members_Script_Perl.pl", new String[0]);
        Path fileWindows = this.fileSystem.getPath(String.valueOf(path) + Globs.DIRSEP + "Autoedit_Members_Script_Windows.bat", new String[0]);
        Path fileUnix = this.fileSystem.getPath(String.valueOf(path) + Globs.DIRSEP + "Autoedit_Members_Script_Unix.sh", new String[0]);
        Path filePoolUnix = this.fileSystem.getPath(String.valueOf(path) + Globs.DIRSEP + "pool_variables_unix.sh", new String[0]);
        Path filePoolWindows = this.fileSystem.getPath(String.valueOf(path) + Globs.DIRSEP + "pool_variables_windows.bat", new String[0]);
        try (BufferedWriter outputPerl = Files.newBufferedWriter(filePerl, new OpenOption[0]);
             BufferedWriter outputWindows = Files.newBufferedWriter(fileWindows, new OpenOption[0]);
             BufferedWriter outputUnix = Files.newBufferedWriter(fileUnix, new OpenOption[0]);
             BufferedWriter outputPoolUnix = Files.newBufferedWriter(filePoolUnix, new OpenOption[0]);
             BufferedWriter outputPoolWindows = Files.newBufferedWriter(filePoolWindows, new OpenOption[0]);){
            outputPerl.write("#!/bin/perl\n");
            outputPerl.write("use strict;\n");
            outputPerl.write("use warnings;\n\n");
            this.writeUnixHeader(outputUnix);
            this.writeUnixHeader(outputPoolUnix);
            this.writeWindowsHeader(outputWindows);
            this.writeWindowsHeader(outputPoolWindows);
            for (Map.Entry<Object, Object> entry : this.globalVariables.entrySet()) {
                String variableName = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (GlobalFunctions.isPoolVariable(variableName)) {
                    this.writeVariableToPoolScripts(outputPoolUnix, outputPoolWindows, variableName, value);
                    continue;
                }
                outputPerl.write("\tsystem( \"ctmvar\", \"-action\", \"set\", \"-var\", '%%%%\\" + variableName + "', \"-varexpr\", \"" + this.replaceNewlines(this.escapeQuotes(value, "\"")) + "\");\n");
                outputWindows.write("ctmvar -action set -var \"%%%%\\" + variableName + "\" -varexpr \"" + this.replaceNewlines(this.escapeQuotes(value, "\"")) + "\"\n");
                outputUnix.write("ctmvar -action set -var '%%%%\\" + variableName + "' -varexpr '" + this.replaceNewlines(this.escapeQuotesUnix(value)) + "'\n");
            }
        }
    }

    private String replaceNewlines(String text) {
        return text.replaceAll("\\r?\\n", " ");
    }

    public String escapeQuotes(String value, String quote) {
        return value.replace(quote, "\\" + quote);
    }

    private String escapeQuotesUnix(String value) {
        return value.replace("'", "'\\''");
    }

    public void writeVariableToPoolScripts(BufferedWriter outputPoolUnix, BufferedWriter outputPoolWindows, String variableName, String value) throws IOException {
        String poolName = this.extractPoolName(variableName);
        String poolVariableName = this.extractVariableName(variableName);
        outputPoolUnix.write("ctmvar -POOL SETVAR -POOLNAME '" + poolName + "' -VAR '" + poolVariableName + "' -VALUE '" + this.replaceNewlines(this.escapeQuotesUnix(value)) + "'\n");
        outputPoolWindows.write("ctmvar -POOL SETVAR -POOLNAME \"" + poolName + "\" -VAR \"" + poolVariableName + "\" -VALUE \"" + this.replaceNewlines(this.escapeQuotes(value, "\"")) + "\"\n");
    }

    public String extractVariableName(String variableName) {
        return variableName.substring(this.lastSlash(variableName) + 1);
    }

    private String extractPoolName(String variableName) {
        return variableName.substring(2, this.lastSlash(variableName));
    }

    private int lastSlash(String variableName) {
        return variableName.lastIndexOf("\\");
    }

    public void writeWindowsHeader(BufferedWriter outputWindows) throws IOException {
        outputWindows.write("@echo off\n\n");
    }

    public void writeUnixHeader(BufferedWriter outputUnix) throws IOException {
        outputUnix.write("#!/bin/sh\n\n");
    }

    public Path getPostConversionScriptsPath() {
        return this.fileSystem.getPath(ConversionEntitiesService.getCurrentConversionPostDirectory(), new String[0]);
    }
}

