/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.exceptions.ConvertorException;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.io.FileUtils;
import com.bmc.ctmconvert.rules.RuleManager;
import com.bmc.ctmconvert.services.ConversionEntitiesService;
import com.bmc.ctmconvert.services.VendorDataManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import java.util.function.Predicate;

public class ConversionSaveResults {
    private final Predicate<File> resultFilter;
    private boolean isSaved;
    private final String resultsName;
    private final String resultsDescription;

    public ConversionSaveResults(String name, String description, Predicate<File> resultFilter) {
        this.resultsName = name;
        this.resultsDescription = description;
        this.isSaved = false;
        this.resultFilter = resultFilter;
    }

    public void save() throws Exception {
        if (this.resultsName.isEmpty()) {
            throw new ConvertorException("Conversion results name must be provided");
        }
        if (GlobalFunctions.isConversionExist(this.resultsName)) {
            throw new ConvertorException("Conversion results name already exist.\nPlease enter a new conversion results name.");
        }
        this.createConversionFolder();
        this.isSaved = true;
    }

    public void createConversionFolder() throws Exception {
        Params.instance().setConversionName(this.resultsName);
        String projectDir = ConversionEntitiesService.getCurrentProjectDirectory();
        Path conversionsFolder = Paths.get(projectDir, new String[0]).resolve("CONVERSIONS");
        if (!Files.exists(conversionsFolder, new LinkOption[0])) {
            Files.createDirectory(conversionsFolder, new FileAttribute[0]);
        }
        String resultFolder = this.createFolder(conversionsFolder.resolve(this.resultsName));
        this.createConfigFile();
        this.createConversionsFiles(resultFolder);
        if (!Params.instance().isValidationProject()) {
            RuleManager.instance().exportDataSetFile(resultFolder + "Rules.xml");
        }
    }

    private void createConfigFile() {
        Properties conversionDetails = new Properties();
        conversionDetails.setProperty("NAME", this.resultsName);
        conversionDetails.setProperty("VENDOR", Params.instance().getVendorName());
        conversionDetails.setProperty("VENDOR_FULL_NAME", VendorDataManager.instance().getVendorData(Params.instance().getVendorName()).getDisplayName());
        conversionDetails.setProperty("CREATION_DATE", GlobalFunctions.getCurrentDateByFormat("dd-MM-yyyy HH:mm"));
        if (!Params.instance().isValidationProject()) {
            conversionDetails.setProperty("DESCRIPTION", this.resultsDescription);
            conversionDetails.setProperty("RULES_NAME", RuleManager.instance().getCurrentRulesTitle());
            conversionDetails.setProperty("OUTPUT_VERSION", Params.instance().getGUIVersion());
            conversionDetails.setProperty("DS_CONTROL_M", Params.instance().getDatacenterName());
            if (Params.instance().isZOS()) {
                conversionDetails.setProperty("ZOS_CONTROL_M", Params.instance().getMFDatacenterName());
            }
        }
        ConversionEntitiesService.registerNewConversion(conversionDetails);
        try (FileWriter fileWriter = new FileWriter(ConversionEntitiesService.getCurrentConversionDirectory() + Globs.DIRSEP + "properties.cfg");
             BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);){
            conversionDetails.store(bufferedWriter, null);
        }
        catch (IOException e) {
            ConversionLogger.getLogger().severe("Unable to save project properties");
        }
    }

    private void createConversionsFiles(String folder) {
        File source = new File(Globs.TEMP_EVALUATION_DIR);
        this.copyFolderContent(source, folder);
    }

    private void copyFolderContent(File source, String destination) {
        File[] listOfFiles = source.listFiles(this.resultFilter::test);
        if (listOfFiles == null) {
            return;
        }
        for (File listOfFile : listOfFiles) {
            if (listOfFile.isDirectory()) {
                File file = new File(destination + Globs.DIRSEP + listOfFile.getName());
                file.mkdir();
                this.copyFolderContent(listOfFile, file.getAbsolutePath() + Globs.DIRSEP);
                continue;
            }
            try {
                if (this.isEBCDICFile(listOfFile)) {
                    this.copyEBCDICFile(destination, listOfFile);
                    continue;
                }
                this.copyAsciiFile(destination, listOfFile);
            }
            catch (IOException e) {
                ExceptionHandler.writeToExceptionFile(e);
            }
        }
    }

    private void copyEBCDICFile(String destination, File listOfFile) throws IOException {
        try (FileChannel in = new FileInputStream(listOfFile.getAbsolutePath()).getChannel();
             FileChannel out = new FileOutputStream(destination + listOfFile.getName()).getChannel();){
            in.transferTo(0L, in.size(), out);
        }
    }

    private void copyAsciiFile(String destination, File listOfFile) throws IOException {
        try (BufferedReader br = FileUtils.createNewBufferedReader(Paths.get(listOfFile.getAbsolutePath(), new String[0]));
             BufferedWriter bw = FileUtils.createNewBufferedWriter(Paths.get(destination, new String[0]).resolve(listOfFile.getName()), new OpenOption[0]);){
            String currentLine;
            while ((currentLine = br.readLine()) != null) {
                bw.write(currentLine);
                bw.newLine();
            }
        }
    }

    private boolean isEBCDICFile(File listOfFile) {
        return listOfFile.toString().toUpperCase().contains("EBCDIC");
    }

    private String createFolder(Path folder) throws Exception {
        if (Files.exists(folder, new LinkOption[0])) {
            throw new Exception("Folder already exist...");
        }
        Files.createDirectory(folder, new FileAttribute[0]);
        return folder.toFile().getAbsolutePath();
    }

    public boolean isSaved() {
        return this.isSaved;
    }
}

