/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.common.AttrHolder;
import com.bmc.ctmconvert.common.ExceptionHandler;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

public class ConnectionProfileGenerator {
    protected AttrHolder getAsAttrHolder(String param) {
        String[] pairAttrs = param.split(";");
        int length = pairAttrs.length;
        HashMap<String, Integer> name2Index = new HashMap<String, Integer>();
        String[] values = new String[length];
        for (int i = 0; i < length; ++i) {
            String[] nameValue = pairAttrs[i].split("=");
            name2Index.put(nameValue[0], i);
            values[i] = nameValue.length == 2 ? nameValue[1] : "";
        }
        return new AttrHolder(values, name2Index);
    }

    protected void writeJsonFile(String jsonObjName, Path dir, List<String> filesPath, String nodeName, JSONObject jsonObj) {
        Path file = dir.resolve(jsonObjName + (String)(nodeName == null || nodeName.isEmpty() ? "" : "_" + nodeName) + ".json");
        JSONObject aftAccountsJSON = new JSONObject();
        aftAccountsJSON.put(jsonObjName, (Object)this.toCentralized(jsonObj));
        try {
            Files.writeString(file, (CharSequence)aftAccountsJSON.toString(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            filesPath.add(file.toString());
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile(e);
        }
    }

    private JSONObject toCentralized(JSONObject jsonObj) {
        if (jsonObj.has("TargetCTM")) {
            jsonObj.remove("TargetCTM");
        }
        if (jsonObj.has("TargetAgent")) {
            jsonObj.remove("TargetAgent");
        }
        if (!jsonObj.has("Centralized")) {
            jsonObj.put("Centralized", (Object)Boolean.TRUE);
        }
        return jsonObj;
    }

    protected void createJsonObjectPerAgent(String name, JSONObject jsonObj, Path dir, Set<String> nodes, List<String> filesPath) {
        nodes.forEach(node -> {
            try {
                JSONObject copy = this.copyFrom(jsonObj, JSONObject.getNames((JSONObject)jsonObj));
                copy.put("TargetAgent", node);
                this.writeJsonFile(name, dir, filesPath, (String)node, copy);
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
        });
    }

    private JSONObject copyFrom(JSONObject jsonObj, String[] names) throws NoSuchFieldException, IllegalAccessException {
        JSONObject objCP = this.getJsonObject_PreserveOrder();
        for (String name : names) {
            objCP.put(name, jsonObj.get(name));
        }
        return objCP;
    }

    protected List<String> createJsonFiles(Path dirPath, Map<String, JSONObject> jsonObjects, Map<String, Set<String>> nodeGroupMap) {
        ArrayList<String> filesPath = new ArrayList<String>();
        jsonObjects.forEach((key, value) -> {
            String targetAgent = (String)value.get("TargetAgent");
            Set nodes = (Set)nodeGroupMap.get(targetAgent);
            if (nodes != null) {
                this.createJsonObjectPerAgent((String)key, (JSONObject)value, dirPath, nodes, (List<String>)filesPath);
            } else {
                this.writeJsonFile((String)key, dirPath, (List<String>)filesPath, targetAgent, (JSONObject)value);
            }
        });
        return filesPath;
    }

    protected JSONObject getJsonObject_PreserveOrder() throws NoSuchFieldException, IllegalAccessException {
        JSONObject objCP = new JSONObject();
        Field map = objCP.getClass().getDeclaredField("map");
        map.setAccessible(true);
        map.set(objCP, new LinkedHashMap());
        map.setAccessible(false);
        return objCP;
    }
}

