/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.gui.report;

import com.bmc.ctmconvert.base.BaseContentPanel;
import com.bmc.ctmconvert.base.BaseFilteredTree;
import com.bmc.ctmconvert.base.BaseMessageDialog;
import com.bmc.ctmconvert.base.BaseNavigationPanel;
import com.bmc.ctmconvert.base.BasePanel;
import com.bmc.ctmconvert.base.BaseReportRenderer;
import com.bmc.ctmconvert.base.BaseSplitPane;
import com.bmc.ctmconvert.base.ButtonFactory;
import com.bmc.ctmconvert.base.ConversionEvent;
import com.bmc.ctmconvert.base.table.BaseTableHeaserGradientPanel;
import com.bmc.ctmconvert.base.table.TableHeaderRenderer;
import com.bmc.ctmconvert.common.DescriptionManager;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.common.draftwriter.JobMessage;
import com.bmc.ctmconvert.gui.flow.ConversionReportManager;
import com.bmc.ctmconvert.gui.flow.FlowManager;
import com.bmc.ctmconvert.gui.report.CustomRenderer;
import com.bmc.ctmconvert.gui.report.TopPanelModel;
import com.bmc.ctmconvert.gui.report.topPanelTableCellRenderer;
import com.bmc.ctmconvert.messages.ActionMessage;
import com.bmc.ctmconvert.messages.ActionTable;
import com.bmc.ctmconvert.messages.FullReportTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.ListSelectionModel;
import javax.swing.ScrollPaneLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class FullReportPanel
extends BasePanel
implements ActionListener,
AdjustmentListener,
TreeSelectionListener {
    public static final String COL_HEADING_SEQ = TextManager.instance().get("CONVERSION_REPORT_COLUMN_SEQ");
    public static final String COL_HEADING_MSGID = TextManager.instance().get("CONVERSION_REPORT_COLUMN_MESSAGE_ID");
    public static final String COL_HEADING_MSGTXT = TextManager.instance().get("CONVERSION_REPORT_COLUMN_MESSAGE_TEXT");
    public static final String COL_HEADING_MSGTYPE = TextManager.instance().get("CONVERSION_REPORT_COLUMN_MESSAGE_TYPE");
    public static final String COL_HEADING_DESC = TextManager.instance().get("CONVERSION_REPORT_COLUMN_DESCRIPTION");
    public static final String COL_HEADING_JOBID = TextManager.instance().get("CONVERSION_REPORT_COLUMN_JOB_ID");
    public static final String COL_HEADING_ENTTYPE = TextManager.instance().get("CONVERSION_REPORT_COLUMN_ENTITY_TYPE");
    public static final String COL_HEADING_ENTNAME = TextManager.instance().get("CONVERSION_REPORT_COLUMN_ENTITY_NAME");
    public static final String COL_HEADING_COUNT = TextManager.instance().get("CONVERSION_REPORT_COLUMN_COUNT");
    public static final String COL_HEADING_AFFECT_JOBS = TextManager.instance().get("CONVERSION_REPORT_COLUMN_AFFECTED_JOBS");
    public static final String COL_HEADING_QTY = TextManager.instance().get("CONVERSION_REPORT_COLUMN_QUANTITY");
    public static final String COL_HEADING_MAX_QTY = TextManager.instance().get("CONVERSION_REPORT_COLUMN_MAX_QUANTITY");
    public static final String COL_HEADING_TOTAL_QTY = TextManager.instance().get("CONVERSION_REPORT_COLUMN_TOTAL_QUANTITY");
    public static final String COL_HEADING_ORIGIN = TextManager.instance().get("CONVERSION_REPORT_COLUMN_ORIGIN");
    public static final String COL_HEADING_NODE_LIST = TextManager.instance().get("CONVERSION_REPORT_COLUMN_NODES_LIST");
    public static final String COL_HEADING_DEST_INFO = TextManager.instance().get("CONVERSION_REPORT_COLUMN_DESTINATION_INFO");
    public static final String ROW_HEADING_TOTAL = TextManager.instance().get("CONVERSION_REPORT_COLUMN_TOTAL");
    public static final Integer VIEW_MODE_COUNT = 3;
    public static final Integer VIEW_MODE_BY_RESULT = 0;
    public static final Integer VIEW_MODE_BY_JOB = 1;
    public static final Integer VIEW_MODE_BY_ACTION = 2;
    public static final Integer REPORT_TYPE_EMBEDDED = 0;
    public static final Integer REPORT_TYPE_CONVERSION = 1;
    public static final Integer REPORT_TYPE_VALIDATION = 2;
    private Integer viewMode = VIEW_MODE_BY_RESULT;
    private Integer reportType = REPORT_TYPE_EMBEDDED;
    private String inputPath = "";
    private String exportFileName = "";
    private static final Integer MAX_TYPE_NODES = ActionMessage.ActionTypeArray.length;
    private JMenuBar menuBar = null;
    private JLabel statusBar = null;
    private JTable[] reportTopPanel = null;
    private TreeMap<String, JobMessage> messages = null;
    private TreeMap<String, JobMessage> messages_byJobId = null;
    private TreeMap<String, ActionMessage> action_messages = null;
    private TreeMap<String, ActionMessage> action_messages_byJobId = null;
    private BaseFilteredTree[] reportTreePanelBy = new BaseFilteredTree[]{null, null, null};
    private DefaultMutableTreeNode lastSelectedTreeNode = null;
    private JMenuItem file_Exit = null;
    private JMenuItem file_Export = null;
    private JMenuItem view_Find = null;
    private JCheckBoxMenuItem view_By_Result = null;
    private JCheckBoxMenuItem view_By_Job = null;
    private JCheckBoxMenuItem view_By_Action = null;
    private JMenuItem view_Zoom = null;
    private JMenuItem helpItem = null;
    private String reportTitle;
    private JobMessage[] job_message_temp_list = null;
    private ActionMessage[] act_message_temp_list = null;
    private TreeMap<String, ActionMessage> action_messages_description = null;
    private String JobResultsTable = "";
    private String[] fullReportAttrArray = new String[]{"_ID", "JOBID", "MSGID", "MSGTYPE", "MSGVENDOR", "MSGSTATUS", "MSGTXT", "MSGEXTTXT"};
    private String[] actionReportAttrArray = new String[]{"_ID", "JOBID", "ACTENTTYPE", "ACTENTNAME", "MSGSTATUS", "ACTENTQTY", "ACTDESC"};
    protected JPanel mainPanel;
    protected BaseSplitPane mainSplitPane;
    private BaseSplitPane[] rightHandSplitPanel;
    private JScrollPane[] jscroll_topPanel;
    private JScrollPane[] jscroll_bottomPanel;
    private BaseContentPanel[] contentByView;
    private Map<ExcelStyleType, CellStyle> exportedExcelStyles;
    private DefaultMutableTreeNode DBNode;
    private DefaultMutableTreeNode QRNode;
    private DefaultMutableTreeNode UDNode;
    private DefaultMutableTreeNode GVNode;
    private DefaultMutableTreeNode AFTNode;

    Map<String, ActionMessage> getActionMessages() {
        return this.action_messages;
    }

    public FullReportPanel(String path, Integer type) {
        this.inputPath = path;
        this.JobResultsTable = this.inputPath + Globs.DIRSEP + "Results.csv";
        this.reportType = type;
        this.initialize();
    }

    protected FullReportPanel(Integer report_type, String input_path, String JobResultsTableName, String export_file_name) {
        this.reportType = report_type;
        this.inputPath = input_path;
        this.JobResultsTable = this.inputPath + Globs.DIRSEP + JobResultsTableName;
        this.exportFileName = export_file_name;
        this.initialize();
    }

    protected void initialize() {
        this.loadMessages();
        this.loadActions();
        this.contentByView = new BaseContentPanel[VIEW_MODE_COUNT.intValue()];
        this.reportTopPanel = new JTable[VIEW_MODE_COUNT.intValue()];
        this.rightHandSplitPanel = new BaseSplitPane[VIEW_MODE_COUNT.intValue()];
        this.jscroll_topPanel = new JScrollPane[VIEW_MODE_COUNT.intValue()];
        this.jscroll_bottomPanel = new JScrollPane[VIEW_MODE_COUNT.intValue()];
        for (int view = 0; view < VIEW_MODE_COUNT; ++view) {
            this.initializeGUIComponents(view);
        }
        this.setViewBy(VIEW_MODE_BY_RESULT);
    }

    protected void initializeGUIComponents(int view) {
        this.viewMode = view;
        if (this.reportType == REPORT_TYPE_CONVERSION) {
            this.reportTitle = TextManager.instance().get("CONVERSION_REPORT_TITLE");
        }
        this.baseContentPanel = new BaseContentPanel();
        this.setNavigationPanel(new BaseNavigationPanel(new ButtonFactory.ButtonType[]{ButtonFactory.ButtonType.CLOSE}));
        this.setContentPanel(this.baseContentPanel);
        this.rightHandSplitPanel[view] = new BaseSplitPane(0);
        this.mainSplitPane = new BaseSplitPane(1);
        this.mainSplitPane.setComponent(this.rightHandSplitPanel[view].getComponent(), BaseSplitPane.ComponentPosition.RIGHT);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add(this.mainSplitPane.getComponent(), "Center");
        this.createReportTreePanel();
        this.createCenterPanel();
        this.setSelectedRow();
        if (this.reportType != REPORT_TYPE_EMBEDDED) {
            this.createMenuBar();
            this.createStatusBar();
            this.setPanelTitle(this.reportTitle + " - " + TextManager.instance().get("CONVERSION_REPORT_VIEW_BY_MESSAGE_TYPE"));
        } else {
            this.baseContentPanel.setScrollable(false);
            this.baseContentPanel.setBorder(null);
        }
        this.baseContentPanel.setContentPanel((Component)this.mainPanel);
        this.contentByView[view] = this.baseContentPanel;
    }

    public BaseContentPanel getView(int view) {
        return this.contentByView[view];
    }

    public void setViewMode(int view) {
        this.viewMode = view;
    }

    protected void loadAndDisplay(String JobResultsTableName) {
    }

    public void setSelectedRow() {
        int selectedRow = this.reportTreePanelBy[this.viewMode].getSelectionRow();
        if (this.reportType == REPORT_TYPE_VALIDATION) {
            selectedRow = 1;
        }
        this.reportTreePanelBy[this.viewMode].setSelectionRow(-1);
        this.reportTreePanelBy[this.viewMode].setSelectionRow(selectedRow);
        this.reportTreePanelBy[this.viewMode].requestFocus();
    }

    private void createCenterPanel() {
        this.createTopPanel();
        this.createBottomPanel();
    }

    private void updateCenterPanel(String parent_id, String node_id) {
        Integer selectedRow = this.createTopPanel(parent_id, node_id);
        this.reportTopPanel[this.viewMode].setRowSelectionInterval(selectedRow, selectedRow);
        this.rightHandSplitPanel[this.viewMode].setComponent((Component)this.jscroll_bottomPanel[this.viewMode], BaseSplitPane.ComponentPosition.BOTTOM);
    }

    private void updateCenterPanel(DefaultMutableTreeNode node) {
        this.createTopPanel(node);
        this.rightHandSplitPanel[this.viewMode].setComponent(null, BaseSplitPane.ComponentPosition.BOTTOM);
    }

    private void setTopPanelAttr(final boolean withTotalLine) {
        this.reportTopPanel[this.viewMode].setColumnSelectionAllowed(false);
        this.reportTopPanel[this.viewMode].setSelectionMode(0);
        this.reportTopPanel[this.viewMode].setIntercellSpacing(new Dimension(3, 0));
        this.reportTopPanel[this.viewMode].setRowHeight(20);
        this.reportTopPanel[this.viewMode].addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                Point p = event.getPoint();
                Integer row = FullReportPanel.this.reportTopPanel[FullReportPanel.this.viewMode].rowAtPoint(p);
                Integer clickCount = event.getClickCount();
                if (clickCount > 1) {
                    FullReportPanel.this.topPanel_doubleClick(row, withTotalLine);
                }
            }
        });
        Integer i = 0;
        while (i < this.reportTopPanel[this.viewMode].getColumnCount()) {
            TableColumn tcol = this.reportTopPanel[this.viewMode].getColumnModel().getColumn(i);
            tcol.setCellRenderer(new topPanelTableCellRenderer(withTotalLine));
            Integer n = i;
            i = i + 1;
        }
    }

    private void createTopPanel() {
        JPanel panel1 = new JPanel(new GridLayout(0, 1));
        panel1.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        panel1.setBackground(Color.WHITE);
        panel1.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        panel1.setFont(FlowGlobals.FONT_STYLE_ARIAL_MS_UNICODE);
        this.jscroll_topPanel[this.viewMode.intValue()] = new JScrollPane(panel1);
        this.jscroll_topPanel[this.viewMode].setBackground(Color.WHITE);
        this.jscroll_topPanel[this.viewMode].setLayout(new ScrollPaneLayout());
        this.jscroll_topPanel[this.viewMode].setBorder(null);
        this.jscroll_topPanel[this.viewMode].setVerticalScrollBarPolicy(20);
        this.jscroll_topPanel[this.viewMode].setHorizontalScrollBarPolicy(30);
        this.jscroll_topPanel[this.viewMode].setPreferredSize(new Dimension(500, 90));
        this.jscroll_topPanel[this.viewMode].setFont(FlowGlobals.FONT_STYLE_ARIAL_MS_UNICODE);
        this.rightHandSplitPanel[this.viewMode].setComponent((Component)this.jscroll_topPanel[this.viewMode], BaseSplitPane.ComponentPosition.TOP);
    }

    public TopPanelModel getTopPanelModel(String type) {
        DefaultMutableTreeNode node = null;
        this.setViewBy(VIEW_MODE_BY_ACTION);
        switch (type) {
            case "QR": {
                node = this.QRNode;
                break;
            }
            case "GLOBALVAR": {
                node = this.GVNode;
                break;
            }
            case "User Daily": {
                node = this.UDNode;
                break;
            }
            case "AFTACC": {
                node = this.AFTNode;
                break;
            }
            case "DATABASEACC": {
                node = this.DBNode;
            }
        }
        if (node != null) {
            return new TopPanelModel(this.viewMode, node, this);
        }
        return null;
    }

    private void createTopPanel(DefaultMutableTreeNode node) {
        TableColumn countTableColumn = null;
        Integer count_col_width = 10;
        this.reportTopPanel[this.viewMode.intValue()] = this.getRenderedTable(new TopPanelModel(this.viewMode, node, this));
        this.reportTopPanel[this.viewMode].setFont(FlowGlobals.FONT_STYLE_ARIAL_MS_UNICODE);
        this.setTopPanelAttr(true);
        ListSelectionModel listSelectionModel = this.reportTopPanel[this.viewMode].getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(this){

            @Override
            public void valueChanged(ListSelectionEvent e) {
            }
        });
        this.reportTopPanel[this.viewMode].setSelectionModel(listSelectionModel);
        DefaultTableCellRenderer dftCountRenderer = new DefaultTableCellRenderer();
        dftCountRenderer.setHorizontalAlignment(4);
        try {
            countTableColumn = this.reportTopPanel[this.viewMode].getColumn(COL_HEADING_COUNT);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (countTableColumn == null) {
            int paddingWidth = 8;
            count_col_width = COL_HEADING_AFFECT_JOBS.length() + paddingWidth;
            try {
                countTableColumn = this.reportTopPanel[this.viewMode].getColumn(COL_HEADING_AFFECT_JOBS);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        TableColumnModel tcm = this.reportTopPanel[this.viewMode].getColumnModel();
        tcm.getColumn(0).setPreferredWidth(5);
        if (this.reportTopPanel[this.viewMode].getColumnName(1).equals(COL_HEADING_JOBID)) {
            tcm.getColumn(1).setPreferredWidth(220);
        } else {
            tcm.getColumn(1).setPreferredWidth(60);
        }
        tcm.getColumn(2).setPreferredWidth(count_col_width);
        if (tcm.getColumnCount() == 4) {
            tcm.getColumn(3).setPreferredWidth(300 - tcm.getColumn(1).getPreferredWidth());
        }
        if (tcm.getColumnCount() > 4) {
            tcm.getColumn(3).setPreferredWidth(50);
            tcm.getColumn(4).setPreferredWidth(50);
            TableColumn maxQtyTableColumn = this.reportTopPanel[this.viewMode].getColumn(COL_HEADING_MAX_QTY);
            maxQtyTableColumn.setCellRenderer(dftCountRenderer);
            TableColumn totalQtyTableColumn = this.reportTopPanel[this.viewMode].getColumn(COL_HEADING_TOTAL_QTY);
            totalQtyTableColumn.setCellRenderer(dftCountRenderer);
        }
        this.jscroll_topPanel[this.viewMode].getViewport().removeAll();
        this.jscroll_topPanel[this.viewMode].setViewportView(this.reportTopPanel[this.viewMode]);
        this.jscroll_topPanel[this.viewMode].setPreferredSize(new Dimension(500, 500));
        this.reportTopPanel[this.viewMode].getParent().setBackground(Color.WHITE);
    }

    private JTable getRenderedTable(TopPanelModel tpm) {
        JTable toRet = new JTable(tpm){
            private static final long serialVersionUID = 1L;

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int Index_row, int Index_col) {
                Component component = super.prepareRenderer(renderer, Index_row, Index_col);
                component.setForeground(FlowGlobals.ConversionBlack);
                if (this.isCellSelected(Index_row, Index_col)) {
                    component.setBackground(new Color(8832748));
                    component.setForeground(FlowGlobals.ConversionWhite);
                } else if (Index_row % 2 == 0) {
                    component.setBackground(new Color(0xEBEBEB));
                } else {
                    component.setBackground(FlowGlobals.ConversionWhite);
                }
                return component;
            }
        };
        this.setTableHeaderRenderer(toRet, true);
        return toRet;
    }

    private void setTableHeaderRenderer(final JTable table, boolean fullSetup) {
        for (TableColumn column : Collections.list(table.getColumnModel().getColumns())) {
            column.setHeaderRenderer((TableCellRenderer)new TableHeaderRenderer(){
                private static final long serialVersionUID = 1L;

                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    JLabel newLabel = new JLabel();
                    BaseTableHeaserGradientPanel jPanel = new BaseTableHeaserGradientPanel();
                    jPanel.setLayout(new BoxLayout((Container)jPanel, 0));
                    jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
                    jPanel.setPreferredSize(new Dimension(1, 22));
                    newLabel.setText(label.getText());
                    newLabel.setForeground(FlowGlobals.ConversionWhite);
                    jPanel.add(newLabel);
                    jPanel.add(Box.createHorizontalGlue());
                    return jPanel;
                }
            });
        }
        if (fullSetup) {
            table.getTableHeader().setReorderingAllowed(false);
            table.addPropertyChangeListener("model", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    FullReportPanel.this.setTableHeaderRenderer(table, false);
                }
            });
        }
    }

    private Integer createTopPanel(String parent_id, String node_id) {
        Integer selectedRow = 0;
        TopPanelModel tpm = new TopPanelModel(this.viewMode, parent_id, node_id, this);
        selectedRow = tpm.getSelectedRow();
        this.reportTopPanel[this.viewMode.intValue()] = this.getRenderedTable(tpm);
        this.setTopPanelAttr(false);
        ListSelectionModel listSelectionModel = this.reportTopPanel[this.viewMode].getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FullReportPanel.this.topPanel_leafNodeListChanged(e);
            }
        });
        this.reportTopPanel[this.viewMode].setSelectionModel(listSelectionModel);
        TableColumnModel tcm = this.reportTopPanel[this.viewMode].getColumnModel();
        tcm.getColumn(0).setPreferredWidth(3);
        if (this.viewMode == VIEW_MODE_BY_ACTION) {
            tcm.getColumn(1).setMinWidth(100);
            tcm.getColumn(2).setMinWidth(300);
            tcm.getColumn(3).setMinWidth(50);
        } else if (this.viewMode == VIEW_MODE_BY_RESULT) {
            tcm.getColumn(1).setWidth(60);
            tcm.getColumn(2).setMinWidth(350);
        } else {
            tcm.getColumn(1).setWidth(60);
            tcm.getColumn(2).setMinWidth(350);
        }
        this.jscroll_topPanel[this.viewMode].getViewport().removeAll();
        this.jscroll_topPanel[this.viewMode].setViewportView(this.reportTopPanel[this.viewMode]);
        this.jscroll_topPanel[this.viewMode].setPreferredSize(new Dimension(500, 175));
        this.reportTopPanel[this.viewMode].getParent().setBackground(Color.WHITE);
        this.reportTopPanel[this.viewMode].setFont(FlowGlobals.FONT_STYLE_ARIAL_MS_UNICODE);
        return selectedRow;
    }

    private void createBottomPanel() {
        JTextPane label2_1 = new JTextPane();
        label2_1.setFont(FlowGlobals.FONT_STYLE_ARIAL_MS_UNICODE);
        this.jscroll_bottomPanel[this.viewMode.intValue()] = new JScrollPane(label2_1);
        this.jscroll_bottomPanel[this.viewMode].setLayout(new ScrollPaneLayout());
        this.jscroll_bottomPanel[this.viewMode].setHorizontalScrollBarPolicy(31);
        this.jscroll_bottomPanel[this.viewMode].setVerticalScrollBarPolicy(20);
        this.jscroll_bottomPanel[this.viewMode].setPreferredSize(new Dimension(500, 100));
        this.jscroll_bottomPanel[this.viewMode].setBorder(null);
        this.jscroll_bottomPanel[this.viewMode].setFont(FlowGlobals.FONT_STYLE_ARIAL_MS_UNICODE);
        this.rightHandSplitPanel[this.viewMode].setComponent((Component)this.jscroll_bottomPanel[this.viewMode], BaseSplitPane.ComponentPosition.BOTTOM);
    }

    private void updateBottomPanel(Integer topPanel_index) {
        String origin = "";
        Object pane_info = "";
        if (this.viewMode == VIEW_MODE_BY_ACTION) {
            Integer[] actionStats = this.getActionStats(this.act_message_temp_list[topPanel_index].getActionEntityType(), this.act_message_temp_list[topPanel_index].getActionEntityName());
            pane_info = this.formatBottomPanelLine(COL_HEADING_ENTTYPE, this.act_message_temp_list[topPanel_index].getActionEntityTypeDesc()) + "\n" + this.formatBottomPanelLine(COL_HEADING_ENTNAME, this.act_message_temp_list[topPanel_index].getActionEntityName()) + "\n" + this.formatBottomPanelLine(COL_HEADING_JOBID, this.act_message_temp_list[topPanel_index].getActionJobId()) + "\n" + this.formatBottomPanelLine(COL_HEADING_COUNT, actionStats[0].toString());
            if (this.act_message_temp_list[topPanel_index].getActionEntityType().toString().equalsIgnoreCase("QR")) {
                pane_info = (String)pane_info + "\n" + this.formatBottomPanelLine(COL_HEADING_QTY, this.act_message_temp_list[topPanel_index].getActionQty().toString()) + "\n" + this.formatBottomPanelLine(COL_HEADING_MAX_QTY, actionStats[1].toString()) + "\n" + this.formatBottomPanelLine(COL_HEADING_TOTAL_QTY, actionStats[2].toString());
            } else if (this.act_message_temp_list[topPanel_index].getActionEntityType().toString().equalsIgnoreCase("JOB")) {
                pane_info = (String)pane_info + "\n" + this.formatBottomPanelLine(COL_HEADING_DESC, this.act_message_temp_list[topPanel_index].getActionDescription().toString());
            } else if (this.act_message_temp_list[topPanel_index].getActionDescription() != null && !this.act_message_temp_list[topPanel_index].getActionDescription().toString().equals("")) {
                String row_description = COL_HEADING_DESC;
                if (this.act_message_temp_list[topPanel_index].getActionEntityType().toString().equalsIgnoreCase("SHOUT")) {
                    row_description = COL_HEADING_DEST_INFO;
                }
                if (this.act_message_temp_list[topPanel_index].getActionEntityType().toString().equalsIgnoreCase("NODEGRP")) {
                    row_description = COL_HEADING_NODE_LIST;
                }
                pane_info = (String)pane_info + "\n" + this.formatBottomPanelLine(row_description, this.act_message_temp_list[topPanel_index].getActionDescription().toString());
            }
        } else {
            origin = this.job_message_temp_list[topPanel_index].getMessageVendor();
            if (origin.isEmpty()) {
                origin = TextManager.instance().get("CONVERSION_REPORT_ORIGIN_ALL");
            }
            pane_info = this.formatBottomPanelLine(COL_HEADING_MSGID, this.job_message_temp_list[topPanel_index].getMessageID()) + "\n" + this.formatBottomPanelLine(COL_HEADING_MSGTYPE, this.job_message_temp_list[topPanel_index].getMessageTypeDesc()) + "\n" + this.formatBottomPanelLine(COL_HEADING_JOBID, this.job_message_temp_list[topPanel_index].getMessageJobId()) + "\n" + this.formatBottomPanelLine(COL_HEADING_ORIGIN, origin) + "\n_________________________________________________________________________\n\n" + this.formatBottomPanelLine(COL_HEADING_DESC, this.job_message_temp_list[topPanel_index].getMessageText()) + "\n\n " + this.job_message_temp_list[topPanel_index].getMessageExtendedText();
        }
        JTextPane label2_1 = new JTextPane();
        label2_1.setFont(FlowGlobals.FONT_STYLE_ARIAL_MS_UNICODE);
        label2_1.setText((String)pane_info);
        Dimension dim2 = new Dimension(label2_1.getPreferredSize());
        if (dim2.width > 2500) {
            dim2.height = 200 + (dim2.width - 2500) / 450 * 20;
        }
        dim2.width = 1;
        label2_1.setPreferredSize(dim2);
        label2_1.setSelectionStart(0);
        label2_1.setSelectionEnd(0);
        label2_1.setEditable(false);
        this.jscroll_bottomPanel[this.viewMode].getViewport().removeAll();
        this.jscroll_bottomPanel[this.viewMode].setViewportView(label2_1);
    }

    private String formatBottomPanelLine(String name, String value) {
        String formatted_line = " " + name.toString();
        if (formatted_line.length() == 0) {
            formatted_line = formatted_line + " ";
        }
        Integer i = formatted_line.length();
        while (i < 25) {
            formatted_line = formatted_line + ". ";
            i = i + 2;
        }
        formatted_line = formatted_line + ":\t" + value.toString();
        return formatted_line;
    }

    public Integer[] getActionStats(String entity_type, String entity_name) {
        Integer[] action_stats = new Integer[]{0, 0, 0};
        SortedMap<String, ActionMessage> sub_list = null;
        String from_key = "";
        String to_key = "";
        Integer action_qty = 0;
        from_key = String.format("%s%s%s%s", entity_type.toString(), "|", entity_name.toString(), "|");
        to_key = String.format("%s%s%s%s%c", entity_type.toString(), "|", entity_name.toString(), "|", Character.valueOf('\uffff'));
        sub_list = this.action_messages.subMap(from_key, to_key);
        for (ActionMessage list_entry : sub_list.values()) {
            action_stats[0] = action_stats[0] + 1;
            if (!entity_type.toString().equalsIgnoreCase("QR")) continue;
            try {
                action_qty = Integer.parseInt(list_entry.getActionQty());
            }
            catch (NumberFormatException e) {
                action_qty = 0;
            }
            if (action_qty > action_stats[1]) {
                action_stats[1] = action_qty;
            }
            action_stats[2] = action_stats[2] + action_qty;
        }
        return action_stats;
    }

    public Integer getChildNodeCount(Integer view_mode, String node_id) {
        SortedMap<String, JobMessage> sub_list = null;
        String from_key = "";
        String to_key = "";
        from_key = String.format("%s%s", node_id.toString(), "|");
        to_key = String.format("%s%s%c", node_id.toString(), "|", Character.valueOf('\uffff'));
        sub_list = this.messages_byJobId.subMap(from_key, to_key);
        return sub_list.size();
    }

    public Integer getChildNodeCount(Integer view_mode, String node_id, String parent_id) {
        String node_key = "";
        node_key = String.format("%s%s%s", node_id.toString(), "|", parent_id.toString());
        return this.getChildNodeCount(view_mode, node_key);
    }

    private void createReportTreePanel() {
        Object object;
        Object cur_key = "";
        Object old_key = "";
        String old_node = "";
        ActionMessage actMsg = null;
        DefaultMutableTreeNode[] MsgTypeNodes = new DefaultMutableTreeNode[MAX_TYPE_NODES.intValue()];
        DefaultMutableTreeNode curKeyNode = null;
        DefaultMutableTreeNode node = null;
        Integer i = 0;
        String rootName = Params.instance().getDatasourceName().toString();
        if (Params.instance().getConversionName() != null) {
            rootName = Params.instance().getConversionName().toString();
        }
        DefaultMutableTreeNode mainTreeNodes = new DefaultMutableTreeNode(rootName);
        BaseFilteredTree reportMainTree = new BaseFilteredTree(mainTreeNodes);
        reportMainTree.addTreeSelectionListener((TreeSelectionListener)this);
        reportMainTree.setCellRenderer((BaseReportRenderer)new CustomRenderer(this.viewMode));
        TreeMap<String, JobMessage> message_view = null;
        if (this.viewMode == VIEW_MODE_BY_RESULT) {
            message_view = this.messages;
            JobMessage jobMsg = new JobMessage("");
            i = 0;
            while (jobMsg.getMessageTypeDesc(i) != "Unknown") {
                MsgTypeNodes[i.intValue()] = new DefaultMutableTreeNode(jobMsg.getMessageTypeDesc(i));
                mainTreeNodes.add(MsgTypeNodes[i]);
                Integer n = i;
                i = i + 1;
            }
        }
        if (this.viewMode == VIEW_MODE_BY_JOB) {
            message_view = this.messages_byJobId;
        }
        if (this.viewMode == VIEW_MODE_BY_ACTION) {
            actMsg = new ActionMessage();
            i = 0;
            while (actMsg.getActionEntityTypeDesc(i) != "Unknown") {
                MsgTypeNodes[i.intValue()] = new DefaultMutableTreeNode(actMsg.getActionEntityTypeDesc(i));
                object = i;
                i = i + 1;
            }
        }
        if (this.viewMode == VIEW_MODE_BY_ACTION) {
            for (ActionMessage actionMessage : this.action_messages.values()) {
                cur_key = actionMessage.getActionEntityType() + "|" + actionMessage.getActionEntityName();
                if (!((String)cur_key).equals(old_key)) {
                    curKeyNode = new DefaultMutableTreeNode(actionMessage.getActionEntityName());
                    if (actionMessage.getActionEntityTypeIndex() >= 0) {
                        MsgTypeNodes[actionMessage.getActionEntityTypeIndex()].add(curKeyNode);
                    } else {
                        System.out.println("Action entity type " + actionMessage.getActionEntityType() + " is " + actionMessage.getActionEntityTypeDesc());
                    }
                    old_key = cur_key;
                    old_node = "";
                }
                if (actionMessage.getActionJobId().equals(old_node)) continue;
                if (actionMessage.getActionJobId().equals("")) {
                    if (actionMessage.getActionDescription() != null) {
                        this.action_messages_description.put((String)cur_key, actionMessage);
                    }
                } else {
                    node = new DefaultMutableTreeNode(actionMessage.getActionJobId());
                    curKeyNode.add(node);
                }
                old_node = actionMessage.getActionJobId();
            }
            i = 0;
            while (actMsg.getActionEntityTypeDesc(i) != "Unknown") {
                if (MsgTypeNodes[i].getChildCount() > 0 || actMsg.actionEntityShowWhenEmpty(i)) {
                    if (actMsg.getActionEntityTypeDesc(i).equals(Globs.ACTENTTYPE_QR_DESC)) {
                        this.QRNode = MsgTypeNodes[i];
                    } else if (actMsg.getActionEntityTypeDesc(i).equals(Globs.ACTENTTYPE_GLOBAL_AUTOEDIT_DESC)) {
                        this.GVNode = MsgTypeNodes[i];
                    } else if (actMsg.getActionEntityTypeDesc(i).equals("User Daily Input cards for MF")) {
                        this.UDNode = MsgTypeNodes[i];
                    } else if (actMsg.getActionEntityTypeDesc(i).equals("MFT Account")) {
                        this.AFTNode = MsgTypeNodes[i];
                    } else if (actMsg.getActionEntityTypeDesc(i).equals("Database Connection Profile")) {
                        this.DBNode = MsgTypeNodes[i];
                    }
                    mainTreeNodes.add(MsgTypeNodes[i]);
                }
                object = i;
                i = i + 1;
            }
        } else {
            for (JobMessage jobMessage : message_view.values()) {
                if (this.viewMode == VIEW_MODE_BY_RESULT) {
                    cur_key = jobMessage.getMessageID();
                }
                if (this.viewMode == VIEW_MODE_BY_JOB) {
                    cur_key = jobMessage.getMessageJobId();
                }
                if (!((String)cur_key).equals(old_key)) {
                    if (this.viewMode == VIEW_MODE_BY_RESULT) {
                        curKeyNode = new DefaultMutableTreeNode(jobMessage.getMessageID());
                        if (jobMessage.getMessageTypeIndex() >= 0) {
                            MsgTypeNodes[jobMessage.getMessageTypeIndex()].add(curKeyNode);
                        } else {
                            System.out.println("Message type " + jobMessage.getMessageType() + " is " + jobMessage.getMessageTypeDesc());
                        }
                    }
                    if (this.viewMode == VIEW_MODE_BY_JOB) {
                        curKeyNode = new DefaultMutableTreeNode(((String)cur_key).toString());
                        mainTreeNodes.add(curKeyNode);
                    }
                    old_key = cur_key;
                    old_node = "";
                }
                if (this.viewMode != VIEW_MODE_BY_RESULT || jobMessage.getMessageJobId().equals(old_node)) continue;
                node = new DefaultMutableTreeNode(jobMessage.getMessageJobId());
                curKeyNode.add(node);
                old_node = jobMessage.getMessageJobId();
            }
        }
        this.reportTreePanelBy[this.viewMode.intValue()] = reportMainTree;
        this.reportTreePanelBy[this.viewMode].expandRow(0);
        this.setReportTreePanel();
    }

    private void setReportTreePanel() {
        this.mainSplitPane.setComponent(this.reportTreePanelBy[this.viewMode].getComponent(), BaseSplitPane.ComponentPosition.LEFT);
        this.reportTreePanelBy[this.viewMode].setCellRenderer((BaseReportRenderer)new CustomRenderer(this.viewMode));
        this.reportTreePanelBy[this.viewMode].repaint();
    }

    private void loadMessages() {
        this.messages = new TreeMap(FullReportTable.instance((String)this.JobResultsTable).getMessages());
        this.messages_byJobId = new TreeMap(FullReportTable.instance((String)this.JobResultsTable).getMessagesByJobId());
    }

    public int loadMessages(FullReportTable report, String jobId) {
        String fromKey = jobId;
        String toKey = jobId + "\uffff";
        TreeMap allMessages = null;
        SortedMap sub_list = null;
        this.messages = new TreeMap();
        allMessages = new TreeMap(report.getMessagesByJobId());
        sub_list = allMessages.subMap((CallSite)((Object)fromKey), (CallSite)((Object)toKey));
        this.messages_byJobId = new TreeMap();
        this.messages_byJobId.putAll(sub_list);
        return this.messages_byJobId.size();
    }

    private void loadActions() {
        if (this.action_messages == null) {
            String actionsTable = this.inputPath + Globs.DIRSEP + "Actions.csv";
            ActionTable m_action = new ActionTable(actionsTable);
            this.action_messages = new TreeMap(m_action.getMessages());
            this.action_messages_byJobId = new TreeMap(m_action.getMessagesByJobId());
            this.action_messages_description = new TreeMap();
        }
    }

    private void createStatusBar() {
        JPanel statusBarPanel = new JPanel();
        statusBarPanel.setLayout(new BoxLayout(statusBarPanel, 0));
        statusBarPanel.setBackground(FlowGlobals.ConversionGray);
        statusBarPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, new Color(0xC5C5C5)), BorderFactory.createMatteBorder(1, 0, 0, 0, new Color(0xFFFFFF))), BorderFactory.createEmptyBorder(2, 10, 2, 10)));
        Object statusBarText = "";
        if (Params.instance().getVendorName() != null) {
            statusBarText = (String)statusBarText + TextManager.instance().get("CONVERSION_REPORT_SCHEDULER") + ": " + Params.instance().getVendorName().toString() + "     ";
        }
        if (Params.instance().getDatasourceName() != null) {
            statusBarText = (String)statusBarText + TextManager.instance().get("CONVERSION_REPORT_PROJECT") + ": " + Params.instance().getDatasourceName().toString() + "     ";
        }
        File report_file = new File(this.JobResultsTable);
        Long lastModified = report_file.lastModified();
        Date lastModifiedDate = new Date(lastModified);
        statusBarText = (String)statusBarText + TextManager.instance().get("CONVERSION_REPORT_TIME") + ": " + lastModifiedDate.toString() + "     ";
        this.statusBar = new JLabel((String)statusBarText);
        statusBarPanel.add(this.statusBar);
        statusBarPanel.add(Box.createHorizontalGlue());
        this.mainPanel.add((Component)statusBarPanel, "South");
    }

    private void createMenuBar() {
        this.menuBar = new JMenuBar();
        this.menuBar.setBackground(FlowGlobals.wrapperBackgroundColor);
        this.menuBar.setSize(410, 20);
        this.menuBar.setBorder(null);
        JMenu file = new JMenu(TextManager.instance().get("CONVERSION_REPORT_MENU_FILE"));
        file.setMnemonic(70);
        URL icon_save_URL = this.getClass().getResource("/img/icon_save.png");
        this.file_Export = new JMenuItem(TextManager.instance().get("CONVERSION_REPORT_MENU_ITEM_EXPORT_TO_FILE"), new ImageIcon(icon_save_URL));
        this.file_Export.setMnemonic(69);
        this.file_Export.addActionListener(this);
        file.add(this.file_Export);
        file.addSeparator();
        this.file_Exit = new JMenuItem(TextManager.instance().get("CONVERSION_REPORT_MENU_ITEM_EXIT"));
        this.file_Exit.setMnemonic(88);
        this.file_Exit.addActionListener(this);
        file.add(this.file_Exit);
        JMenu view = new JMenu(TextManager.instance().get("CONVERSION_REPORT_MENU_VIEW"));
        view.setMnemonic(86);
        if (this.reportType <= REPORT_TYPE_CONVERSION) {
            this.view_By_Result = new JCheckBoxMenuItem(TextManager.instance().get("CONVERSION_REPORT_MENU_ITEM_BY_MESSAGE_TYPE"), true);
            this.view_By_Result.addActionListener(this);
            this.view_By_Result.setMnemonic(84);
            view.add(this.view_By_Result);
        }
        this.view_By_Job = new JCheckBoxMenuItem(TextManager.instance().get("CONVERSION_REPORT_MENU_ITEM_BY_JOB"));
        this.view_By_Job.addActionListener(this);
        this.view_By_Job.setMnemonic(74);
        view.add(this.view_By_Job);
        if (this.reportType <= REPORT_TYPE_CONVERSION) {
            this.view_By_Action = new JCheckBoxMenuItem(TextManager.instance().get("CONVERSION_REPORT_MENU_ITEM_BY_CORRECTIVE_ACTION"));
            this.view_By_Action.addActionListener(this);
            this.view_By_Action.setMnemonic(65);
            view.add(this.view_By_Action);
        }
        JMenu help = new JMenu(TextManager.instance().get("CONVERSION_REPORT_MENU_HELP"));
        help.setMnemonic(72);
        this.helpItem = new JMenuItem(TextManager.instance().get("CONVERSION_REPORT_MENU_HELP"));
        this.helpItem.addActionListener(this);
        help.add(this.helpItem);
        this.menuBar.add(file);
        this.menuBar.add(view);
        this.menuBar.add(help);
    }

    public JMenuBar getJMenuBar() {
        return this.menuBar;
    }

    public String[][] getJobIdMessageList(String node_id, Integer view_mode) {
        if (view_mode == VIEW_MODE_BY_ACTION) {
            return this.getJobIdMessageListActionReport(node_id, view_mode);
        }
        return this.getJobIdMessageListFullReport(node_id, view_mode);
    }

    private String[][] getJobIdMessageListFullReport(String node_id, Integer view_mode) {
        SortedMap<String, JobMessage> sub_list = null;
        String id_name = "";
        int i = 0;
        String from_key = "";
        String to_key = "";
        from_key = String.format("%s%s", node_id, "|");
        to_key = String.format("%s%s%c", node_id, "|", Character.valueOf('\uffff'));
        sub_list = this.messages_byJobId.subMap(from_key, to_key);
        String[][] tmpArr = new String[sub_list.size()][2];
        this.job_message_temp_list = new JobMessage[sub_list.size()];
        for (JobMessage list_entry : sub_list.values()) {
            tmpArr[i][0] = id_name = list_entry.getMessageID();
            tmpArr[i][1] = list_entry.getMessageText();
            this.job_message_temp_list[i++] = list_entry;
        }
        return tmpArr;
    }

    private String[][] getJobIdMessageListActionReport(String node_id, Integer view_mode) {
        SortedMap<String, ActionMessage> sub_list = null;
        int i = 0;
        String from_key = "";
        String to_key = "";
        from_key = String.format("%s%s", node_id, "|");
        to_key = String.format("%s%s%c", node_id, "|", Character.valueOf('\uffff'));
        sub_list = this.action_messages_byJobId.subMap(from_key, to_key);
        String[][] tmpArr = new String[sub_list.size()][3];
        this.act_message_temp_list = new ActionMessage[sub_list.size()];
        for (ActionMessage list_entry : sub_list.values()) {
            tmpArr[i][0] = list_entry.getActionEntityTypeDesc();
            tmpArr[i][1] = list_entry.getActionEntityName();
            if (list_entry.getActionEntityType().equalsIgnoreCase("JOB")) {
                tmpArr[i][1] = list_entry.getActionDescription().toString();
            }
            tmpArr[i][2] = list_entry.getActionEntityType().equalsIgnoreCase("QR") ? list_entry.getActionQty().toString() : "";
            this.act_message_temp_list[i++] = list_entry;
        }
        return tmpArr;
    }

    private void topPanel_doubleClick(Integer row, boolean withTotalLine) {
        if (row < 0) {
            return;
        }
        if (row >= this.reportTopPanel[this.viewMode].getRowCount()) {
            return;
        }
        if (withTotalLine && row == this.reportTopPanel[this.viewMode].getRowCount() - 1) {
            return;
        }
        DefaultMutableTreeNode node = this.lastSelectedTreeNode;
        if (node == null) {
            return;
        }
        if (node.isLeaf()) {
            return;
        }
        DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(row);
        Enumeration<TreeNode> pathEnum = childNode.pathFromAncestorEnumeration(node.getRoot());
        Vector<DefaultMutableTreeNode> pathList = new Vector<DefaultMutableTreeNode>();
        while (pathEnum.hasMoreElements()) {
            DefaultMutableTreeNode curNode = (DefaultMutableTreeNode)pathEnum.nextElement();
            pathList.addElement(curNode);
        }
        Object[] pathArray = new DefaultMutableTreeNode[pathList.size()];
        pathList.copyInto(pathArray);
        this.reportTreePanelBy[this.viewMode].setExpandsSelectedPaths(true);
        this.reportTreePanelBy[this.viewMode].setSelectionPath(new TreePath(pathArray));
    }

    private void topPanel_leafNodeListChanged(ListSelectionEvent e) {
        if (this.reportTopPanel[this.viewMode].getSelectedRow() < 0) {
            return;
        }
        if (this.reportTopPanel[this.viewMode].getSelectedRow() >= this.reportTopPanel[this.viewMode].getRowCount()) {
            return;
        }
        this.updateBottomPanel(this.reportTopPanel[this.viewMode].getSelectedRow());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.file_Exit) {
            this.closeReportPanel();
        }
        if (e.getSource() == this.file_Export) {
            this.export2File();
        }
        if (e.getSource() == this.view_Find) {
            this.openFindWindow();
        }
        if (e.getSource() == this.view_By_Result) {
            this.setViewBy(VIEW_MODE_BY_RESULT);
        }
        if (e.getSource() == this.view_By_Job) {
            this.setViewBy(VIEW_MODE_BY_JOB);
        }
        if (e.getSource() == this.view_By_Action) {
            this.setViewBy(VIEW_MODE_BY_ACTION);
        }
        if (e.getSource() == this.view_Zoom) {
            this.openZoomWindow();
        }
        if (e.getSource() == this.helpItem) {
            this.showHelpFile();
        }
    }

    private void showHelpFile() {
        DescriptionManager.instance().showDescriptionDialog("CONVERSION_RESULTS_PANEL");
    }

    private void closeReportPanel() {
        this.messages = null;
        this.messages_byJobId = null;
        this.action_messages = null;
        this.action_messages_byJobId = null;
        this.fireNavegationEvent(TextManager.instance().get("MAIN_NAVIGATION_CLOSE_STR"));
    }

    public void export2File() {
        String timeStamp = GlobalFunctions.getCurrentDateByFormat((String)"yyyyMMddHHmmss");
        Object file_name = Globs.FULL_REPORT_FILE_NAME + timeStamp + ".xls";
        if (this.viewMode == VIEW_MODE_BY_ACTION) {
            file_name = Globs.ACTION_REPORT_FILE_NAME + timeStamp + ".xls";
        }
        if (this.reportType > REPORT_TYPE_CONVERSION) {
            file_name = this.exportFileName + timeStamp + ".xls";
        }
        JFileChooser fileChooser = new JFileChooser();
        FileNameExtensionFilter extFilter = new FileNameExtensionFilter("Excel files", ".xls");
        fileChooser.setFileFilter(extFilter);
        fileChooser.setFileSelectionMode(0);
        File exportFile = new File((String)file_name);
        fileChooser.setSelectedFile(exportFile);
        int rVal = fileChooser.showDialog(FlowManager.instance().getMainFrame(), TextManager.instance().get("CONVERSION_REPORT_EXPORT_TO_FILE_DIALOG_TITLE"));
        if (rVal == 0) {
            boolean result;
            file_name = fileChooser.getSelectedFile().toString();
            if (!((String)file_name).endsWith(".csv")) {
                ((String)file_name).concat(".csv");
            }
            if (!(result = this.export2Excel(exportFile = new File((String)file_name)))) {
                String message = TextManager.instance().get("CONVERSION_REPORT_FAILED_TO_CREATE_CSV_FILE") + " " + fileChooser.getCurrentDirectory().toString() + Globs.DIRSEP + (String)file_name;
                BaseMessageDialog.showMessageDialog((String)TextManager.instance().get("CONVERSION_REPORT_TITLE"), (String)message, (BaseMessageDialog.TYPE)BaseMessageDialog.TYPE.ERROR_MESSAGE);
            }
        }
    }

    private boolean export2Excel(File exportFile) {
        int i = 0;
        int j = 0;
        String fileName = exportFile.toString().replace(".csv", ".xls");
        HSSFWorkbook workbook = new HSSFWorkbook();
        this.initializeStyles((Workbook)workbook);
        int summaryIndent = 1;
        int rowIndex = 1;
        Sheet messagesSummarySheet = workbook.createSheet("Messages Summary");
        DefaultMutableTreeNode messagesRoot = this.reportTreePanelBy[VIEW_MODE_BY_RESULT].getRootNode();
        rowIndex = this.writeNodeHeader(messagesSummarySheet, (DefaultMutableTreeNode)messagesRoot.getChildAt(0), VIEW_MODE_BY_RESULT, rowIndex, summaryIndent);
        for (int index = 0; index < messagesRoot.getChildCount(); ++index) {
            rowIndex = this.writeNodeDetails(messagesSummarySheet, (DefaultMutableTreeNode)messagesRoot.getChildAt(index), VIEW_MODE_BY_RESULT, rowIndex, summaryIndent);
        }
        rowIndex = this.writeNodeSummary(messagesSummarySheet, messagesRoot, VIEW_MODE_BY_RESULT, rowIndex, summaryIndent);
        messagesSummarySheet.setColumnWidth(1, 4000);
        messagesSummarySheet.setColumnWidth(2, 4000);
        messagesSummarySheet.setColumnWidth(3, 4000);
        messagesSummarySheet.setColumnWidth(4, 12000);
        rowIndex = 2;
        Sheet actionsSummarySheet = workbook.createSheet("Actions Summary");
        DefaultMutableTreeNode actionRoot = this.reportTreePanelBy[VIEW_MODE_BY_ACTION].getRootNode();
        rowIndex = this.writeNodeHeader(actionsSummarySheet, actionRoot, VIEW_MODE_BY_ACTION, rowIndex, summaryIndent);
        rowIndex = this.writeNodeDetails(actionsSummarySheet, actionRoot, VIEW_MODE_BY_ACTION, rowIndex, summaryIndent);
        rowIndex = this.writeNodeSummary(actionsSummarySheet, actionRoot, VIEW_MODE_BY_ACTION, rowIndex, summaryIndent);
        actionsSummarySheet.setColumnWidth(1, 4000);
        actionsSummarySheet.setColumnWidth(2, 4000);
        actionsSummarySheet.setColumnWidth(3, 4000);
        i = 0;
        Sheet messagesSheet = workbook.createSheet("Messages");
        this.writeRecord(messagesSheet, this.fullReportAttrArray, i);
        for (JobMessage jobMessage : this.messages.values()) {
            String[] record = new String[this.fullReportAttrArray.length];
            j = 0;
            record[j++] = Integer.toString(++i);
            record[j++] = jobMessage.getMessageJobId();
            record[j++] = jobMessage.getMessageID();
            record[j++] = jobMessage.getMessageType();
            record[j++] = jobMessage.getMessageVendor();
            record[j++] = jobMessage.getMessageStatus();
            record[j++] = jobMessage.getMessageText();
            record[j++] = jobMessage.getMessageExtendedText();
            if (i > 65000) {
                messagesSheet = this.updateSheetName((Workbook)workbook, messagesSheet);
                i = 1;
            }
            this.writeRecord(messagesSheet, record, i);
        }
        i = 0;
        Sheet actionsSheet = workbook.createSheet("Actions");
        this.writeRecord(actionsSheet, this.actionReportAttrArray, i);
        for (ActionMessage message : this.action_messages.values()) {
            String[] record = new String[this.actionReportAttrArray.length];
            j = 0;
            record[j++] = Integer.toString(++i);
            record[j++] = message.getActionJobId();
            record[j++] = message.getActionEntityType();
            record[j++] = message.getActionEntityName();
            record[j++] = message.getActionStatus();
            if (message.getActionEntityType().equals("QR")) {
                record[j++] = message.getActionQty();
            }
            if (message.getActionEntityType().equals("JOB")) {
                record[j++] = message.getActionDescription();
            }
            if (i > 65000) {
                actionsSheet = this.updateSheetName((Workbook)workbook, actionsSheet);
                i = 1;
            }
            this.writeRecord(actionsSheet, record, i);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(fileName);
            workbook.write((OutputStream)fileOutputStream);
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            ExceptionHandler.writeToExceptionFile((Exception)fileNotFoundException);
        }
        catch (IOException iOException) {
            ExceptionHandler.writeToExceptionFile((Exception)iOException);
        }
        return true;
    }

    private Sheet updateSheetName(Workbook workbook, Sheet sheet) {
        String sheetName;
        Pattern pattern = Pattern.compile("^.*?(\\d+)$");
        Matcher nameMatcher = pattern.matcher(sheetName = sheet.getSheetName());
        if (!nameMatcher.matches()) {
            workbook.setSheetName(workbook.getSheetIndex(sheet), sheetName + " 1");
            sheetName = sheet.getSheetName();
            nameMatcher = pattern.matcher(sheetName);
        }
        if (nameMatcher.matches()) {
            sheetName = sheetName.replace(nameMatcher.group(1), String.valueOf(Integer.valueOf(nameMatcher.group(1)) + 1));
        }
        sheet = workbook.createSheet(sheetName);
        this.writeRecord(sheet, this.fullReportAttrArray, 0);
        return sheet;
    }

    private void initializeStyles(Workbook workbook) {
        this.exportedExcelStyles = new HashMap<ExcelStyleType, CellStyle>();
        CellStyle headerMiddle = workbook.createCellStyle();
        headerMiddle.setBorderTop((short)5);
        headerMiddle.setBorderBottom((short)5);
        Font headerFont = workbook.createFont();
        headerFont.setBoldweight((short)700);
        headerMiddle.setFont(headerFont);
        this.exportedExcelStyles.put(ExcelStyleType.HeaderMiddle, headerMiddle);
        CellStyle headerLeft = workbook.createCellStyle();
        headerLeft.cloneStyleFrom(headerMiddle);
        headerLeft.setBorderLeft((short)5);
        this.exportedExcelStyles.put(ExcelStyleType.HeaderLeft, headerLeft);
        CellStyle headerRight = workbook.createCellStyle();
        headerRight.cloneStyleFrom(headerMiddle);
        headerRight.setBorderRight((short)5);
        this.exportedExcelStyles.put(ExcelStyleType.HeaderRight, headerRight);
        CellStyle headerNumber = workbook.createCellStyle();
        headerNumber.cloneStyleFrom(headerMiddle);
        headerNumber.setAlignment((short)3);
        headerNumber.setIndention((short)1);
        this.exportedExcelStyles.put(ExcelStyleType.HeaderNumber, headerNumber);
        CellStyle recordMiddle = workbook.createCellStyle();
        this.exportedExcelStyles.put(ExcelStyleType.RecordMiddle, recordMiddle);
        CellStyle recordLeft = workbook.createCellStyle();
        recordLeft.cloneStyleFrom(recordMiddle);
        recordLeft.setBorderLeft((short)5);
        recordLeft.setFont(headerFont);
        this.exportedExcelStyles.put(ExcelStyleType.RecordLeft, recordLeft);
        CellStyle recordRight = workbook.createCellStyle();
        recordRight.cloneStyleFrom(recordMiddle);
        recordRight.setBorderRight((short)5);
        this.exportedExcelStyles.put(ExcelStyleType.RecordRight, recordRight);
        CellStyle recordNumber = workbook.createCellStyle();
        recordNumber.cloneStyleFrom(recordMiddle);
        recordNumber.setAlignment((short)3);
        recordNumber.setIndention((short)1);
        this.exportedExcelStyles.put(ExcelStyleType.RecordNumber, recordNumber);
        CellStyle summaryMiddle = workbook.createCellStyle();
        summaryMiddle.setBorderBottom((short)1);
        summaryMiddle.setFont(headerFont);
        this.exportedExcelStyles.put(ExcelStyleType.SummaryMiddle, summaryMiddle);
        CellStyle summaryLeft = workbook.createCellStyle();
        summaryLeft.cloneStyleFrom(summaryMiddle);
        summaryLeft.setBorderLeft((short)5);
        this.exportedExcelStyles.put(ExcelStyleType.SummaryLeft, summaryLeft);
        CellStyle summaryRight = workbook.createCellStyle();
        summaryRight.cloneStyleFrom(summaryMiddle);
        summaryRight.setBorderRight((short)5);
        this.exportedExcelStyles.put(ExcelStyleType.SummaryRight, summaryRight);
        CellStyle summaryNumber = workbook.createCellStyle();
        summaryNumber.cloneStyleFrom(summaryMiddle);
        summaryNumber.setAlignment((short)3);
        summaryNumber.setIndention((short)1);
        this.exportedExcelStyles.put(ExcelStyleType.SummaryNumber, summaryNumber);
    }

    private int writeNodeHeader(Sheet sheet, DefaultMutableTreeNode node, int summaryType, int rowIndex, int indent) {
        TopPanelModel model = new TopPanelModel(summaryType, node, this);
        ArrayList<String> header = new ArrayList<String>();
        for (int column = 0; column < model.getColumnCount(); ++column) {
            header.add(model.getColumnName(column));
        }
        header.set(0, "Type");
        this.writeRecord(sheet, header.toArray(new String[0]), rowIndex++, indent, ExcelLineType.Header);
        return rowIndex;
    }

    private int writeNodeSummary(Sheet sheet, DefaultMutableTreeNode node, int summaryType, int rowIndex, int indent) {
        TopPanelModel model = new TopPanelModel(summaryType, node, this);
        ArrayList<String> summary = new ArrayList<String>();
        for (int column = 0; column < model.getColumnCount(); ++column) {
            summary.add((String)model.getValueAt(model.getRowCount() - 1, column));
        }
        this.writeRecord(sheet, summary.toArray(new String[0]), rowIndex++, indent, ExcelLineType.Header);
        return rowIndex;
    }

    private int writeNodeDetails(Sheet sheet, DefaultMutableTreeNode node, int summaryType, int rowIndex, int indent) {
        TopPanelModel model = new TopPanelModel(summaryType, node, this);
        for (int row = 0; row < model.getRowCount(); ++row) {
            ArrayList<String> rowData = new ArrayList<String>();
            for (int column = 0; column < model.getColumnCount(); ++column) {
                rowData.add((String)model.getValueAt(row, column));
            }
            if (row == 0) {
                rowData.set(0, node.toString());
            } else if (row == model.getRowCount() - 1) {
                rowData.remove(1);
                rowData.add(0, "");
            } else {
                rowData.set(0, "");
            }
            if (summaryType == VIEW_MODE_BY_ACTION && row == model.getRowCount() - 1) continue;
            this.writeRecord(sheet, rowData.toArray(new String[0]), rowIndex++, indent, row == model.getRowCount() - 1 ? ExcelLineType.Summary : ExcelLineType.Record);
        }
        return rowIndex;
    }

    private void writeRecord(Sheet sheet, String[] record, int rowIndex) {
        this.writeRecord(sheet, record, rowIndex, 0, null);
    }

    private void writeRecord(Sheet sheet, String[] record, int rowIndex, int indent, ExcelLineType lineType) {
        int index;
        Row row = sheet.createRow(rowIndex);
        for (index = 0; index < indent; ++index) {
            row.createCell(index);
        }
        for (index = 0; index < record.length; ++index) {
            Integer numericValue = null;
            try {
                numericValue = Integer.valueOf(record[index]);
            }
            catch (NumberFormatException e) {
                numericValue = null;
            }
            Cell excelCell = row.createCell(index + indent);
            if (numericValue == null) {
                excelCell.setCellValue(record[index]);
            } else {
                excelCell.setCellValue((double)numericValue.intValue());
            }
            CellStyle cellStyle = null;
            if (lineType == null) continue;
            switch (lineType.ordinal()) {
                case 0: {
                    if (index == 0) {
                        cellStyle = this.exportedExcelStyles.get((Object)ExcelStyleType.HeaderLeft);
                        break;
                    }
                    if (index == record.length - 1) {
                        cellStyle = this.exportedExcelStyles.get((Object)ExcelStyleType.HeaderRight);
                        break;
                    }
                    if (numericValue != null) {
                        cellStyle = this.exportedExcelStyles.get((Object)ExcelStyleType.HeaderNumber);
                        break;
                    }
                    cellStyle = this.exportedExcelStyles.get((Object)ExcelStyleType.HeaderMiddle);
                    break;
                }
                case 2: {
                    if (index == 0) {
                        cellStyle = this.exportedExcelStyles.get((Object)ExcelStyleType.SummaryLeft);
                        break;
                    }
                    if (index == record.length - 1) {
                        cellStyle = this.exportedExcelStyles.get((Object)ExcelStyleType.SummaryRight);
                        break;
                    }
                    if (numericValue != null) {
                        cellStyle = this.exportedExcelStyles.get((Object)ExcelStyleType.SummaryNumber);
                        break;
                    }
                    cellStyle = this.exportedExcelStyles.get((Object)ExcelStyleType.SummaryMiddle);
                    break;
                }
                case 1: {
                    if (index == 0) {
                        cellStyle = this.exportedExcelStyles.get((Object)ExcelStyleType.RecordLeft);
                        break;
                    }
                    if (index == record.length - 1) {
                        cellStyle = this.exportedExcelStyles.get((Object)ExcelStyleType.RecordRight);
                        break;
                    }
                    if (numericValue != null) {
                        cellStyle = this.exportedExcelStyles.get((Object)ExcelStyleType.RecordNumber);
                        break;
                    }
                    cellStyle = this.exportedExcelStyles.get((Object)ExcelStyleType.RecordMiddle);
                    break;
                }
            }
            if (cellStyle == null) continue;
            excelCell.setCellStyle(cellStyle);
        }
    }

    private void openFindWindow() {
    }

    private void openZoomWindow() {
    }

    private void setViewBy(Integer view) {
        if (this.viewMode == view) {
            return;
        }
        this.viewMode = view;
        if (this.reportType != REPORT_TYPE_EMBEDDED) {
            if (this.view_By_Result != null) {
                this.view_By_Result.setSelected(this.viewMode == VIEW_MODE_BY_RESULT);
            }
            if (this.view_By_Job != null) {
                this.view_By_Job.setSelected(this.viewMode == VIEW_MODE_BY_JOB);
            }
            if (this.view_By_Action != null) {
                this.view_By_Action.setSelected(this.viewMode == VIEW_MODE_BY_ACTION);
            }
            String title = this.reportTitle + " - ";
            if (this.viewMode == VIEW_MODE_BY_RESULT) {
                title = title + TextManager.instance().get("CONVERSION_REPORT_VIEW_BY_MESSAGE_TYPE");
            } else if (this.viewMode == VIEW_MODE_BY_JOB && this.reportType != REPORT_TYPE_VALIDATION) {
                title = title + TextManager.instance().get("CONVERSION_REPORT_VIEW_BY_JOB");
            } else if (this.viewMode == VIEW_MODE_BY_ACTION) {
                title = title + TextManager.instance().get("CONVERSION_REPORT_VIEW_BY_ACTION");
            }
            this.setPanelTitle(title);
            this.setContentPanel(this.contentByView[view]);
        }
    }

    protected void setPanelTitle(String title) {
        ConversionReportManager.instance().setTitle(title);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.reportTreePanelBy[this.viewMode].updateUI();
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.reportTreePanelBy[this.viewMode].getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        this.lastSelectedTreeNode = node;
        Object nodeInfo = node.getUserObject();
        if (node.isLeaf() && node.getLevel() > CustomRenderer.leafLevel[this.viewMode] - 1) {
            DefaultMutableTreeNode parentInfo = (DefaultMutableTreeNode)node.getParent();
            this.updateCenterPanel(parentInfo.getUserObject().toString(), nodeInfo.toString());
        } else {
            this.updateCenterPanel(node);
        }
    }

    public void navegationActionPerformed(ConversionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals(TextManager.instance().get("MAIN_NAVIGATION_CLOSE_STR"))) {
            this.closeReportPanel();
        } else if (actionCommand.equals(TextManager.instance().get("MAIN_NAVIGATION_HELP_STR"))) {
            this.showHelpFile();
        }
    }

    public String getActionPARAMS(String actiontType, String entity_name) {
        SortedMap<String, ActionMessage> sub_list = null;
        String from_key = "";
        String to_key = "";
        from_key = String.format("%s%s%s%s", actiontType.toString(), "|", entity_name.toString(), "|");
        to_key = String.format("%s%s%s%s%c", actiontType.toString(), "|", entity_name.toString(), "|", Character.valueOf('\uffff'));
        sub_list = this.action_messages.subMap(from_key, to_key);
        if (sub_list.size() != 0) {
            ActionMessage list_entry = (ActionMessage)sub_list.get(sub_list.firstKey());
            return list_entry.getActionAttr("ACTPARAMETERS");
        }
        return "";
    }

    private static enum ExcelStyleType {
        HeaderLeft,
        HeaderRight,
        HeaderMiddle,
        HeaderNumber,
        RecordLeft,
        RecordRight,
        RecordMiddle,
        RecordNumber,
        SummaryLeft,
        SummaryRight,
        SummaryMiddle,
        SummaryNumber;

    }

    private static enum ExcelLineType {
        Header,
        Record,
        Summary;

    }
}

