/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.gui.flowpanels;

import com.bmc.ctmconvert.ConversionSaveResults;
import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.BaseContentPanel;
import com.bmc.ctmconvert.base.BaseDialog;
import com.bmc.ctmconvert.base.BaseNavigationPanel;
import com.bmc.ctmconvert.base.BaseProgressBar;
import com.bmc.ctmconvert.base.BaseSection;
import com.bmc.ctmconvert.base.ButtonFactory;
import com.bmc.ctmconvert.base.ConversionEvent;
import com.bmc.ctmconvert.base.DataImportVendor;
import com.bmc.ctmconvert.base.NavegationListener;
import com.bmc.ctmconvert.base.ValidityListener;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.dataimport.ImportEntryList;
import com.bmc.ctmconvert.gui.dataimport.DefaultDataImport;
import com.bmc.ctmconvert.gui.dataimport.DefaultDataImportFactory;
import com.bmc.ctmconvert.gui.flow.FlowManager;
import com.bmc.ctmconvert.gui.flowpanels.FlowPanel;
import com.bmc.ctmconvert.services.ConversionEntitiesService;
import com.bmc.ctmconvert.services.VendorDataManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.SwingWorker;
import javax.swing.border.Border;

public class DataImportDialog
extends FlowPanel {
    private static DataImportDialog instance;
    private static BaseDialog dataImportDialog;
    private DataImportVendor dataImportVendor;
    private BaseSection importDataSection;
    private BaseNavigationPanel navigationPanel;
    private static Task task;
    private BaseProgressBar progressBar;
    private static FlowGlobals.COMPLETION_MODE dataImportEndedStatus;
    private static Properties projectProperties;
    private static boolean tryImport;
    private ImportEntryList entries;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean viewDataImportDialog() {
        tryImport = false;
        task = null;
        Dimension size = VendorDataManager.instance().getDataImportDialogSize(Params.instance().getVendorName());
        dataImportDialog = new BaseDialog(FlowManager.instance().getMainFrame(), TextManager.instance().get("DATA_IMPORT_DIALOG_WINDOW_TITLE"), size);
        projectProperties = Params.instance().getProjectProperties();
        instance = new DataImportDialog();
        dataImportDialog.setContent((BaseComponent)instance);
        dataImportDialog.addNavegationListener((NavegationListener)instance);
        dataImportDialog.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                instance.setFocusComponent();
            }
        });
        dataImportDialog.setVisible(true);
        if (task != null) {
            try {
                Task task = DataImportDialog.task;
                synchronized (task) {
                    DataImportDialog.task.wait();
                }
            }
            catch (InterruptedException e1) {
                ExceptionHandler.writeToExceptionFile((Exception)e1);
            }
        }
        return tryImport;
    }

    private DataImportDialog() {
        dataImportEndedStatus = null;
        this.dataImportVendor = VendorDataManager.instance().getDataImport(projectProperties.getProperty("VENDOR"));
        if (this.dataImportVendor == null) {
            this.entries = VendorDataManager.instance().getVendorData(projectProperties.getProperty("VENDOR")).getImportEntries();
            if (this.entries != null) {
                DefaultDataImportFactory factory = new DefaultDataImportFactory();
                this.dataImportVendor = factory.getDataImport(this.entries);
            }
        }
        if (this.dataImportVendor == null) {
            dataImportEndedStatus = FlowGlobals.COMPLETION_MODE.FAILURE;
        } else {
            this.navigationPanel = new BaseNavigationPanel(new ButtonFactory.ButtonType[]{ButtonFactory.ButtonType.BACK, ButtonFactory.ButtonType.NEXT, ButtonFactory.ButtonType.IMPORT_DATA, ButtonFactory.ButtonType.CANCEL});
            this.navigationPanel.addValidityType(ButtonFactory.ButtonType.IMPORT_DATA);
            this.navigationPanel.setEnabled(ButtonFactory.ButtonType.IMPORT_DATA, false);
            this.setNavigationPanel(this.navigationPanel);
            this.baseContentPanel = this.dataImportVendor.getNextPanel();
            this.setNextPanel(this.baseContentPanel);
            Dimension size = this.dataImportVendor.getSize();
            if (size != null) {
                dataImportDialog.setSize(size);
            }
        }
    }

    @Override
    public void setContentPanel(BaseContentPanel baseContentPanel) {
        super.setContentPanel(baseContentPanel);
        baseContentPanel.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(9, 10, 0, 9), FlowGlobals.customLowerBorder));
    }

    @Override
    public void navegationActionPerformed(ConversionEvent e) {
        if (e.getActionCommand().equals(TextManager.instance().get("MAIN_NAVIGATION_CANCEL_STR")) || e.getActionCommand().equals(TextManager.instance().get("MAIN_NAVIGATION_CLOSE_STR"))) {
            dataImportDialog.dispose();
        } else if (e.getActionCommand().equals(TextManager.instance().get("MAIN_NAVIGATION_IMPORT"))) {
            boolean doImport = false;
            try {
                if (((DefaultDataImport)this.dataImportVendor).isImportable()) {
                    doImport = true;
                }
            }
            catch (ClassCastException e1) {
                doImport = true;
            }
            if (doImport) {
                tryImport = true;
                this.importData();
            }
        } else {
            super.navegationActionPerformed(e);
        }
    }

    public void setFocusComponent() {
        Component defaultFocusedComponent = this.dataImportVendor.getDefaultFocusedComponent();
        if (defaultFocusedComponent != null) {
            defaultFocusedComponent.requestFocus();
        }
    }

    public static FlowGlobals.COMPLETION_MODE getEndedStatus() {
        return dataImportEndedStatus;
    }

    @Override
    public boolean eligibleForNext() {
        return this.dataImportVendor.eligibleForNext();
    }

    @Override
    public boolean performNextOperation() {
        BaseContentPanel nextPanel = this.dataImportVendor.getNextPanel();
        if (this.dataImportVendor.eligibleForNext() && nextPanel != null) {
            this.setNextPanel(nextPanel);
        }
        return false;
    }

    private void setNextPanel(BaseContentPanel nextPanel) {
        nextPanel.getBaseTitlePanel().setTitle(String.format(TextManager.instance().get("DATA_IMPORT_DIALOG_PANEL_TITLE_FORMAT"), VendorDataManager.instance().getVendorData(Params.instance().getVendorName()).getDisplayName()));
        nextPanel.addValidityListener((ValidityListener)this);
        this.setContentPanel(nextPanel);
        this.setNavigationPanelButtons();
        this.setValid(nextPanel.isValid());
        this.setFocusComponent();
    }

    private void setNavigationPanelButtons() {
        switch (this.dataImportVendor.getImportPosition()) {
            case START: {
                this.navigationPanel.setVisible(ButtonFactory.ButtonType.BACK, false);
                this.navigationPanel.setVisible(ButtonFactory.ButtonType.NEXT, true);
                this.navigationPanel.setVisible(ButtonFactory.ButtonType.IMPORT_DATA, false);
                break;
            }
            case MIDDLE: {
                this.navigationPanel.setVisible(ButtonFactory.ButtonType.BACK, true);
                this.navigationPanel.setVisible(ButtonFactory.ButtonType.NEXT, true);
                this.navigationPanel.setVisible(ButtonFactory.ButtonType.IMPORT_DATA, false);
                break;
            }
            case END: {
                this.navigationPanel.setVisible(ButtonFactory.ButtonType.BACK, true);
                this.navigationPanel.setVisible(ButtonFactory.ButtonType.NEXT, false);
                this.navigationPanel.setVisible(ButtonFactory.ButtonType.IMPORT_DATA, true);
                break;
            }
            default: {
                this.navigationPanel.setVisible(ButtonFactory.ButtonType.BACK, false);
                this.navigationPanel.setVisible(ButtonFactory.ButtonType.NEXT, false);
                this.navigationPanel.setVisible(ButtonFactory.ButtonType.IMPORT_DATA, true);
            }
        }
    }

    public boolean importData() {
        this.alerts.init();
        this.cleanProjectDirectory();
        try {
            VendorDataManager.destroy();
            if ((DefaultDataImport)this.dataImportVendor != null) {
                this.entries.writeToUserFile();
                dataImportEndedStatus = this.dataImportVendor.performDataImport(ConversionEntitiesService.getCurrentProjectDataDirectory(), null);
                this.taskDone();
                dataImportDialog.dispose();
            }
        }
        catch (ClassCastException e1) {
            task = new Task();
            this.progressBar = new BaseProgressBar(TextManager.instance().get("CAPTURE_DATA_IMPORT_ENDED_DIALOG_TITLE"), (SwingWorker)task);
            task.execute();
            dataImportDialog.dispose();
            this.progressBar.setVisible(true);
        }
        return dataImportEndedStatus == FlowGlobals.COMPLETION_MODE.SUCCESS;
    }

    @Override
    public boolean performPrevOperation() {
        BaseContentPanel prevPanel = this.dataImportVendor.getPrevPanel();
        this.setContentPanel(prevPanel);
        this.setValid(prevPanel.isValid());
        this.setNavigationPanelButtons();
        return false;
    }

    @Override
    public boolean updateData() {
        if (this.dataImportVendor.isComplexPanel() && this.dataImportVendor.updateData()) {
            this.performPrevOperation();
        }
        if (this.importDataSection != null) {
            this.importDataSection.isValid();
        }
        return true;
    }

    @Override
    public FlowGlobals.FlowPanels getPanelType() {
        return FlowGlobals.FlowPanels.DATA_IMPORT;
    }

    public void cleanProjectDirectory() {
        String conversionsPath;
        ConversionEntitiesService.unregisterConversion((String)ConversionEntitiesService.getCurrentProjectName());
        String dataPath = ConversionEntitiesService.getCurrentProjectDataDirectory();
        if (dataPath != null && !dataPath.isEmpty()) {
            GlobalFunctions.deleteDir((File)new File(dataPath), (boolean)false);
        }
        if ((conversionsPath = ConversionEntitiesService.getCurrentProjectConversionsDirectory()) != null && !conversionsPath.isEmpty()) {
            GlobalFunctions.deleteDir((File)new File(conversionsPath), (boolean)true);
        }
    }

    private void taskDone() {
        FlowManager.instance().isImportPerformed(true);
        if (dataImportEndedStatus != FlowGlobals.COMPLETION_MODE.SUCCESS) {
            this.cleanProjectDirectory();
        } else if (Params.instance().isValidationProject()) {
            ConversionSaveResults csr = new ConversionSaveResults(ConversionEntitiesService.getCurrentProjectName(), "", file -> true);
            try {
                csr.createConversionFolder();
            }
            catch (Exception e) {
                ConversionLogger.getLogger().severe("Unable to create conversion folder: " + e.getMessage());
                dataImportEndedStatus = FlowGlobals.COMPLETION_MODE.FAILURE;
            }
        }
        Params.instance().setIsImportComplete(dataImportEndedStatus == FlowGlobals.COMPLETION_MODE.SUCCESS);
        Params.instance().saveProjectProperties();
    }

    @Override
    public String getHelpTitle() {
        return this.dataImportVendor.getHelpTitle();
    }

    private class Task
    extends SwingWorker<Void, Void> {
        private Task() {
        }

        @Override
        public Void doInBackground() {
            DataImportDialog.this.progressBar.setLabel(TextManager.instance().get("DATA_IMPORT_STRATED_PROGERSS_BAR_STATUS"));
            DataImportDialog.this.progressBar.setProgressValue(0);
            String dataSourcePath = Params.instance().getDatasourcePath();
            if (dataSourcePath != null && !dataSourcePath.isEmpty()) {
                try {
                    dataImportEndedStatus = DataImportDialog.this.dataImportVendor.performDataImport(dataSourcePath + Globs.DIRSEP, DataImportDialog.this.progressBar);
                }
                catch (Exception e) {
                    dataImportEndedStatus = FlowGlobals.COMPLETION_MODE.FAILURE;
                    DataImportDialog.this.alerts.addMessage(GlobalFunctions.getStackTraceStringFromException((Throwable)e));
                    ExceptionHandler.writeToExceptionFile((Exception)e);
                }
            } else {
                dataImportEndedStatus = FlowGlobals.COMPLETION_MODE.FAILURE;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void done() {
            if (this.isCancelled()) {
                dataImportEndedStatus = FlowGlobals.COMPLETION_MODE.ABORTED;
            } else if (dataImportEndedStatus == null) {
                dataImportEndedStatus = FlowGlobals.COMPLETION_MODE.FAILURE;
            }
            DataImportDialog.this.taskDone();
            Task task = DataImportDialog.task;
            synchronized (task) {
                DataImportDialog.task.notifyAll();
            }
            if (DataImportDialog.this.progressBar != null) {
                DataImportDialog.this.progressBar.dispose();
            }
        }
    }
}

