/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.gui.flow;

import com.bmc.ctmconvert.base.AbstractAssessmentReport;
import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.BaseContentPanel;
import com.bmc.ctmconvert.base.BaseFrame;
import com.bmc.ctmconvert.base.BasePanel;
import com.bmc.ctmconvert.base.BaseProgressBar;
import com.bmc.ctmconvert.base.ConversionEvent;
import com.bmc.ctmconvert.base.NavegationListener;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.ProcessAlertsManager;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.common.exceptions.NoJobsFoundException;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.services.VendorDataManager;

public class AssessmentReportsManager {
    private static AssessmentReportsManager instance;
    private BaseFrame assessmentsWindow;
    private BasePanel report;
    private boolean loadAborted = true;

    public static AssessmentReportsManager instance() {
        if (instance == null) {
            instance = new AssessmentReportsManager();
        }
        return instance;
    }

    public static void destroy() {
        instance = null;
    }

    private BasePanel getReport() {
        this.report = null;
        final BaseProgressBar progressBar = new BaseProgressBar(TextManager.instance().get("TITLE_ASSESSMENT_REPORT"));
        progressBar.setLabel(TextManager.instance().get("LOADING_ASSESSMENT_REPORT"));
        progressBar.setSnakeLook(true);
        Thread loadAssessment = new Thread(){

            @Override
            public void run() {
                try {
                    AssessmentReportsManager.this.report = VendorDataManager.instance().getAssessmentReport(Params.instance().getVendorName(), Params.instance().getDatasourcePath());
                    if (AssessmentReportsManager.this.report instanceof AbstractAssessmentReport) {
                        AbstractAssessmentReport aReport = (AbstractAssessmentReport)AssessmentReportsManager.this.report;
                        aReport.init();
                    }
                    AssessmentReportsManager.this.report.getContentPanel().setScrollable(false);
                }
                catch (NoJobsFoundException e) {
                    ProcessAlertsManager.instance().addMessage(e.getMessage());
                }
                catch (Exception e) {
                    Object message = TextManager.instance().get("ASSESSMENT_REPORT_UNEXPECTED_EXCEPTOIN");
                    message = String.format((String)message, Character.valueOf('\n'), Character.valueOf('\n'));
                    String stackTraceStringFromException = GlobalFunctions.getStackTraceStringFromException((Throwable)e);
                    if (e.getMessage() != null && e.getMessage().contains("byte")) {
                        message = (String)message + TextManager.instance().get("ASSESSMENT_REPORT_SELF_HANDLING");
                        message = String.format((String)message, Character.valueOf('\n'), Character.valueOf('\n'), Character.valueOf('\n'), Character.valueOf('\n'), Character.valueOf('\n'), Character.valueOf('\n'), Character.valueOf('\n'), Character.valueOf('\n'), Character.valueOf('\n'), Character.valueOf('\n'), Character.valueOf('\n'));
                    }
                    String fullMessage = "Unable to view assessment report.\n" + (String)message + "\nOriginal message: " + stackTraceStringFromException;
                    ProcessAlertsManager.instance().addMessage(fullMessage);
                    ConversionLogger.getLogger().severe(fullMessage);
                    ExceptionHandler.writeToExceptionFile((Exception)e);
                    AssessmentReportsManager.this.loadAborted = false;
                }
                progressBar.dispose();
            }
        };
        loadAssessment.start();
        progressBar.setVisible(true);
        if (progressBar.isCancelled()) {
            loadAssessment.stop();
            this.loadAborted = true;
        }
        return this.report;
    }

    public boolean isReportAborted() {
        return this.loadAborted;
    }

    public BaseContentPanel getEmbeddedAssessmentReport() {
        BasePanel reportPanel = this.getReport();
        BaseContentPanel report = null;
        if (reportPanel != null && (report = reportPanel.getContentPanel()) != null) {
            report.setBorder(null);
        }
        return report;
    }

    public void viewAssessmentReportWindow() {
        if (this.assessmentsWindow != null) {
            this.assessmentsWindow.dispose();
        }
        this.assessmentsWindow = new BaseFrame();
        BasePanel report = this.getReport();
        if (report != null) {
            NavegationListener close = new NavegationListener(){

                public void navegationActionPerformed(ConversionEvent e) {
                    if (e.getActionCommand().equals(TextManager.instance().get("MAIN_NAVIGATION_CLOSE_STR"))) {
                        AssessmentReportsManager.this.assessmentsWindow.dispose();
                    }
                }
            };
            report.addNavegationListener(close);
            this.assessmentsWindow.addNavegationListener(close);
            this.assessmentsWindow.setTitle(TextManager.instance().get("TITLE_ASSESSMENT_REPORT") + " - " + Params.instance().getDatasourceName() + " (" + Params.instance().getVendorName() + ")");
            this.assessmentsWindow.setContent((BaseComponent)report);
            this.assessmentsWindow.setVisible(true);
        }
    }

    public void closeOperation() {
        if (this.assessmentsWindow != null) {
            this.assessmentsWindow.dispose();
        }
    }
}

