/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.connect_direct.reader;

import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.connect_direct.data.ErrorDataParseError;
import com.bmc.ctmconvert.connect_direct.data.ProcessHeader;
import com.bmc.ctmconvert.connect_direct.data.Statement;
import com.bmc.ctmconvert.connect_direct.reader.CDProcessFileListener;
import com.bmc.ctmconvert.connect_direct.reader.CDProcessFileParser;
import com.bmc.ctmconvert.dataObject.AbstractData;
import com.bmc.ctmconvert.dataObject.Data;
import com.bmc.ctmconvert.dataObject.DataEntity;
import com.bmc.ctmconvert.dataObject.DataObject;
import com.bmc.ctmconvert.dataObject.IAttribute;
import com.bmc.ctmconvert.dataObject.entities.Attribute;
import com.bmc.ctmconvert.dataObject.entities.InMemoryDataObject;
import com.bmc.ctmconvert.services.ConversionEntitiesService;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import org.antlr.v4.runtime.misc.ParseCancellationException;

public class ProcessStorer {
    private DataObject dataObject = new InMemoryDataObject();

    public DataObject getDataObject() {
        return this.dataObject;
    }

    public void storeProcessesData(Path processFilePath, InputStream processStream) {
        CDProcessFileListenerImplementation listener = this.getListener();
        CDProcessFileParser parser = this.getParser(listener);
        try {
            parser.parse(processStream);
            ProcessHeader header = listener.getProcessHeader();
            this.addFilenameToData(processFilePath, header);
        }
        catch (IOException e) {
            ErrorDataParseError errorData = new ErrorDataParseError(processFilePath.toAbsolutePath().toString());
            this.dataObject.store((Data)errorData);
            throw new RuntimeException(e);
        }
        catch (ParseCancellationException e) {
            ConversionLogger.getLogger().warning(String.format("Failed to parse file: %s", processFilePath.toString()));
            ErrorDataParseError errorData = new ErrorDataParseError(processFilePath.toAbsolutePath().toString());
            this.dataObject.store((Data)errorData);
        }
    }

    CDProcessFileParser getParser(CDProcessFileListener listener) {
        return new CDProcessFileParser(listener);
    }

    private CDProcessFileListenerImplementation getListener() {
        return new CDProcessFileListenerImplementation();
    }

    private void addFilenameToData(Path processFile, AbstractData theData) {
        String originalFileName = processFile.getFileName().toString();
        Attribute attributeToAdd = Attribute.from((String)"process_file_name_with_extnsion", (String)originalFileName);
        theData.add((IAttribute)attributeToAdd);
        String extensionlessFileName = originalFileName;
        if (this.hasExtension(originalFileName)) {
            extensionlessFileName = this.dropExtension(originalFileName);
        }
        attributeToAdd = Attribute.from((String)"process_file_name", (String)extensionlessFileName);
        theData.add((IAttribute)attributeToAdd);
        attributeToAdd = Attribute.from((String)"process_full_path_to_file_in_project", (String)(ConversionEntitiesService.getCurrentProjectDataDirectory() + originalFileName));
        theData.add((IAttribute)attributeToAdd);
    }

    private String dropExtension(String originalFileName) {
        return originalFileName.substring(0, originalFileName.lastIndexOf(46));
    }

    private boolean hasExtension(String originalFileName) {
        return originalFileName.contains(".");
    }

    private final class CDProcessFileListenerImplementation
    implements CDProcessFileListener {
        private DataEntity parentEntity;
        private ProcessHeader process = null;

        private CDProcessFileListenerImplementation() {
        }

        @Override
        public void onProcessHeader(ProcessHeader header) {
            this.process = header;
            this.parentEntity = ProcessStorer.this.dataObject.store((Data)this.process);
        }

        @Override
        public void onStatement(Statement statement) {
            ProcessStorer.this.dataObject.store((Data)statement, this.parentEntity);
        }

        public ProcessHeader getProcessHeader() {
            return this.process;
        }
    }
}

