/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.connect_direct.data;

import com.bmc.ctmconvert.dataObject.AbstractData;
import com.bmc.ctmconvert.dataObject.IAttribute;
import com.bmc.ctmconvert.dataObject.entities.Attribute;
import java.util.Optional;

public class Statement
extends AbstractData {
    public Statement(String type, String originalText) {
        this(type, originalText, "");
    }

    public Statement(String type, String originalText, String label) {
        this.add((IAttribute)Attribute.from((String)"STATEMENT_TYPE", (String)type));
        this.addOriginalText(originalText);
        if (this.validLabel(label)) {
            this.add((IAttribute)Attribute.from((String)"STATEMENT_LABEL", (String)label));
        }
    }

    public Statement addLabel(String label) {
        return new Statement(this.getType(), this.getOriginalStatementText(), label);
    }

    private boolean validLabel(String label) {
        return label != null && !label.isEmpty();
    }

    public Optional<String> getLabel() {
        return this.getAttributes().findFirst("STATEMENT_LABEL");
    }

    public String getType() {
        return (String)this.getAttributes().findFirst("STATEMENT_TYPE").get();
    }

    public String getDataType() {
        return "STATEMENT";
    }

    private void addOriginalText(String originalStatementText) {
        this.add((IAttribute)Attribute.from((String)"ORIGINAL_TEXT", (String)originalStatementText));
    }

    public String getOriginalStatementText() {
        return (String)this.getAttributes().findFirst("ORIGINAL_TEXT").get();
    }
}

