/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.base.BasePanel;
import com.bmc.ctmconvert.base.BaseProgressBar;
import com.bmc.ctmconvert.base.CliImporter;
import com.bmc.ctmconvert.base.DataImportVendor;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.SourceDefinitions;
import com.bmc.ctmconvert.common.exceptions.ConvertorCancelClickException;
import com.bmc.ctmconvert.connect_direct.CliImporterCD;
import com.bmc.ctmconvert.connect_direct.assessmentReport.CDAssessmentReport;
import com.bmc.ctmconvert.connect_direct.convertor.CDConvertor;
import com.bmc.ctmconvert.connect_direct.reader.CDDataReader;
import com.bmc.ctmconvert.convertor.Convertor;
import com.bmc.ctmconvert.dataObject.DataObject;
import com.bmc.ctmconvert.dataimport.DynamicDataImportPanel;
import com.bmc.ctmconvert.dataimport.EntriesImporter;
import com.bmc.ctmconvert.dataimport.ImportEntryList;
import com.bmc.ctmconvert.dataimport.VendorImporter;
import com.bmc.ctmconvert.interfaces.ConversionReader;
import com.bmc.ctmconvert.interfaces.DefaultVendorData;
import com.bmc.ctmconvert.interfaces.VendorData;
import com.bmc.ctmconvert.services.ConversionEntitiesService;
import com.bmc.ctmconvert.workspace.IWorkspace;
import com.bmc.ctmconvert.workspace.Workspace;
import com.bmc.ctmconvert.workspace.sourceDefinitions.GeneralSourceDefinitions;
import java.nio.file.Path;
import java.nio.file.Paths;

public class AppData
extends DefaultVendorData {
    public String getName() {
        return "CONNECT_DIRECT";
    }

    public String getDisplayName() {
        return "IBM\u00ae Sterling Connect:Direct\u00ae";
    }

    public VendorData.VendorType getVendorType() {
        return VendorData.VendorType.Applications;
    }

    public DataImportVendor getDataImport() {
        return new DynamicDataImportPanel(this.generateImporter(), "LOAD_DATA_CD");
    }

    public CliImporter getCLIImporter() {
        return new CliImporterCD(this.generateImporter());
    }

    private EntriesImporter generateImporter() {
        ImportEntryList entries = this.getImportEntries();
        Path destinationPath = Paths.get(ConversionEntitiesService.getCurrentProjectDataDirectory(), new String[0]);
        return new VendorImporter(entries, destinationPath);
    }

    public BasePanel getAssessmentReport(String path) {
        return new CDAssessmentReport(path, Globs.ASSESSMENT_REPORT_DESCRIPTION_XML, "");
    }

    public SourceDefinitions getSourceDefinition(BaseProgressBar progressBar) throws ConvertorCancelClickException {
        DataObject dataObject = this.getDataObject();
        Workspace workspace = new Workspace();
        CDConvertor convertor = new CDConvertor(dataObject, workspace);
        GeneralSourceDefinitions sourceDefinitions = new GeneralSourceDefinitions((Convertor)convertor, (IWorkspace)workspace);
        convertor.addSourceDefinitions(sourceDefinitions);
        return sourceDefinitions;
    }

    protected ConversionReader getReader() {
        return new CDDataReader(Paths.get(ConversionEntitiesService.getCurrentProjectDataDirectory(), new String[0]));
    }
}

