/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tidal.variables;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FormatHelper {
    private static final String NO_AUTOEDIT_PREFIX = "(?<!%%)";
    private static final String UNIQUE_SEPARATOR_CHARACTERS_OR_WHITESPACE = "^([^a-zA-Z])(\\1|\\s)*$";
    private static final String LONG_YEAR = "(?i)(?<!%%)yyyy";
    private static final String SHORT_YEAR = "(?i)(?<!%%)" + FormatHelper.exactMatch("yy");
    private static final String MONTH_OR_MINUTES = "(?i)(?<!%%)" + FormatHelper.exactMatch("mm");
    private static final String SHORT_NUMERIC_MONTH = "(?i)(?<!%%)" + FormatHelper.exactMatch("m");
    private static final String SHORT_MONTH = "(?i)(?<!%%)" + FormatHelper.exactMatch("mmm");
    private static final String LONG_MONTH = "(?i)(?<!%%)mmmm";
    private static final String DAYS = "(?i)(?<!%%)" + FormatHelper.exactMatch("dd");
    private static final String SHORT_DAYS = "(?i)(?<!%%)" + FormatHelper.exactMatch("d");
    private static final String SHORT_JULIAN_DAYS = "(?i)(?<!%%)" + FormatHelper.exactMatch("j");
    private static final String TWO_DIGIT_JULIAN_DAYS = "(?i)(?<!%%)" + FormatHelper.exactMatch("jj");
    private static final String LONG_JULIAN_DAYS = "(?i)(?<!%%)" + FormatHelper.exactMatch("jjj");
    private static final String MILITARY_HOURS = "(?<!%%)HH";
    private static final String SHORT_MILITARY_HOURS = "(?<!%%)" + FormatHelper.exactMatch("H");
    private static final String SHORT_HOURS = "(?<!%%)" + FormatHelper.exactMatch("h");
    private static final String LONG_HOURS = "(?<!%%)" + FormatHelper.exactMatch("hh");
    private static final String SECONDS = "(?i)(?<!%%)ss";
    private static final String AM_PM = "(?<!%%)(?i)AM/PM";
    private String originalDateOrTimeFormat;
    private boolean isFormatReplacedSuccessfully;
    private String resultDateTimeFormat;
    private String remainingDateTimeFormat;
    private static Map<String, String> supportedDateOrTimeFragments = new LinkedHashMap<String, String>();
    private static Set<String> dateOnlyFragments = new HashSet<String>();
    private static Set<String> timeOnlyFragments = new HashSet<String>();

    private static void addAllDateTimeFragments() {
        FormatHelper.addDateOnlyFragment(LONG_YEAR, FormatHelper.autoEditConcat("%%YYYY"));
        FormatHelper.addDateOnlyFragment(SHORT_YEAR, FormatHelper.autoEditConcat("%%YY"));
        FormatHelper.addDateOnlyFragment(LONG_MONTH, FormatHelper.autoEditConcat("%%MMMM" + FormatHelper.autoEditConcat("%%MM")));
        FormatHelper.addDateOnlyFragment(SHORT_MONTH, FormatHelper.autoEditConcat("%%MMM" + FormatHelper.autoEditConcat("%%MM")));
        supportedDateOrTimeFragments.put(MONTH_OR_MINUTES, FormatHelper.autoEditConcat("%%MM"));
        FormatHelper.addDateOnlyFragment(DAYS, FormatHelper.autoEditConcat("%%DD"));
        FormatHelper.addTimeOnlyFragment(AM_PM, FormatHelper.autoEditConcat("%%AP" + FormatHelper.autoEditConcat("%%HH")));
        FormatHelper.addTimeOnlyFragment(MILITARY_HOURS, FormatHelper.autoEditConcat("%%HH"));
        FormatHelper.addTimeOnlyFragment(LONG_HOURS, FormatHelper.autoEditConcat("%%HL" + FormatHelper.autoEditConcat("%%HH")));
        FormatHelper.addTimeOnlyFragment(SHORT_HOURS, FormatHelper.autoEditConcat("%%H" + FormatHelper.autoEditConcat("%%HH")));
        FormatHelper.addTimeOnlyFragment(SECONDS, FormatHelper.autoEditConcat("%%SS"));
        FormatHelper.addDateOnlyFragment(SHORT_NUMERIC_MONTH, FormatHelper.autoEditConcat("%%NUMBER" + FormatHelper.autoEditConcat("%%MM")));
        FormatHelper.addDateOnlyFragment(SHORT_DAYS, FormatHelper.autoEditConcat("%%NUMBER" + FormatHelper.autoEditConcat("%%DD")));
        FormatHelper.addTimeOnlyFragment(SHORT_MILITARY_HOURS, FormatHelper.autoEditConcat("%%NUMBER" + FormatHelper.autoEditConcat("%%HH")));
        FormatHelper.addDateOnlyFragment(SHORT_JULIAN_DAYS, FormatHelper.autoEditConcat("%%SHORT_JULDAY"));
        FormatHelper.addDateOnlyFragment(LONG_JULIAN_DAYS, FormatHelper.autoEditConcat("%%JULDAY"));
        FormatHelper.addDateOnlyFragment(TWO_DIGIT_JULIAN_DAYS, FormatHelper.autoEditConcat("%%SHORT_JULDAY"));
    }

    private static String autoEditConcat(String autoeditValue) {
        return autoeditValue + ".";
    }

    private static void addDateOnlyFragment(String fragmentPattern, String replacementAutoedit) {
        supportedDateOrTimeFragments.put(fragmentPattern, replacementAutoedit);
        dateOnlyFragments.add(replacementAutoedit);
    }

    private static void addTimeOnlyFragment(String fragmentPattern, String replacementAutoedit) {
        supportedDateOrTimeFragments.put(fragmentPattern, replacementAutoedit);
        timeOnlyFragments.add(replacementAutoedit);
    }

    FormatHelper(String originalFormat) {
        this.originalDateOrTimeFormat = originalFormat;
        this.isFormatReplacedSuccessfully = false;
        this.resultDateTimeFormat = "";
        this.remainingDateTimeFormat = "";
        this.replaceFormatFragments();
    }

    private static String exactMatch(String pattern) {
        Character c = Character.valueOf(pattern.charAt(0));
        return "(?<!" + c + ")" + pattern + "(?!" + c + "{1,3})";
    }

    private String replaceFormatFragments() {
        this.copyOriginalFormat();
        this.replaceSupportedFormatFragmentsInOrder();
        this.checkFormatReplacedSuccessfully();
        return this.getResultDateTimeFormat();
    }

    private void copyOriginalFormat() {
        this.resultDateTimeFormat = this.originalDateOrTimeFormat;
        this.remainingDateTimeFormat = this.originalDateOrTimeFormat;
    }

    private void replaceSupportedFormatFragmentsInOrder() {
        for (Map.Entry<String, String> e : supportedDateOrTimeFragments.entrySet()) {
            String formatFragmentPattern = e.getKey();
            String replacement = e.getValue();
            this.replaceSingleFormatFragment(formatFragmentPattern, replacement);
        }
    }

    private void replaceSingleFormatFragment(String formatFragmentPattern, String replacement) {
        Matcher matcher = Pattern.compile(formatFragmentPattern).matcher(this.remainingDateTimeFormat);
        while (matcher.find()) {
            this.resultDateTimeFormat = this.replaceSegment(this.resultDateTimeFormat, matcher, replacement);
            String spaces = this.repeat(" ", replacement.length());
            this.remainingDateTimeFormat = this.replaceSegment(this.remainingDateTimeFormat, matcher, spaces);
            matcher.reset(this.remainingDateTimeFormat);
        }
    }

    private String repeat(String string, int repetitions) {
        return new String(new char[repetitions]).replace("\u0000", string);
    }

    private String replaceSegment(String input, Matcher matcher, String replacement) {
        return input.substring(0, matcher.start()) + replacement + input.substring(matcher.end());
    }

    private void checkFormatReplacedSuccessfully() {
        String trimmedRemainingDateTimeFormat = this.remainingDateTimeFormat.trim();
        if (!trimmedRemainingDateTimeFormat.isEmpty() && !trimmedRemainingDateTimeFormat.matches(UNIQUE_SEPARATOR_CHARACTERS_OR_WHITESPACE)) {
            this.resultDateTimeFormat = this.originalDateOrTimeFormat;
        } else {
            this.setFormatReplacedSuccessfully(true);
        }
    }

    private void setFormatReplacedSuccessfully(boolean isFormatReplacedSuccessfully) {
        this.isFormatReplacedSuccessfully = isFormatReplacedSuccessfully;
    }

    public String getResultDateTimeFormat() {
        return this.resultDateTimeFormat;
    }

    public boolean isSupportedDateOrTimeFormat() {
        return this.isFormatSupported();
    }

    private boolean isFormatSupported() {
        return this.isFormatReplacedSuccessfully && this.doesNotContainBothDateAndTimeFragments();
    }

    private boolean doesNotContainBothDateAndTimeFragments() {
        return !this.containsAnyDateFormatFragment() || !this.containsAnyTimeFormatFragment();
    }

    private boolean containsAnyTimeFormatFragment() {
        for (String timeFragment : timeOnlyFragments) {
            if (!this.resultDateTimeFormat.contains(timeFragment)) continue;
            return true;
        }
        return false;
    }

    private boolean containsAnyDateFormatFragment() {
        for (String dateFragment : dateOnlyFragments) {
            if (!this.resultDateTimeFormat.contains(dateFragment)) continue;
            return true;
        }
        return false;
    }

    private boolean hasFragment(String fragment) {
        return this.getResultDateTimeFormat().contains(supportedDateOrTimeFragments.get(fragment));
    }

    public boolean hasJulianFormat() {
        return this.hasFragment(LONG_JULIAN_DAYS) || this.hasFragment(SHORT_JULIAN_DAYS);
    }

    public Map<String, String> createDateFormatAutoedits() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (this.containsAnyDateFormatFragment() || this.hasFragment(MONTH_OR_MINUTES)) {
            result.put("%%YYYY", "%%SUBSTR %%RESULT 1 4");
            result.put("%%YY", "%%SUBSTR %%RESULT 3 2");
            result.put("%%MM", "%%SUBSTR %%RESULT 5 2");
            result.put("%%DD", "%%SUBSTR %%RESULT 7 2");
        }
        if (this.hasFragment(SHORT_JULIAN_DAYS) || this.hasFragment(TWO_DIGIT_JULIAN_DAYS)) {
            result.put("%%SHORT_JULDAY", "%%JULDAY %%MINUS 0");
        }
        return result;
    }

    public Map<String, String> createTimeFormatAutoedits() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (this.containsAnyTimeFormatFragment() || this.hasFragment(MONTH_OR_MINUTES)) {
            result.put("%%HH", "%%SUBSTR %%RESULT 1 2");
            result.put("%%MM", "%%SUBSTR %%RESULT 3 2");
            result.put("%%SS", "%%SUBSTR %%RESULT 5 2");
        }
        return result;
    }

    static {
        FormatHelper.addAllDateTimeFragments();
    }
}

