/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tidal.ftp;

import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.tidal.ftp.TidalFTPCommand;
import com.bmc.ctmconvert.tidal.ftp.TidalFTPParams;
import java.util.LinkedHashMap;

public class TidalFTPDetails {
    private static final LinkedHashMap<TidalFTPCommand, String> commandEnumToCTMString = new LinkedHashMap();
    private static final String UNIX = "Unix";
    private static final String WINDOWS = "Windows";
    private static final String DEFAULT_FTP_USER = "DEFAULT_FTP_USER";
    private TidalFTPParams ftpParams;
    private String remoteUser = "DEFAULT_FTP_USER";
    private String rightSidePath = "";
    private String leftSidePath = "";
    private String ftpParamsString = "";
    private String protocolInfo = "";
    private String transferDirection = "4";
    private String localHost = "defaultLocalHost";
    private String localOS = "Unix";
    private String ctmCommandString = "";

    public TidalFTPDetails(IAttrHolder jobDtlRecord, String nodeId, Boolean isRunningOnWin) {
        this.protocolInfo = jobDtlRecord.getAttr("JOBDTL_EXTINFO");
        this.ftpParamsString = jobDtlRecord.getAttr("JOBDTL_PARAMS");
        this.ftpParams = new TidalFTPParams(this.ftpParamsString, this.protocolInfo);
        this.rightSidePath = jobDtlRecord.getAttr("JOBDTL_CMD");
        this.leftSidePath = jobDtlRecord.getAttr("JOBDTL_ENVFILE");
        this.localHost = nodeId;
        this.localOS = isRunningOnWin != false ? WINDOWS : UNIX;
        this.initCommandSpecificFields();
    }

    private void initCommandSpecificFields() {
        this.transferDirection = "4";
        switch (this.ftpParams.getFTP_COMMAND()) {
            case MGET: 
            case GET: {
                this.transferDirection = "1";
                break;
            }
            case MPUT: 
            case PUT: {
                this.transferDirection = "0";
                break;
            }
            case DELETE_DIR: 
            case DELETE: 
            case MDELETE: 
            case MAKE: 
            case RENAME: {
                this.ctmCommandString = commandEnumToCTMString.get((Object)this.ftpParams.getFTP_COMMAND());
                break;
            }
        }
    }

    private String getPathSeperator() {
        return this.localOS.equalsIgnoreCase(WINDOWS) ? "\\" : "/";
    }

    public String getTransferDirection() {
        return this.transferDirection;
    }

    public TidalFTPParams getFtpParams() {
        return this.ftpParams;
    }

    public String getLocalHost() {
        return this.localHost;
    }

    public String getLocalOS() {
        return this.localOS;
    }

    public String getRightSidePath() {
        return this.rightSidePath;
    }

    public String getLeftSidePath() {
        return this.leftSidePath;
    }

    public String getCtmCommandString() {
        return this.ctmCommandString;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public String getRightSideWithFilename() {
        return this.composeAbsolutePath(this.ftpParams.getFilename(), this.rightSidePath);
    }

    public String getLeftSideWithFilename() {
        return this.composeAbsolutePath(this.ftpParams.getFilename(), this.leftSidePath);
    }

    public String getLeftSideWithNewFilename() {
        return this.composeAbsolutePath(this.ftpParams.getNewFilename(), this.leftSidePath);
    }

    private String composeAbsolutePath(String filename, String pathToFile) {
        boolean requiresSeperator;
        String result = pathToFile + filename;
        boolean pathElementsNotEmpty = !"".equals(pathToFile) && !"".equals(filename);
        boolean bl = requiresSeperator = !pathToFile.endsWith("/") && !pathToFile.endsWith("\\");
        if (pathElementsNotEmpty && requiresSeperator) {
            result = pathToFile + this.getPathSeperator() + filename;
        }
        return result;
    }

    static {
        commandEnumToCTMString.put(TidalFTPCommand.DELETE, "rm");
        commandEnumToCTMString.put(TidalFTPCommand.MDELETE, "rm");
        commandEnumToCTMString.put(TidalFTPCommand.DELETE_DIR, "rmdir");
        commandEnumToCTMString.put(TidalFTPCommand.RENAME, "rename");
        commandEnumToCTMString.put(TidalFTPCommand.MAKE, "mkdir");
    }
}

