/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tidal.export;

import com.bmc.ctmconvert.base.BaseProgressBar;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.common.exceptions.ConvertorCancelClickException;
import com.csvreader.CsvWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;

public class TableExport {
    static final String EXT = ".csv";
    static SimpleDateFormat sdf = null;
    private Connection m_con;
    private String m_tabname;
    private int m_count;
    private String m_file;
    private BaseProgressBar m_progressBar;

    public TableExport(Connection con, String tabname, int verbose) {
        this(con, tabname, verbose, null);
    }

    public TableExport(Connection con, String tabname, int verbose, BaseProgressBar pb) {
        this.m_progressBar = pb;
        this.m_con = con;
        this.m_tabname = tabname.trim();
    }

    public int exists() {
        int i = -1;
        int j = 0;
        try {
            DatabaseMetaData dbm = this.m_con.getMetaData();
            ResultSet rs1 = dbm.getTables(null, null, this.m_tabname.toUpperCase(), null);
            ResultSet rs2 = dbm.getTables(null, null, this.m_tabname.toLowerCase(), null);
            ResultSet rs3 = dbm.getTables(null, null, this.m_tabname, null);
            if (rs1.next()) {
                ++j;
            }
            if (rs2.next()) {
                ++j;
            }
            if (rs3.next()) {
                ++j;
            }
            i = j > 0 ? 1 : 0;
        }
        catch (SQLException sqle) {
            ExceptionHandler.writeToExceptionFile((Exception)sqle);
        }
        return i;
    }

    public int count() {
        try {
            this.m_count = -1;
            PreparedStatement ps = this.m_con.prepareStatement("select count(*) from " + this.m_tabname);
            ResultSet results = ps.executeQuery();
            if (results != null && results.next()) {
                this.m_count = results.getInt(1);
                ps.close();
            }
        }
        catch (SQLException sqle) {
            ExceptionHandler.writeToExceptionFile((Exception)sqle);
        }
        return this.m_count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int export(String dir) throws ConvertorCancelClickException {
        int ret = -1;
        this.m_file = dir + "/" + this.m_tabname.toUpperCase() + EXT;
        CsvWriter m_writer = new CsvWriter(this.m_file);
        ResultSetMetaData metaData = null;
        PreparedStatement ps = null;
        ResultSet results = null;
        try {
            ps = this.m_con.prepareStatement("select * from " + this.m_tabname);
            results = ps.executeQuery();
            if (results == null) {
                ret = -1;
            }
            if ((ret = this.count()) == 0) {
                int n = 0;
                return n;
            }
            metaData = results.getMetaData();
            int columnCount = metaData.getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                m_writer.write(metaData.getColumnLabel(i).toUpperCase());
            }
            m_writer.endRecord();
            m_writer.flush();
            int recordCounter = 0;
            while (results.next()) {
                if (this.m_progressBar != null && this.m_progressBar.isCancelled()) {
                    ps.close();
                    throw new ConvertorCancelClickException();
                }
                for (int i = 1; i <= columnCount; ++i) {
                    if (metaData.getColumnType(i) == 91 || metaData.getColumnType(i) == 93) {
                        if (sdf == null) {
                            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
                        }
                        if (metaData.getColumnType(i) == 91) {
                            Date d = results.getDate(i);
                            if (d != null) {
                                m_writer.write(sdf.format(d));
                            } else {
                                m_writer.write(results.getString(i));
                            }
                        }
                        if (metaData.getColumnType(i) != 93) continue;
                        Timestamp ts = results.getTimestamp(i);
                        if (ts != null) {
                            m_writer.write(sdf.format(ts));
                            continue;
                        }
                        m_writer.write(results.getString(i));
                        continue;
                    }
                    m_writer.write(results.getString(i));
                }
                if (this.m_progressBar != null) {
                    this.m_progressBar.setLabel(TextManager.instance().get("TIDAL_PROGRESS_BAR_TABLE_LABEL") + ": " + this.m_tabname + " (" + recordCounter + "/" + ret + " " + TextManager.instance().get("TIDAL_PROGRESS_BAR_RECORDS_LABEL") + ")");
                }
                ++recordCounter;
                m_writer.endRecord();
                m_writer.flush();
            }
        }
        catch (SQLException sqle) {
            ExceptionHandler.writeToExceptionFile((Exception)sqle);
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        finally {
            try {
                m_writer.close();
                if (results != null) {
                    results.close();
                }
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                ExceptionHandler.writeToExceptionFile((Exception)e);
            }
        }
        return ret;
    }
}

