/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tidal.export;

import com.bmc.ctmconvert.base.BaseProgressBar;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.common.exceptions.ConvertorCancelClickException;
import com.bmc.ctmconvert.tidal.export.TableExport;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.net.ConnectException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Scanner;

public class DBExport {
    Connection m_dbCon;
    private BufferedWriter m_log = null;
    private String m_outDir;
    private String m_stmt;
    private BaseProgressBar m_progressBar;
    private int totalTables = 0;

    public DBExport(String logFullPathFile, String dbType, String user, String outDir, Connection con) {
        this(logFullPathFile, dbType, user, outDir, con, null);
    }

    public DBExport(String logFullPathFile, String dbType, String user, String outDir, Connection con, BaseProgressBar pb) {
        this.m_progressBar = pb;
        String log = null;
        try {
            if (dbType.compareTo("ORACLE") == 0) {
                log = logFullPathFile;
                this.m_stmt = "select TABLE_NAME from USER_TABLES";
            }
            if (dbType.compareTo("MSSQL") == 0) {
                log = logFullPathFile;
                this.m_stmt = "select name from sysobjects where type='U'";
            }
            this.m_dbCon = con;
            this.m_log = new BufferedWriter(new FileWriter(log));
            this.m_log.write("Conversion log file ");
            this.m_log.newLine();
            this.m_outDir = outDir;
            this.m_log.flush();
        }
        catch (FileNotFoundException fnf) {
            System.err.println(fnf.getMessage());
            return;
        }
        catch (ConnectException sqle) {
            System.err.println(sqle);
            System.err.println("Cannot connect to database server.");
            return;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int one_tab(String tabName) throws ConvertorCancelClickException {
        try {
            int i;
            String line = tabName.trim();
            this.m_log.write("Table " + line + " ");
            TableExport tab = new TableExport(this.m_dbCon, line, 0, this.m_progressBar);
            int res = tab.exists();
            if (res == 1) {
                i = tab.count();
                tab.export(this.m_outDir);
                this.m_log.write("Count=" + i);
                this.m_log.newLine();
                this.m_log.flush();
            }
            if (res == 0) {
                this.m_log.write(" Not Found");
                this.m_log.newLine();
                this.m_log.flush();
            }
            if (res == -1) {
                this.m_log.write("SQL Error");
                this.m_log.newLine();
                this.m_log.flush();
                System.out.println("SQL Error.");
                i = -1;
                return i;
            }
            i = 0;
            return i;
        }
        catch (IOException fnf) {
            System.err.println(fnf.getMessage());
            int n = -1;
            return n;
        }
        finally {
            try {
                if (this.m_log != null) {
                    this.m_log.flush();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public boolean export() throws ConvertorCancelClickException {
        ArrayList<String> tables2Export = new ArrayList<String>();
        int ret = -1;
        try {
            if (this.m_progressBar != null) {
                this.m_progressBar.setLabel(TextManager.instance().get("TIDAL_PROCESSONG_TIDAL_DATA_PROGRESS_BAR_STATUS"));
            }
            PreparedStatement ps = this.m_dbCon.prepareStatement(this.m_stmt);
            this.getTableNames(tables2Export);
            if (this.m_progressBar != null) {
                this.totalTables = tables2Export.size();
                this.m_progressBar.setProgressMax(this.totalTables);
            }
            int tableCounter = 0;
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String line;
                if (this.m_progressBar != null) {
                    if (this.m_progressBar.isCancelled()) {
                        throw new ConvertorCancelClickException();
                    }
                    this.m_progressBar.setProgressValue(tableCounter);
                }
                if (!tables2Export.contains((line = rs.getString(1)).toUpperCase())) continue;
                ret = this.one_tab(line);
                if (ret == -1) {
                    return false;
                }
                ++tableCounter;
            }
        }
        catch (ConvertorCancelClickException e) {
            try {
                this.m_log.close();
                throw e;
            }
            catch (IOException ioE) {
                ExceptionHandler.writeToExceptionFile((Exception)((Object)e));
                ExceptionHandler.writeToExceptionFile((Exception)ioE);
            }
        }
        catch (SQLException sqle) {
            ExceptionHandler.writeToExceptionFile((Exception)sqle);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getTableNames(ArrayList<String> tables2Export) {
        File exportTableList = new File(Globs.TIDAL_TABLES_TO_EXPORT_FILE);
        if (exportTableList.exists()) {
            try (Scanner scanner = null;){
                scanner = new Scanner(exportTableList);
                while (scanner.hasNextLine()) {
                    String table = scanner.nextLine();
                    if (table.trim().startsWith("#")) continue;
                    tables2Export.add(table.trim());
                }
            }
        }
    }
}

